/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.XpathChooserDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class EisPrimaryKeysPanel
extends AbstractSubjectPanel {
    EisPrimaryKeysPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((LayoutManager)new GridBagLayout(), valueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PRIMARY_KEYS_PANEL.TITLE"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AddRemoveListPanel addRemoveListPanel = this.buildPrimaryKeysList();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)addRemoveListPanel, gridBagConstraints);
        this.addPaneForAlignment(addRemoveListPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveListPanel buildPrimaryKeysList() {
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildPrimaryKeysAddRemoveAdapter(), this.buildPrimaryKeysHolder(), 3);
        addRemoveListPanel.setBorder(this.buildStandardEmptyBorder());
        addRemoveListPanel.setCellRenderer(this.buildPrimaryKeysListCellRenderer());
        return addRemoveListPanel;
    }

    private AddRemovePanel.Adapter buildPrimaryKeysAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                objectListSelectionModel.setSelectedValues(EisPrimaryKeysPanel.this.addPrimaryKeys());
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                EisPrimaryKeysPanel.this.removePrimaryKeys(objectListSelectionModel.getSelectedValues());
            }
        };
    }

    private Object[] addPrimaryKeys() {
        MWXmlPrimaryKeyPolicy mWXmlPrimaryKeyPolicy = this.xmlDescriptor().primaryKeyPolicy();
        MWXmlField mWXmlField = mWXmlPrimaryKeyPolicy.buildEmptyPrimaryKey();
        XpathChooserDialog.promptToSelectXpath(mWXmlField, this.getWorkbenchContext());
        if (mWXmlField.isSpecified()) {
            mWXmlPrimaryKeyPolicy.addPrimaryKey(mWXmlField);
            return new Object[]{mWXmlField};
        }
        return new Object[0];
    }

    private void removePrimaryKeys(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.xmlDescriptor().primaryKeyPolicy().removePrimaryKey((MWXmlField)objectArray[i]);
        }
    }

    private ListValueModel buildPrimaryKeysHolder() {
        return new CollectionListValueModelAdapter(new CollectionAspectAdapter(this.buildPrimaryKeyPolicyHolder(), "primaryKeys"){

            protected Iterator getValueFromSubject() {
                return ((MWXmlPrimaryKeyPolicy)this.subject).primaryKeys();
            }

            protected int sizeFromSubject() {
                return ((MWXmlPrimaryKeyPolicy)this.subject).primaryKeysSize();
            }
        });
    }

    private ValueModel buildPrimaryKeyPolicyHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            protected Object getValueFromSubject() {
                return ((MWXmlDescriptor)this.subject).primaryKeyPolicy();
            }
        };
    }

    private ListCellRenderer buildPrimaryKeysListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return ((MWXmlField)object).getXpath();
            }
        };
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.getSubjectHolder().getValue();
    }

    public String helpTopicId() {
        return "descriptor.eis.primaryKeys";
    }
}

