/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerEditingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

public final class AttributeTransformerPanel
extends AbstractSubjectPanel {
    public AttributeTransformerPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildAttributeTransformerLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        Component component = this.buildAttributeTransformerComponent();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add(component, gridBagConstraints);
        JButton jButton = this.buildAttributeTransformerEditButton();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        this.addAlignRight(jButton);
        jLabel.setLabelFor(jButton);
        SwingComponentFactory.updateButtonAccessibleName(jLabel, jButton);
        this.addHelpTopicId(this, "mapping.transformation.attributeTransformer");
    }

    private JLabel buildAttributeTransformerLabel() {
        return SwingComponentFactory.buildLabel("ATTRIBUTE_TRANSFORMER_LABEL", this.resourceRepository());
    }

    private Component buildAttributeTransformerComponent() {
        JList jList = SwingComponentFactory.buildList(this.buildAttributeTransformerListModel());
        jList.setCellRenderer(this.buildTransformerListCellRenderer());
        jList.setDoubleBuffered(true);
        jList.setVisibleRowCount(1);
        jList.setPreferredSize(new Dimension(0, 0));
        return new JScrollPane(jList, 21, 31);
    }

    private ListModel buildAttributeTransformerListModel() {
        return new ListModelAdapter(this.buildAttributeTransformerCollectionValue());
    }

    private CollectionValueModel buildAttributeTransformerCollectionValue() {
        return new PropertyCollectionValueModelAdapter(this.buildAttributeTransformerPropertyValue());
    }

    private PropertyValueModel buildAttributeTransformerPropertyValue() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "attributeTransformer"){

            protected Object getValueFromSubject() {
                return ((MWTransformationMapping)this.subject).getAttributeTransformer();
            }
        };
    }

    private ListCellRenderer buildTransformerListCellRenderer() {
        return new AdaptableListCellRenderer(new TransformerCellRendererAdapter(this.resourceRepository()));
    }

    private JButton buildAttributeTransformerEditButton() {
        JButton jButton = new JButton(this.resourceRepository().getString("ATTRIBUTE_TRANSFORMER_EDIT_BUTTON"));
        jButton.addActionListener(this.buildAttributeTransformerEditAction());
        return jButton;
    }

    private ActionListener buildAttributeTransformerEditAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MWTransformationMapping mWTransformationMapping = (MWTransformationMapping)AttributeTransformerPanel.this.subject();
                WorkbenchContext workbenchContext = AttributeTransformerPanel.this.getWorkbenchContext();
                TransformerEditingDialog.promptToEditAttributeTransformer(mWTransformationMapping, workbenchContext);
            }
        };
    }
}

