/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.DefaultingContainerClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;

public final class DirectMapContainerPolicyPanel
extends AbstractSubjectPanel {
    private PropertyValueModel directMapContainerPolicyHolder;
    private PropertyValueModel defaultingContainerClassHolder;

    public DirectMapContainerPolicyPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(ValueModel valueModel) {
        super.initialize(valueModel);
        this.directMapContainerPolicyHolder = this.buildDirectMapContainerPolicyHolder();
        this.defaultingContainerClassHolder = this.buildDefaultingContainerClassHolder();
    }

    private PropertyValueModel buildDefaultingContainerClassHolder() {
        return new PropertyAspectAdapter(this.directMapContainerPolicyHolder){

            protected Object getValueFromSubject() {
                return ((MWDirectMapContainerPolicy)this.subject).getDefaultingContainerClass();
            }
        };
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return ((MWModel)DirectMapContainerPolicyPanel.this.subject()).getRepository();
            }
        };
    }

    private ItemListener buildContainerClassChooserEnabler(final ClassChooserPanel classChooserPanel) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                classChooserPanel.setEnabled(itemEvent.getStateChange() == 1);
            }
        };
    }

    private PropertyValueModel buildDirectMapContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "containerClass"){

            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).getContainerClass();
            }

            protected void setValueOnSubject(Object object) {
                ((DefaultingContainerClass)this.subject).setContainerClass((MWClass)object);
            }
        };
    }

    private PropertyValueModel buildDirectMapContainerPolicyHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerPolicy"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectMapMapping)this.subject).getContainerPolicy();
            }
        };
    }

    private ButtonModel buildOverrideDefaultClassCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildOverrideDefaultClassHolder());
    }

    private PropertyValueModel buildOverrideDefaultClassHolder() {
        return new TransformationPropertyValueModel(this.buildUseDefaultContainerClassHolder()){

            private Boolean oppositeValue(Boolean bl) {
                return bl == null ? null : Boolean.valueOf(bl == false);
            }

            protected Object reverseTransform(Object object) {
                return this.oppositeValue((Boolean)object);
            }

            protected Object transform(Object object) {
                return this.oppositeValue((Boolean)object);
            }
        };
    }

    private PropertyValueModel buildUseDefaultContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "usesDefaultContainerClass"){

            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).usesDefaultContainerClass();
            }

            protected void setValueOnSubject(Object object) {
                ((DefaultingContainerClass)this.subject).setUseDefaultContainerClass(((Boolean)object).booleanValue());
            }
        };
    }

    protected void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JCheckBox jCheckBox = this.buildCheckBox("COLLECTION_CONTAINER_POLICY_OVERRIDE_DEFAULT_CLASS_CHECK_BOX", this.buildOverrideDefaultClassCheckBoxAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jCheckBox, gridBagConstraints);
        this.addAlignLeft(jCheckBox);
        ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(this.buildDirectMapContainerClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), new JLabel(this.resourceRepository().getString("COLLECTION_CONTAINER_POLICY_OVERRIDE_DEFAULT_CLASS_CHECK_BOX")), this.getWorkbenchContextHolder());
        classChooserPanel.setEnabled(jCheckBox.isSelected());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)classChooserPanel, gridBagConstraints);
        this.addPaneForAlignment(classChooserPanel);
        jCheckBox.addItemListener(this.buildContainerClassChooserEnabler(classChooserPanel));
        this.addHelpTopicId(this, "mapping.containerPolicy");
    }
}

