/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public final class MethodAccessingPanel
extends AbstractSubjectPanel {
    private ListCellRenderer methodListCellRenderer;
    private PropertyValueModel methodAccessingHolder;

    public MethodAccessingPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(ValueModel valueModel) {
        super.initialize(valueModel);
        this.methodAccessingHolder = this.buildMethodAccessingHolder();
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        JCheckBox jCheckBox = this.buildMethodAccessingCheckBox();
        Pane pane = new Pane(new GridBagLayout());
        GroupBox groupBox = new GroupBox(jCheckBox, (JComponent)pane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)groupBox, gridBagConstraints);
        JComponent jComponent = this.buildLabeledComponent("GET_METHOD_LABEL", this.buildGetMethodChooser());
        arrayList.add(jComponent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildLabeledComponent("SET_METHOD_LABEL", this.buildSetMethodChooser());
        arrayList.add(jComponent2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)jComponent2, gridBagConstraints);
        this.addHelpTopicId(this, "mapping.methodAccessing");
        new ComponentEnabler((ValueModel)this.methodAccessingHolder, arrayList);
    }

    private JCheckBox buildMethodAccessingCheckBox() {
        JCheckBox jCheckBox = this.buildCheckBox("USE_METHOD_ACCESSING_CHECK_BOX", new CheckBoxModelAdapter(this.methodAccessingHolder));
        return jCheckBox;
    }

    private PropertyValueModel buildMethodAccessingHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "usesMethodAccessing"){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).usesMethodAccessing();
            }

            protected void setValueOnSubject(Object object) {
                ((MWMapping)this.subject).setUsesMethodAccessing(((Boolean)object).booleanValue());
            }
        };
    }

    private ListChooser buildGetMethodChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildGetMethodComboBoxModel(), this.getWorkbenchContextHolder(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()), this.buildGetMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildGetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildGetMethodHolder(), this.getSubjectHolder()){

            protected ListIterator listValueFromSubject(Object object) {
                return MethodAccessingPanel.this.orderedGetMethodChoices((MWMapping)object);
            }
        });
    }

    private PropertyValueModel buildGetMethodHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSubjectHolder(), "getMethod"){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getGetMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWMapping)this.subject).setGetMethod((MWMethod)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "signature");
    }

    ListIterator orderedGetMethodChoices(MWMapping mWMapping) {
        return CollectionTools.sort((Iterator)this.getMethodChoices(mWMapping)).listIterator();
    }

    private Iterator getMethodChoices(MWMapping mWMapping) {
        return mWMapping.candidateGetMethods();
    }

    private DefaultListChooserDialog.Builder buildGetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("GET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("GET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildSetMethodChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildSetMethodComboBoxModel(), this.getWorkbenchContextHolder(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()), this.buildSetMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildSetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildSetMethodHolder(), this.getSubjectHolder()){

            protected ListIterator listValueFromSubject(Object object) {
                return MethodAccessingPanel.this.orderedSetMethodChoices((MWMapping)object);
            }
        });
    }

    private PropertyValueModel buildSetMethodHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSubjectHolder(), "setMethod"){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getSetMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWMapping)this.subject).setSetMethod((MWMethod)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "signature");
    }

    ListIterator orderedSetMethodChoices(MWMapping mWMapping) {
        return CollectionTools.sort((Iterator)this.setMethodChoices(mWMapping)).listIterator();
    }

    private Iterator setMethodChoices(MWMapping mWMapping) {
        return mWMapping.candidateSetMethods();
    }

    private DefaultListChooserDialog.Builder buildSetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private StringConverter buildMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWMethod)object).getName();
            }
        };
    }

    private ListCellRenderer getMethodListCellRenderer() {
        if (this.methodListCellRenderer == null) {
            this.methodListCellRenderer = new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()));
        }
        return this.methodListCellRenderer;
    }
}

