/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWClassBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMethodBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerEditingPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class TransformerEditingDialog
extends AbstractValidatingDialog {
    private TransformerEditor transformerEditor;
    private boolean noError = true;

    public static void promptToEditAttributeTransformer(MWTransformationMapping mWTransformationMapping, WorkbenchContext workbenchContext) {
        AttributeTransformerEditor attributeTransformerEditor = new AttributeTransformerEditor(mWTransformationMapping);
        TransformerEditingDialog transformerEditingDialog = new TransformerEditingDialog(attributeTransformerEditor, workbenchContext);
        transformerEditingDialog.show();
        if (transformerEditingDialog.wasConfirmed()) {
            attributeTransformerEditor.commit();
        }
    }

    public static void promptToAddFieldTransformerAssociationForAggregate(MWRelationalTransformationMapping mWRelationalTransformationMapping, WorkbenchContext workbenchContext) {
        MWRelationalFieldTransformerAssociation mWRelationalFieldTransformerAssociation = mWRelationalTransformationMapping.buildEmptyFieldTransformerAssociation();
        FieldTransformerEditor fieldTransformerEditor = new FieldTransformerEditor((MWFieldTransformerAssociation)mWRelationalFieldTransformerAssociation);
        TransformerEditingDialog transformerEditingDialog = new TransformerEditingDialog(fieldTransformerEditor, workbenchContext);
        transformerEditingDialog.show();
        if (transformerEditingDialog.wasConfirmed()) {
            fieldTransformerEditor.commit();
            mWRelationalTransformationMapping.addFieldTransformerAssociation((MWFieldTransformerAssociation)mWRelationalFieldTransformerAssociation);
        }
    }

    public static void promptToEditFieldTransformerAssociationForAggregate(MWRelationalFieldTransformerAssociation mWRelationalFieldTransformerAssociation, WorkbenchContext workbenchContext) {
        FieldTransformerEditor fieldTransformerEditor = new FieldTransformerEditor((MWFieldTransformerAssociation)mWRelationalFieldTransformerAssociation);
        TransformerEditingDialog transformerEditingDialog = new TransformerEditingDialog(fieldTransformerEditor, workbenchContext);
        transformerEditingDialog.show();
        if (transformerEditingDialog.wasConfirmed()) {
            fieldTransformerEditor.commit();
        }
    }

    private TransformerEditingDialog(TransformerEditor transformerEditor, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.initialize(transformerEditor);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("TRANSFORMER_EDITING_DIALOG.TITLE"));
        this.getOKAction().setEnabled(false);
    }

    private void initialize(TransformerEditor transformerEditor) {
        this.transformerEditor = transformerEditor;
        this.transformerEditor.transformationMethodHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.transformerEditor.transformerClassHolder().addPropertyChangeListener("value", this.buildValidatingListener());
        this.transformerEditor.transformerTypeHolder().addPropertyChangeListener("value", this.buildValidatingListener());
    }

    private PropertyChangeListener buildValidatingListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TransformerEditingDialog.this.updateErrorMessage();
                TransformerEditingDialog.this.updateOKAction();
            }
        };
    }

    private void updateErrorMessage() {
        if (this.transformerEditor.transformerType() == "nullTransformer") {
            this.setErrorMessageKey("TRANSFORMER_EDITING_DIALOG.NULL_TRANSFORMER_ERROR");
        } else if (this.transformerEditor.transformerType() == "transformerClass" && this.transformerEditor.transformerClass() == null) {
            this.setErrorMessageKey("TRANSFORMER_EDITING_DIALOG.NULL_TRANSFORMER_CLASS_ERROR");
        } else if (this.transformerEditor.transformerType() == "transformationMethod" && this.transformerEditor.transformationMethod() == null) {
            this.setErrorMessageKey("TRANSFORMER_EDITING_DIALOG.NULL_TRANSFORMATION_METHOD_ERROR");
        } else {
            this.clearErrorMessage();
        }
        if (this.transformerEditor.transformerType() == "transformationMethod" && this.transformerEditor.transformationMethod() != null && !this.transformerEditor.transformationMethodIsValid()) {
            this.setWarningMessageKey("TRANSFORMER_EDITING_DIALOG.INVALID_TRANSFORMATION_METHOD_WARNING");
        } else {
            this.clearWarningMessage();
        }
    }

    protected void setErrorMessage(String string) {
        super.setErrorMessage(string);
        this.noError = string == null;
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.noError = true;
    }

    private void updateOKAction() {
        this.getOKAction().setEnabled(this.noError);
    }

    protected Component buildMainPanel() {
        return new TransformerEditingPanel(this.transformerEditor, (WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
    }

    protected String helpTopicId() {
        return "dialog.editTransformer";
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.setSize(Math.max(500, this.getWidth()), this.getHeight());
    }

    static class FieldTransformerEditor
    extends AbstractTransformerEditor {
        private MWFieldTransformerAssociation association;

        FieldTransformerEditor(MWFieldTransformerAssociation mWFieldTransformerAssociation) {
            this.association = mWFieldTransformerAssociation;
        }

        protected MWTransformationMapping transformationMapping() {
            return this.association.getMapping();
        }

        public Iterator candidateTransformationMethods() {
            return this.transformationMapping().candidateFieldTransformationMethods();
        }

        public boolean transformationMethodIsValid() {
            return this.transformationMethod().isCandidateFieldTransformerMethod();
        }

        protected PropertyValueModel buildInternalMethodHolder() {
            return new PropertyAspectAdapter("fieldTransformer", (Model)this.association){

                protected Object getValueFromSubject() {
                    MWTransformer mWTransformer = ((MWFieldTransformerAssociation)this.subject).getFieldTransformer();
                    if (mWTransformer instanceof MWMethodBasedTransformer) {
                        return ((MWMethodBasedTransformer)mWTransformer).getMethod();
                    }
                    return null;
                }

                protected void setValueOnSubject(Object object) {
                    ((MWFieldTransformerAssociation)this.subject).setFieldTransformer((MWMethod)object);
                }
            };
        }

        protected PropertyValueModel buildInternalClassHolder() {
            return new PropertyAspectAdapter("fieldTransformer", (Model)this.association){

                protected Object getValueFromSubject() {
                    MWTransformer mWTransformer = ((MWFieldTransformerAssociation)this.subject).getFieldTransformer();
                    if (mWTransformer instanceof MWClassBasedTransformer) {
                        return ((MWClassBasedTransformer)mWTransformer).getTransformerClass();
                    }
                    return null;
                }

                protected void setValueOnSubject(Object object) {
                    ((MWFieldTransformerAssociation)this.subject).setFieldTransformer((MWClass)object);
                }
            };
        }
    }

    static class AttributeTransformerEditor
    extends AbstractTransformerEditor {
        private MWTransformationMapping transformationMapping;

        private AttributeTransformerEditor(MWTransformationMapping mWTransformationMapping) {
            this.transformationMapping = mWTransformationMapping;
        }

        protected MWTransformationMapping transformationMapping() {
            return this.transformationMapping;
        }

        public Iterator candidateTransformationMethods() {
            return this.transformationMapping().candidateAttributeTransformationMethods();
        }

        public boolean transformationMethodIsValid() {
            return this.transformationMethod().isCandidateAttributeTransformerMethod();
        }

        protected PropertyValueModel buildInternalMethodHolder() {
            return new PropertyAspectAdapter("attributeTransformer", (Model)this.transformationMapping){

                protected Object getValueFromSubject() {
                    MWTransformer mWTransformer = ((MWTransformationMapping)this.subject).getAttributeTransformer();
                    if (mWTransformer instanceof MWMethodBasedTransformer) {
                        return ((MWMethodBasedTransformer)mWTransformer).getMethod();
                    }
                    return null;
                }

                protected void setValueOnSubject(Object object) {
                    ((MWTransformationMapping)this.subject).setAttributeTransformer((MWMethod)object);
                }
            };
        }

        protected PropertyValueModel buildInternalClassHolder() {
            return new PropertyAspectAdapter("attributeTransformer", (Model)this.transformationMapping){

                protected Object getValueFromSubject() {
                    MWTransformer mWTransformer = ((MWTransformationMapping)this.subject).getAttributeTransformer();
                    if (mWTransformer instanceof MWClassBasedTransformer) {
                        return ((MWClassBasedTransformer)mWTransformer).getTransformerClass();
                    }
                    return null;
                }

                protected void setValueOnSubject(Object object) {
                    ((MWTransformationMapping)this.subject).setAttributeTransformer((MWClass)object);
                }
            };
        }
    }

    static abstract class AbstractTransformerEditor
    implements TransformerEditor {
        private PropertyValueModel transformerTypeHolder;
        private BufferedPropertyValueModel methodHolder;
        private BufferedPropertyValueModel.Trigger methodTrigger = new BufferedPropertyValueModel.Trigger();
        private BufferedPropertyValueModel classHolder;
        private BufferedPropertyValueModel.Trigger classTrigger = new BufferedPropertyValueModel.Trigger();

        protected AbstractTransformerEditor() {
        }

        public PropertyValueModel transformerTypeHolder() {
            if (this.transformerTypeHolder == null) {
                this.transformerTypeHolder = this.buildTransformerTypeHolder();
            }
            return this.transformerTypeHolder;
        }

        protected PropertyValueModel buildTransformerTypeHolder() {
            String string = "nullTransformer";
            if (this.transformerClass() != null) {
                string = "transformerClass";
            } else if (this.transformationMethod() != null) {
                string = "transformationMethod";
            }
            return new SimplePropertyValueModel(string);
        }

        public String transformerType() {
            return (String)this.transformerTypeHolder().getValue();
        }

        public PropertyValueModel transformationMethodHolder() {
            if (this.methodHolder == null) {
                this.methodHolder = this.buildMethodHolder();
            }
            return this.methodHolder;
        }

        private BufferedPropertyValueModel buildMethodHolder() {
            return new BufferedPropertyValueModel(this.buildInternalMethodHolder(), this.methodTrigger);
        }

        protected abstract PropertyValueModel buildInternalMethodHolder();

        public MWMethod transformationMethod() {
            return (MWMethod)this.transformationMethodHolder().getValue();
        }

        public PropertyValueModel transformerClassHolder() {
            if (this.classHolder == null) {
                this.classHolder = this.buildClassHolder();
            }
            return this.classHolder;
        }

        private BufferedPropertyValueModel buildClassHolder() {
            return new BufferedPropertyValueModel(this.buildInternalClassHolder(), this.classTrigger);
        }

        protected abstract PropertyValueModel buildInternalClassHolder();

        public MWClass transformerClass() {
            return (MWClass)this.transformerClassHolder().getValue();
        }

        public MWClassRepository classRepository() {
            return this.transformationMapping().getRepository();
        }

        protected abstract MWTransformationMapping transformationMapping();

        public void commit() {
            if (this.transformerType() == "transformationMethod") {
                this.methodTrigger.accept();
            } else if (this.transformerType() == "transformerClass") {
                this.classTrigger.accept();
            }
        }
    }

    public static interface TransformerEditor
    extends TransformerEditingPanel.TransformerSpec {
        public void commit();
    }
}

