/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ReferenceCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.ColumnPairsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.NewTableReferenceDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

abstract class AbstractTableReferencePanel
extends AbstractSubjectPanel {
    AbstractTableReferencePanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
    }

    private ActionListener buildCreateNewReferenceAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTableReferencePanel.this.createNewReference();
            }
        };
    }

    protected ColumnPairsPanel buildColumnPairsPanel() {
        return new ColumnPairsPanel(this.getWorkbenchContextHolder(), this.buildTableReferenceHolder());
    }

    private ListChooser buildTableReferenceChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildExtendedTableReferenceComboBoxModel(), this.getWorkbenchContextHolder(), this.buildTableReferenceNodeSelector(), this.buildTableReferenceChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildReferenceListRenderer());
        return defaultListChooser;
    }

    protected CachingComboBoxModel buildExtendedTableReferenceComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildTableReferenceHolder(), this.getSubjectHolder()){

            protected ListIterator listValueFromSubject(Object object) {
                return AbstractTableReferencePanel.this.orderedReferenceChoices((MWTableReferenceMapping)object);
            }
        });
    }

    protected ListIterator orderedReferenceChoices(MWTableReferenceMapping mWTableReferenceMapping) {
        return CollectionTools.sort((Iterator)this.candidateReferences(mWTableReferenceMapping)).listIterator();
    }

    protected Iterator candidateReferences(MWTableReferenceMapping mWTableReferenceMapping) {
        return mWTableReferenceMapping.candidateReferences();
    }

    private DefaultListChooserDialog.Builder buildTableReferenceChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("TABLE_REFERENCE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("TABLE_REFERENCE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTableReferenceStringConverter());
        return builder;
    }

    private ListCellRenderer buildReferenceListRenderer() {
        return new AdaptableListCellRenderer(new ReferenceCellRendererAdapter(this.resourceRepository()));
    }

    private StringConverter buildTableReferenceStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWReference)object).getName();
            }
        };
    }

    protected PropertyValueModel buildTableReferenceHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "reference"){

            protected Object getValueFromSubject() {
                return ((MWTableReferenceMapping)this.subject).getReference();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTableReferenceMapping)this.subject).setReference((MWReference)object);
            }
        };
    }

    private NodeSelector buildTableReferenceNodeSelector() {
        return new NodeSelector(){

            public void selectNodeFor(Object object) {
                RelationalProjectNode relationalProjectNode = (RelationalProjectNode)AbstractTableReferencePanel.this.navigatorSelectionModel().getSelectedProjectNodes()[0];
                relationalProjectNode.selectReference((MWReference)object, AbstractTableReferencePanel.this.getWorkbenchContext());
            }
        };
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ListChooser listChooser = this.buildTableReferenceChooser();
        JButton jButton = this.buildButton("TABLE_REFERENCE_NEW_BUTTON");
        jButton.addActionListener(this.buildCreateNewReferenceAction());
        JComponent jComponent = this.buildLabeledComponent("TABLE_REFERENCE_CHOOSER", listChooser, jButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        ColumnPairsPanel columnPairsPanel = this.buildColumnPairsPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)columnPairsPanel, gridBagConstraints);
        this.addPaneForAlignment(columnPairsPanel);
        JButton jButton2 = new JButton("Test");
        int n = jButton2.getPreferredSize().height * 4 + 20;
        columnPairsPanel.setPreferredSize(new Dimension(1, n));
        this.addHelpTopicId(this, "mapping.tableReference");
    }

    void createNewReference() {
        NewTableReferenceDialog newTableReferenceDialog = NewTableReferenceDialog.buildReferenceDialogAllowSourceAndTargetSelection(this.getWorkbenchContext(), this.candidateNewReferenceSourceTables(), this.candidateNewReferenceTargetTables());
        newTableReferenceDialog.setSourceTable(this.defaultNewReferenceSourceTable());
        newTableReferenceDialog.setTargetTable(this.defaultNewReferenceTargetTable());
        newTableReferenceDialog.show();
        if (newTableReferenceDialog.wasCanceled()) {
            return;
        }
        MWTable mWTable = newTableReferenceDialog.getSourceTable();
        MWReference mWReference = mWTable.addReference(newTableReferenceDialog.getReferenceName(), newTableReferenceDialog.getTargetTable());
        mWReference.setOnDatabase(newTableReferenceDialog.isOnDatabase());
        this.setReference(mWReference);
    }

    protected List candidateNewReferenceSourceTables() {
        return this.allTables();
    }

    protected abstract MWTable defaultNewReferenceSourceTable();

    protected List candidateNewReferenceTargetTables() {
        return this.allTables();
    }

    protected abstract MWTable defaultNewReferenceTargetTable();

    protected void setReference(MWReference mWReference) {
        ((MWTableReferenceMapping)this.subject()).setReference(mWReference);
    }

    protected List allTables() {
        return CollectionTools.sort((Iterator)((MWModel)this.subject()).getDatabase().tables());
    }
}

