/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregatePathToColumn;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class AggregateMappingColumnsPanel
extends ScrollablePropertiesPage {
    private ListValueModel sortedPathsToFieldsAdapter;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;

    AggregateMappingColumnsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.sortedPathsToFieldsAdapter = this.buildSortedPathToFieldsAdapter();
        this.tableModel = this.buildTableModel();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ListValueModel buildSortedPathToFieldsAdapter() {
        return new SortedListValueModelAdapter(this.buildPathsToFieldsAdapter());
    }

    private CollectionValueModel buildPathsToFieldsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "pathsToFields"){

            protected Iterator getValueFromSubject() {
                return ((MWAggregateMapping)this.subject).pathsToFields();
            }

            protected int sizeFromSubject() {
                return ((MWAggregateMapping)this.subject).pathsToFieldsSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedPathsToFieldsAdapter, this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new ColumnColumnAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedPathsToFieldsAdapter));
        objectListSelectionModel.setSelectionMode(0);
        return objectListSelectionModel;
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTable jTable = this.buildTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private JTable buildTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        this.updateTableColumns(jTable);
        SwingComponentFactory.attachTableEditorCanceler(jTable, this.getSelectionHolder());
        return jTable;
    }

    private void updateTableColumns(JTable jTable) {
        int n = 20;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(100);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildColumnsComboBoxRenderer();
        tableColumn2.setCellRenderer(comboBoxTableCellRenderer);
        tableColumn2.setCellEditor(new TableCellEditorAdapter(this.buildColumnsComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        jTable.setRowHeight(n);
    }

    private ComboBoxTableCellRenderer buildColumnsComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildColumnsComboBoxModel(), this.buildColumnListCellRenderer());
    }

    private CachingComboBoxModel buildColumnsComboBoxModel() {
        return RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(new SimplePropertyValueModel(), this.buildParentDescriptorHolder());
    }

    private ListCellRenderer buildColumnListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private PropertyValueModel buildParentDescriptorHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWAggregateMapping)this.subject).getParentDescriptor();
            }
        };
    }

    protected String helpTopicId() {
        return "mapping.aggregate.fields";
    }

    public static class ColumnColumnAdapter
    implements ColumnAdapter {
        ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int COLUMN_DESCRIPTION_COLUMN = 0;
        public static final int COLUMN_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"FIELD_DESCRIPTION_COLUMN_HEADER", "FIELDS_COLUMN_HEADER"};

        protected ColumnColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return n != 0;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWAggregatePathToColumn mWAggregatePathToColumn = (MWAggregatePathToColumn)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildColumnDescriptionAdapter(mWAggregatePathToColumn), this.buildColumnAdapter(mWAggregatePathToColumn)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildColumnDescriptionAdapter(MWAggregatePathToColumn mWAggregatePathToColumn) {
            return new PropertyAspectAdapter("aggregateRuntimeFieldNameGenerator", (Model)mWAggregatePathToColumn){

                protected Object getValueFromSubject() {
                    MWAggregatePathToColumn mWAggregatePathToColumn = (MWAggregatePathToColumn)this.subject;
                    AggregateFieldDescription aggregateFieldDescription = mWAggregatePathToColumn.getAggregateRuntimeFieldNameGenerator().fullFieldDescription();
                    return mWAggregatePathToColumn.getPathDescription() + ColumnColumnAdapter.this.resourceRepository.getString(aggregateFieldDescription.getMessageKey(), aggregateFieldDescription.getMessageArguments());
                }
            };
        }

        private PropertyValueModel buildColumnAdapter(MWAggregatePathToColumn mWAggregatePathToColumn) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("column", (Model)mWAggregatePathToColumn){

                protected Object getValueFromSubject() {
                    return ((MWAggregatePathToColumn)this.subject).getColumn();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWAggregatePathToColumn)this.subject).setColumn((MWColumn)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter(propertyAspectAdapter, "qualifiedName", "databaseType");
        }
    }
}

