/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionOrdering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.QueryKeyCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.BidiTransformer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;

final class CollectionOrderingPanel
extends AbstractSubjectPanel {
    public CollectionOrderingPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    MWCollectionMapping getCollectionMapping() {
        return (MWCollectionMapping)this.getSubjectHolder().getValue();
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AddRemoveTablePanel addRemoveTablePanel = this.buildOrderingsTablePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)addRemoveTablePanel, gridBagConstraints);
    }

    private AddRemoveTablePanel buildOrderingsTablePanel() {
        AddRemoveTablePanel addRemoveTablePanel = new AddRemoveTablePanel(this.getApplicationContext(), this.buildTablePanelAdapter(), this.buildOrderingsListModel(), this.buildOrderingColumnAdapter(), 3, this.buildOrderingSelector());
        this.updateTableColumns((JTable)addRemoveTablePanel.getComponent());
        return addRemoveTablePanel;
    }

    private void updateTableColumns(JTable jTable) {
        int n = 0;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildOrderingComboBoxRenderer();
        tableColumn.setCellRenderer(comboBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildOrderingComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(0);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer2 = this.buildQueryKeyComboBoxRenderer();
        tableColumn.setCellRenderer(comboBoxTableCellRenderer2);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildQueryKeyComboBoxRenderer()));
        jTable.setRowHeight(n);
    }

    private AddRemovePanel.UpDownAdapter buildTablePanelAdapter() {
        return new AddRemovePanel.UpDownAdapter(){

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                Object[] objectArray = objectListSelectionModel.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    CollectionOrderingPanel.this.getCollectionMapping().removeOrdering((MWCollectionOrdering)objectArray[i]);
                }
            }

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                if (CollectionOrderingPanel.this.getCollectionMapping().getReferenceDescriptor() != null) {
                    Collection collection = CollectionOrderingPanel.this.getCollectionMapping().getReferenceDescriptor().getAllQueryKeysIncludingInherited();
                    if (collection.size() == 0) {
                        CollectionOrderingPanel.this.getCollectionMapping().addOrdering(null);
                    } else {
                        CollectionOrderingPanel.this.getCollectionMapping().addOrdering((MWQueryKey)collection.iterator().next());
                    }
                } else {
                    CollectionOrderingPanel.this.getCollectionMapping().addOrdering(null);
                }
            }

            public void moveItemsDown(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    CollectionOrderingPanel.this.getCollectionMapping().moveOrderingDown((MWCollectionOrdering)objectArray[i]);
                }
            }

            public void moveItemsUp(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    CollectionOrderingPanel.this.getCollectionMapping().moveOrderingUp((MWCollectionOrdering)objectArray[i]);
                }
            }
        };
    }

    private ListValueModel buildOrderingsListModel() {
        return new ListAspectAdapter(this.getSubjectHolder(), "orderings"){

            protected ListIterator getValueFromSubject() {
                return ((MWCollectionMapping)this.subject).orderings();
            }

            protected int sizeFromSubject() {
                return ((MWCollectionMapping)this.subject).orderingsSize();
            }
        };
    }

    private ColumnAdapter buildOrderingColumnAdapter() {
        return new OrderingsColumnAdapter(this.resourceRepository());
    }

    private ComboBoxModel buildOrderingComboBoxModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{this.resourceRepository().getString("ASCENDING_OPTION"), this.resourceRepository().getString("DESCENDING_OPTION")});
    }

    private ComboBoxTableCellRenderer buildOrderingComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildOrderingComboBoxModel());
    }

    private ComboBoxTableCellRenderer buildQueryKeyComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildQueryKeyComboBoxModel(), this.buildQueryListCellRenderer());
    }

    private ListCellRenderer buildQueryListCellRenderer() {
        return new AdaptableListCellRenderer(new QueryKeyCellRendererAdapter(this.resourceRepository()));
    }

    private NodeSelector buildOrderingSelector() {
        return new NodeSelector(){

            public void selectNodeFor(Object object) {
                RelationalProjectNode relationalProjectNode = (RelationalProjectNode)CollectionOrderingPanel.this.navigatorSelectionModel().getSelectedProjectNodes()[0];
                relationalProjectNode.selectQueryKey(((MWCollectionOrdering)object).getQueryKey(), CollectionOrderingPanel.this.getWorkbenchContext());
            }
        };
    }

    private CachingComboBoxModel buildQueryKeyComboBoxModel() {
        return new IndirectComboBoxModel(new SimplePropertyValueModel(), this.getSubjectHolder()){

            protected ListIterator listValueFromSubject(Object object) {
                return CollectionOrderingPanel.this.orderedQueryKeyChoices((MWCollectionMapping)object);
            }
        };
    }

    ListIterator orderedQueryKeyChoices(MWCollectionMapping mWCollectionMapping) {
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)mWCollectionMapping.getReferenceDescriptor();
        if (mWRelationalDescriptor != null) {
            return CollectionTools.sort((Iterator)mWRelationalDescriptor.allQueryKeysIncludingInherited()).listIterator();
        }
        return NullListIterator.instance();
    }

    private static class OrderingsColumnAdapter
    implements ColumnAdapter {
        ResourceRepository resourceRepository;
        public static final int QUERY_KEY_COLUMN = 0;
        public static final int ORDER_COLUMN = 1;
        public static final int COLUMN_COUNT = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"QUERY_KEY_COLUMN_HEADER", "ORDER_COLUMN_HEADER"};

        private OrderingsColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        private PropertyValueModel buildQueryKeyAdapter(MWCollectionOrdering mWCollectionOrdering) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("queryKey", (Model)mWCollectionOrdering){

                protected Object getValueFromSubject() {
                    return ((MWCollectionOrdering)this.subject).getQueryKey();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWCollectionOrdering)this.subject).setQueryKey((MWQueryKey)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildOrderAdapter(MWCollectionOrdering mWCollectionOrdering) {
            return new TransformationPropertyValueModel(new PropertyAspectAdapter("ascending", (Model)mWCollectionOrdering){

                protected Object getValueFromSubject() {
                    return ((MWCollectionOrdering)this.subject).isAscending();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWCollectionOrdering)this.subject).setAscending(((Boolean)object).booleanValue());
                }
            }, new BidiTransformer(){

                public Object reverseTransform(Object object) {
                    if (object == null) {
                        return Boolean.FALSE;
                    }
                    if (((String)object).equals(OrderingsColumnAdapter.this.resourceRepository.getString("ASCENDING_OPTION"))) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }

                public Object transform(Object object) {
                    if (((Boolean)object).equals(Boolean.TRUE)) {
                        return OrderingsColumnAdapter.this.resourceRepository.getString("ASCENDING_OPTION");
                    }
                    return OrderingsColumnAdapter.this.resourceRepository.getString("DESCENDING_OPTION");
                }
            });
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWCollectionOrdering mWCollectionOrdering = (MWCollectionOrdering)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildQueryKeyAdapter(mWCollectionOrdering), this.buildOrderAdapter(mWCollectionOrdering)};
            return propertyValueModelArray;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public boolean isColumnEditable(int n) {
            return true;
        }
    }
}

