/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWJoinFetchableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ExtendedListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public final class RelationalMappingComponentFactory
extends MappingComponentFactory {
    static ListChooser buildColumnChooser(ValueModel valueModel, ValueModel valueModel2, WorkbenchContextHolder workbenchContextHolder) {
        ResourceRepository resourceRepository = workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository();
        DefaultListChooser defaultListChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(RelationalMappingComponentFactory.buildColumnHolder(valueModel), valueModel2), workbenchContextHolder, RelationalMappingComponentFactory.buildColumnNodeSelector(workbenchContextHolder), RelationalMappingComponentFactory.buildColumnChooserDialogBuilder());
        defaultListChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(valueModel2, resourceRepository));
        return defaultListChooser;
    }

    public static DefaultListChooserDialog.Builder buildColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DATABASE_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DATABASE_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildColumnStringConverter());
        return builder;
    }

    private static ListIterator orderedColumns(MWRelationalClassDescriptor mWRelationalClassDescriptor) {
        return CollectionTools.sort((Iterator)mWRelationalClassDescriptor.allAssociatedColumns()).listIterator();
    }

    public static CachingComboBoxModel buildExtendedColumnComboBoxModel(PropertyValueModel propertyValueModel, ValueModel valueModel) {
        return new ExtendedComboBoxModel(RelationalMappingComponentFactory.buildColumnComboBoxModel(propertyValueModel, valueModel));
    }

    public static CachingComboBoxModel buildColumnComboBoxModel(PropertyValueModel propertyValueModel, ValueModel valueModel) {
        return new IndirectComboBoxModel(propertyValueModel, valueModel){

            protected ListIterator listValueFromSubject(Object object) {
                return RelationalMappingComponentFactory.orderedColumns((MWRelationalClassDescriptor)object);
            }

            protected int listSizeFromSubject(Object object) {
                return ((MWRelationalClassDescriptor)object).allAssociatedColumnsSize();
            }
        };
    }

    public static ListCellRenderer buildColumnListRenderer(final ValueModel valueModel, ResourceRepository resourceRepository) {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(resourceRepository){

            protected String buildNullValueText() {
                if (valueModel.getValue() == null) {
                    return super.buildNullValueText();
                }
                if (((MWRelationalDescriptor)valueModel.getValue()).isAggregateDescriptor()) {
                    return " ";
                }
                return super.buildNullValueText();
            }
        });
    }

    public static StringConverter buildColumnStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWColumn)object).qualifiedName();
            }
        };
    }

    private static PropertyValueModel buildColumnHolder(ValueModel valueModel) {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(valueModel, "column"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectMapping)this.subject).getColumn();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalDirectMapping)this.subject).setColumn((MWColumn)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter(propertyAspectAdapter, "qualifiedName", "databaseType");
    }

    public static NodeSelector buildColumnNodeSelector(final WorkbenchContextHolder workbenchContextHolder) {
        return new NodeSelector(){

            public void selectNodeFor(Object object) {
                RelationalProjectNode relationalProjectNode = (RelationalProjectNode)workbenchContextHolder.getWorkbenchContext().getNavigatorSelectionModel().getSelectedProjectNodes()[0];
                relationalProjectNode.selectColumn((MWColumn)object, workbenchContextHolder.getWorkbenchContext());
            }
        };
    }

    static JCheckBox buildBatchReadingCheckBox(ValueModel valueModel, ResourceRepository resourceRepository) {
        return RelationalMappingComponentFactory.buildCheckBox("MAPPING_BATCH_READING_CHECK_BOX", RelationalMappingComponentFactory.buildUseBatchReadingCheckBoxAdapter(valueModel), resourceRepository);
    }

    private static ButtonModel buildUseBatchReadingCheckBoxAdapter(ValueModel valueModel) {
        return new CheckBoxModelAdapter(RelationalMappingComponentFactory.buildUseBatchReadingHolder(valueModel));
    }

    private static PropertyValueModel buildUseBatchReadingHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "usesBatchReading"){

            protected Object getValueFromSubject() {
                return ((MWTableReferenceMapping)this.subject).usesBatchReading();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTableReferenceMapping)this.subject).setUsesBatchReading(((Boolean)object).booleanValue());
            }
        };
    }

    private static PropertyValueModel buildJoinFetchingHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "joinFetchOption"){

            protected Object getValueFromSubject() {
                return ((MWJoinFetchableMapping)this.subject).getJoinFetchOption();
            }

            protected void setValueOnSubject(Object object) {
                ((MWJoinFetchableMapping)this.subject).setJoinFetchOption((MWJoinFetchableMapping.JoinFetchOption)object);
            }
        };
    }

    public static JComboBox buildJoinFetchingCombobox(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        PropertyValueModel propertyValueModel = RelationalMappingComponentFactory.buildJoinFetchingHolder(valueModel);
        DefaultListChooser defaultListChooser = new DefaultListChooser((ComboBoxModel)new ComboBoxModelAdapter(RelationalMappingComponentFactory.buildJoinFetchCollectionHolder(valueModel.getValue()), propertyValueModel), workbenchContextHolder);
        defaultListChooser.setRenderer(RelationalMappingComponentFactory.buildJoinFetchOptionRenderer(workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return defaultListChooser;
    }

    private static ListValueModel buildJoinFetchCollectionHolder(Object object) {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWJoinFetchableMapping.JoinFetchOptionSet.joinFetchOptions().toplinkOptions();
            }
        };
    }

    private static ListCellRenderer buildJoinFetchOptionRenderer(final ResourceRepository resourceRepository) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return resourceRepository.getString(((MWJoinFetchableMapping.JoinFetchOption)object).resourceKey());
            }
        };
    }

    static ListChooser buildTargetTableChooser(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        return RelationalProjectComponentFactory.buildTableChooser(propertyValueModel, RelationalMappingComponentFactory.buildTargetTableHolder(propertyValueModel), RelationalMappingComponentFactory.buildTargetTableChooserDialogBuilder(), workbenchContextHolder);
    }

    private static DefaultListChooserDialog.Builder buildTargetTableChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DIRECT_CONTAINER_MAPPING_TARGET_TABLE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DIRECT_CONTAINER_MAPPING_TARGET_TABLE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildTableStringConverter());
        return builder;
    }

    private static StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWTable)object).getName();
            }
        };
    }

    private static ValueModel buildParentDescriptorHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getParentDescriptor();
            }
        };
    }

    private static PropertyValueModel buildTargetTableHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "targetTable"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectContainerMapping)this.subject).getTargetTable();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalDirectContainerMapping)this.subject).setTargetTable((MWTable)object);
            }
        };
    }

    static ListChooser buildDirectValueColumnChooser(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        DefaultListChooser defaultListChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildDirectValueColumnComboModel(valueModel), workbenchContextHolder, RelationalMappingComponentFactory.buildColumnNodeSelector(workbenchContextHolder), RelationalMappingComponentFactory.buildDirectValueColumnChooserDialogBuilder());
        defaultListChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(RelationalMappingComponentFactory.buildParentDescriptorHolder(valueModel), workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return defaultListChooser;
    }

    private static DefaultListChooserDialog.Builder buildDirectValueColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DIRECT_VALUE_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DIRECT_VALUE_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildColumnStringConverter());
        return builder;
    }

    private static ComboBoxModel buildDirectValueColumnComboModel(ValueModel valueModel) {
        return new ComboBoxModelAdapter(RelationalMappingComponentFactory.buildDirectValueColumnListHolder(valueModel), RelationalMappingComponentFactory.buildDirectValueColumnAdapter(valueModel));
    }

    private static PropertyValueModel buildDirectValueColumnAdapter(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "directValueColumn"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectContainerMapping)this.subject).getDirectValueColumn();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalDirectContainerMapping)this.subject).setDirectValueColumn((MWColumn)object);
            }
        };
    }

    private static ListValueModel buildDirectValueColumnListHolder(ValueModel valueModel) {
        return new ExtendedListValueModelWrapper(new SortedListValueModelAdapter(RelationalMappingComponentFactory.buildDirectValueColumnCollectionHolder(valueModel)));
    }

    private static CollectionValueModel buildDirectValueColumnCollectionHolder(ValueModel valueModel) {
        return new CollectionAspectAdapter(RelationalMappingComponentFactory.buildTargetTableHolder(valueModel), "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            public int size() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    static ListChooser buildDirectKeyColumnChooser(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        DefaultListChooser defaultListChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildDirectKeyColumnComboModel(valueModel), workbenchContextHolder, RelationalMappingComponentFactory.buildColumnNodeSelector(workbenchContextHolder), RelationalMappingComponentFactory.buildDirectKeyColumnChooserDialogBuilder());
        defaultListChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(RelationalMappingComponentFactory.buildParentDescriptorHolder(valueModel), workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return defaultListChooser;
    }

    private static DefaultListChooserDialog.Builder buildDirectKeyColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DIRECT_KEY_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DIRECT_KEY_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalMappingComponentFactory.buildColumnStringConverter());
        return builder;
    }

    private static ComboBoxModel buildDirectKeyColumnComboModel(ValueModel valueModel) {
        return new ComboBoxModelAdapter(RelationalMappingComponentFactory.buildDirectValueColumnListHolder(valueModel), RelationalMappingComponentFactory.buildDirectKeyColumnAdapter(valueModel));
    }

    private static PropertyValueModel buildDirectKeyColumnAdapter(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "directKeyColumn"){

            protected Object getValueFromSubject() {
                return ((MWRelationalDirectMapMapping)this.subject).getDirectKeyColumn();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalDirectMapMapping)this.subject).setDirectKeyColumn((MWColumn)object);
            }
        };
    }
}

