/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWAbstractCompositeMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.ContainerAccessorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.ContainerAccessorEditingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

public final class ContainerAccessorPanel
extends AbstractSubjectPanel {
    JList accessorList;

    public ContainerAccessorPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildContainerAccessorLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        Component component = this.buildContainerAccessorComponent();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add(component, gridBagConstraints);
        JButton jButton = this.buildContainerAccessorEditButton();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        this.addAlignRight(jButton);
        jLabel.setLabelFor(jButton);
        SwingComponentFactory.updateButtonAccessibleName(jLabel, jButton);
        this.addHelpTopicId(this, "mapping.containerAccessor");
    }

    private Component buildContainerAccessorComponent() {
        this.accessorList = SwingComponentFactory.buildList(this.buildAccessorListModel());
        this.accessorList.setCellRenderer(this.buildAccessorListCellRenderer());
        this.accessorList.setDoubleBuffered(true);
        this.accessorList.setVisibleRowCount(1);
        this.accessorList.setPreferredSize(new Dimension(0, 0));
        return new JScrollPane(this.accessorList, 21, 31);
    }

    private ListModel buildAccessorListModel() {
        return new ListModelAdapter(this.buildAccessorCollectionValue());
    }

    private CollectionValueModel buildAccessorCollectionValue() {
        return new PropertyCollectionValueModelAdapter(this.buildAccessorPropertyValue());
    }

    private PropertyValueModel buildAccessorPropertyValue() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerAccessor"){

            protected Object getValueFromSubject() {
                return ((MWAbstractCompositeMapping)this.subject).getContainerAccessor();
            }
        };
    }

    private ListCellRenderer buildAccessorListCellRenderer() {
        return new AdaptableListCellRenderer(new ContainerAccessorCellRendererAdapter(this.resourceRepository()));
    }

    private JLabel buildContainerAccessorLabel() {
        return SwingComponentFactory.buildLabel("CONTAINER_ACCESSOR_LABEL", this.resourceRepository());
    }

    private JButton buildContainerAccessorEditButton() {
        JButton jButton = new JButton(this.resourceRepository().getString("CONTAINER_ACCESSOR_EDIT_BUTTON"));
        jButton.addActionListener(this.buildAttributeTransformerEditAction());
        return jButton;
    }

    private ActionListener buildAttributeTransformerEditAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MWAbstractCompositeMapping mWAbstractCompositeMapping = (MWAbstractCompositeMapping)ContainerAccessorPanel.this.subject();
                WorkbenchContext workbenchContext = ContainerAccessorPanel.this.getWorkbenchContext();
                ContainerAccessorEditingDialog.promptToEditContainerAccessor(mWAbstractCompositeMapping, workbenchContext);
            }
        };
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this.updateEnableStateOfChildren(bl);
    }

    protected void updateEnableStateOfChildren(boolean bl) {
        int n = this.getComponentCount();
        while (--n >= 0) {
            this.getComponent(n).setEnabled(bl);
        }
        this.accessorList.setEnabled(bl);
    }
}

