/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.XmlReferenceMappingFieldPairEditingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class XmlReferenceMappingFieldPairsPanel
extends AbstractSubjectPanel {
    private ObjectListSelectionModel fieldPairsSelectionModel;

    XmlReferenceMappingFieldPairsPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
        this.addHelpTopicId(this, "mapping.eis.fieldPairs");
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComponent jComponent = this.buildFieldPairsTablePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        JPanel jPanel = this.buildButtonPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
    }

    private JComponent buildFieldPairsTablePanel() {
        JTable jTable = this.buildFieldPairsTable();
        JScrollPane jScrollPane = new JScrollPane(jTable, 20, 31);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        jScrollPane.getViewport().setMinimumSize(new Dimension(10, 10));
        jScrollPane.getViewport().setPreferredSize(new Dimension(10, 10));
        return jScrollPane;
    }

    private JTable buildFieldPairsTable() {
        ListValueModel listValueModel = this.buildFieldPairsValue();
        TableModel tableModel = this.buildFieldPairsTableModel(listValueModel);
        this.fieldPairsSelectionModel = this.buildFieldPairSelectionModel(listValueModel);
        JTable jTable = SwingComponentFactory.buildTable(tableModel, this.fieldPairsSelectionModel);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.buildXpathColumnCellRenderer());
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(this.buildXpathColumnCellRenderer());
        this.addPropertyChangeListener("enabled", this.buildTableEnabler(jTable));
        return jTable;
    }

    private ListValueModel buildFieldPairsValue() {
        return new ListAspectAdapter(this.getSubjectHolder(), "xmlFieldPairs"){

            public Object getItem(int n) {
                return ((MWXmlReferenceMapping)this.subject).xmlFieldPairAt(n);
            }

            protected ListIterator getValueFromSubject() {
                return ((MWXmlReferenceMapping)this.subject).xmlFieldPairs();
            }
        };
    }

    private TableModel buildFieldPairsTableModel(ListValueModel listValueModel) {
        return new TableModelAdapter(listValueModel, this.buildFieldPairsTableColumnAdapter());
    }

    private ColumnAdapter buildFieldPairsTableColumnAdapter() {
        return new FieldPairsTableColumnAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildFieldPairSelectionModel(ListValueModel listValueModel) {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(listValueModel));
        objectListSelectionModel.setSelectionMode(2);
        return objectListSelectionModel;
    }

    private TableCellRenderer buildXpathColumnCellRenderer() {
        return new SimpleTableCellRenderer(){

            protected String buildText(Object object) {
                if ("".equals(object)) {
                    return XmlReferenceMappingFieldPairsPanel.this.resourceRepository().getString("NONE_SELECTED");
                }
                return (String)object;
            }
        };
    }

    private PropertyChangeListener buildTableEnabler(final JTable jTable) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jTable.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        };
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 0, 5));
        JButton jButton = this.buildAddFieldPairButton();
        jPanel.add(jButton);
        this.addAlignRight(jButton);
        JButton jButton2 = this.buildEditFieldPairButton();
        jPanel.add(jButton2);
        this.addAlignRight(jButton2);
        JButton jButton3 = this.buildRemoveFieldPairsButton();
        jPanel.add(jButton3);
        this.addAlignRight(jButton3);
        return jPanel;
    }

    private JButton buildAddFieldPairButton() {
        JButton jButton = this.buildButton("FIELD_PAIR_ADD_BUTTON");
        jButton.addActionListener(this.buildAddFieldPairAction());
        this.addPropertyChangeListener("enabled", this.buildAddButtonEnabler(jButton));
        return jButton;
    }

    private ActionListener buildAddFieldPairAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MWXmlReferenceMapping mWXmlReferenceMapping = (MWXmlReferenceMapping)XmlReferenceMappingFieldPairsPanel.this.getSubjectHolder().getValue();
                WorkbenchContext workbenchContext = XmlReferenceMappingFieldPairsPanel.this.getWorkbenchContext();
                XmlReferenceMappingFieldPairEditingDialog.promptToAddFieldPair(mWXmlReferenceMapping, workbenchContext);
            }
        };
    }

    private PropertyChangeListener buildAddButtonEnabler(final JButton jButton) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        };
    }

    private JButton buildEditFieldPairButton() {
        JButton jButton = this.buildButton("FIELD_PAIR_EDIT_BUTTON");
        jButton.addActionListener(this.buildEditActionListener());
        jButton.setEnabled(false);
        this.buildEditFieldPairButtonEnabler(jButton);
        return jButton;
    }

    private ActionListener buildEditActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MWXmlFieldPair mWXmlFieldPair = (MWXmlFieldPair)XmlReferenceMappingFieldPairsPanel.this.fieldPairsSelectionModel.getSelectedValue();
                WorkbenchContext workbenchContext = XmlReferenceMappingFieldPairsPanel.this.getWorkbenchContext();
                XmlReferenceMappingFieldPairEditingDialog.promptToEditFieldPair(mWXmlFieldPair, workbenchContext);
            }
        };
    }

    private void buildEditFieldPairButtonEnabler(final JButton jButton) {
        this.fieldPairsSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    jButton.setEnabled(XmlReferenceMappingFieldPairsPanel.this.fieldPairsSelectionModel.getSelectedValues().length == 1);
                }
            }
        });
    }

    private JButton buildRemoveFieldPairsButton() {
        JButton jButton = this.buildButton("FIELD_PAIR_REMOVE_BUTTON");
        jButton.addActionListener(this.buildRemoveFieldPairsActionListener());
        jButton.setEnabled(false);
        this.buildRemoveFieldPairsButtonEnabler(jButton);
        return jButton;
    }

    private ActionListener buildRemoveFieldPairsActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XmlReferenceMappingFieldPairsPanel.this.removeSelectedFieldPairs();
            }
        };
    }

    private void removeSelectedFieldPairs() {
        Iterator iterator = CollectionTools.iterator((Object[])this.fieldPairsSelectionModel.getSelectedValues());
        while (iterator.hasNext()) {
            ((MWXmlReferenceMapping)this.subject()).removeXmlFieldPair((MWXmlFieldPair)iterator.next());
        }
    }

    private void buildRemoveFieldPairsButtonEnabler(final JButton jButton) {
        this.fieldPairsSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    jButton.setEnabled(!XmlReferenceMappingFieldPairsPanel.this.fieldPairsSelectionModel.isSelectionEmpty());
                }
            }
        });
    }

    private static class FieldPairsTableColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int SOURCE_XPATH_COLUMN = 0;
        public static final int TARGET_XPATH_COLUMN = 1;

        public int getColumnCount() {
            return 2;
        }

        FieldPairsTableColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return this.resourceRepository.getString("FIELD_PAIR_SOURCE_FIELD_COLUMN");
                }
                case 1: {
                    return this.resourceRepository.getString("FIELD_PAIR_TARGET_FIELD_COLUMN");
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWXmlFieldPair mWXmlFieldPair = (MWXmlFieldPair)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildXpathAdapter(mWXmlFieldPair.getSourceXmlField()), this.buildXpathAdapter(mWXmlFieldPair.getTargetXmlField())};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildXpathAdapter(MWXmlField mWXmlField) {
            return new PropertyAspectAdapter("xpath", (Model)mWXmlField){

                protected Object getValueFromSubject() {
                    return ((MWXmlField)this.subject).getXpath();
                }
            };
        }
    }
}

