/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;

public class CombinedClassDescriptionRepository
implements ClassDescriptionRepository {
    protected MWClassRepository repository;
    protected Filter typeNameFilter;
    protected boolean returnsDuplicateClassNames;
    protected Set typeNames;

    public CombinedClassDescriptionRepository(MWClassRepository mWClassRepository, Filter filter) {
        this.repository = mWClassRepository;
        this.typeNameFilter = filter;
        this.returnsDuplicateClassNames = false;
    }

    public CombinedClassDescriptionRepository(MWClassRepository mWClassRepository) {
        this(mWClassRepository, Filter.NULL_INSTANCE);
    }

    public void refreshClassDescriptions() {
        this.typeNames = null;
        this.repository.refreshExternalClassDescriptions();
    }

    public Iterator classDescriptions() {
        return this.filteredCombinedTypes(this.repository.combinedTypes());
    }

    public void setReturnsDuplicateClassNames(boolean bl) {
        this.returnsDuplicateClassNames = bl;
    }

    public boolean returnsDuplicateClassNames() {
        return this.returnsDuplicateClassNames;
    }

    protected Iterator filteredCombinedTypes(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return CombinedClassDescriptionRepository.this.accept(((ClassDescription)object).getName());
            }
        };
    }

    protected boolean accept(String string) {
        return this.typeNameFilter.accept((Object)string) && this.acceptDuplicate(string);
    }

    protected boolean acceptDuplicate(String string) {
        if (this.returnsDuplicateClassNames) {
            return true;
        }
        if (this.typeNames == null) {
            this.typeNames = new HashSet(10000);
        }
        return this.typeNames.add(string);
    }
}

