/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class MappingsPreferencesPage
extends AbstractPanel {
    private ComponentAligner aligner;
    private final String NO_OPTION = TriStateBoolean.FALSE.toString();
    private final String PROMPT_OPTION = TriStateBoolean.UNDEFINED.toString();
    private final String YES_OPTION = TriStateBoolean.TRUE.toString();

    MappingsPreferencesPage(PreferencesContext preferencesContext) {
        super(preferencesContext);
        this.intializeLayout();
    }

    private void applyConverter(PreferencePropertyValueModel preferencePropertyValueModel) {
        preferencePropertyValueModel.setConverter(new BidiStringConverter(){

            public Object convertToObject(String string) {
                return this.convertToString(string);
            }

            public String convertToString(Object object) {
                if (MappingsPreferencesPage.this.YES_OPTION.equals(object)) {
                    return MappingsPreferencesPage.this.YES_OPTION;
                }
                if (MappingsPreferencesPage.this.NO_OPTION.equals(object)) {
                    return MappingsPreferencesPage.this.NO_OPTION;
                }
                return MappingsPreferencesPage.this.PROMPT_OPTION;
            }
        });
    }

    private PropertyValueModel buildBufferedAdapter(PropertyValueModel propertyValueModel) {
        return new BufferedPropertyValueModel(propertyValueModel, this.getPreferencesContext().getBufferTrigger());
    }

    private ButtonModel buildButtonAdapter(PropertyValueModel propertyValueModel, String string) {
        return new RadioButtonModelAdapter(propertyValueModel, string);
    }

    private PropertyValueModel buildChangeQueryFormatAdapter() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "query change query format");
        this.applyConverter(preferencePropertyValueModel);
        return this.buildBufferedAdapter(preferencePropertyValueModel);
    }

    private JComponent buildChangeQueryFormatPromptGroupBox() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        PropertyValueModel propertyValueModel = this.buildChangeQueryFormatAdapter();
        JPanel jPanel = this.buildGroupBox("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT");
        JRadioButton jRadioButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT.YES", this.buildButtonAdapter(propertyValueModel, this.YES_OPTION));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        this.aligner.add(jRadioButton);
        JRadioButton jRadioButton2 = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT.NO", this.buildButtonAdapter(propertyValueModel, this.NO_OPTION));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        this.aligner.add(jRadioButton2);
        JRadioButton jRadioButton3 = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT.PROMPT", this.buildButtonAdapter(propertyValueModel, this.PROMPT_OPTION));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        this.aligner.add(jRadioButton3);
        this.addHelpTopicId(jPanel, "preferences.mappings.query.changeQueryFormat");
        return jPanel;
    }

    private PropertyValueModel buildChangeQueryTypeAdapter() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "query change query type");
        this.applyConverter(preferencePropertyValueModel);
        return this.buildBufferedAdapter(preferencePropertyValueModel);
    }

    private JComponent buildChangeQueryTypePromptGroupBox() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        PropertyValueModel propertyValueModel = this.buildChangeQueryTypeAdapter();
        JPanel jPanel = this.buildGroupBox("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE");
        JRadioButton jRadioButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE.YES", this.buildButtonAdapter(propertyValueModel, this.YES_OPTION));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        this.aligner.add(jRadioButton);
        JRadioButton jRadioButton2 = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE.NO", this.buildButtonAdapter(propertyValueModel, this.NO_OPTION));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        this.aligner.add(jRadioButton2);
        JRadioButton jRadioButton3 = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE.PROMPT", this.buildButtonAdapter(propertyValueModel, this.PROMPT_OPTION));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        this.aligner.add(jRadioButton3);
        this.addHelpTopicId(jPanel, "preferences.mappings.query.changeQueryType");
        return jPanel;
    }

    private JPanel buildGroupBox(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.buildTitledBorder(string));
        return jPanel;
    }

    private void intializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.aligner = new ComponentAligner();
        JComponent jComponent = this.buildChangeQueryTypePromptGroupBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildChangeQueryFormatPromptGroupBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jComponent2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)new Spacer(), gridBagConstraints);
        this.addHelpTopicId(this, "preferences.mappings");
    }
}

