/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class DeleteProjectAction
extends AbstractFrameworkAction {
    DeleteProjectAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        this.initializeText("DELETE_PROJECT_ACTION");
        this.initializeMnemonic("DELETE_PROJECT_ACTION");
        this.initializeToolTipText("DELETE_PROJECT_ACTION.toolTipText");
        this.initializeIcon("project.remove");
    }

    protected void execute(ApplicationNode applicationNode) {
        MWProject mWProject = (MWProject)applicationNode.getValue();
        File file = mWProject.getSaveDirectory();
        File file2 = new File(file, mWProject.getName() + ".mwp");
        if (file2.exists()) {
            if (this.confirmDeletion()) {
                this.deleteProject(applicationNode, file2);
            }
        } else {
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("PROJECT_FILE_DOES_NOT_EXIST.message", StringTools.CR));
            this.closeProject(applicationNode);
        }
    }

    private boolean confirmDeletion() {
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("DELETE_PROJECT_WARNING.message", StringTools.CR), this.resourceRepository().getString("DELETE_PROJECT_WARNING.title"), 0, 2);
        return n == 0;
    }

    public void deleteProject(ApplicationNode applicationNode, File file) {
        boolean bl = false;
        if (file != null && file.exists()) {
            int n = file.getName().lastIndexOf(46);
            String string = n == -1 ? file.getName() : file.getName().substring(0, n);
            File file2 = file.getParentFile();
            File[] fileArray = file2.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".mwp");
                }
            });
            if (fileArray.length == 1) {
                bl = this.deleteProjectByFile(file);
            } else {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("UNABLE_TO_DELETE_PROJECT_DIALOG.message", new Object[]{string}), this.resourceRepository().getString("UNABLE_TO_DELETE_PROJECT_DIALOG.title"), 0);
                return;
            }
        }
        if (bl) {
            this.closeProject(applicationNode);
        }
    }

    private void closeProject(ApplicationNode applicationNode) {
        this.nodeManager().removeProjectNode(applicationNode);
    }

    private boolean deleteProjectByFile(File file) {
        boolean bl = true;
        File file2 = file.getParentFile();
        file.delete();
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return (string.equals("classes") || string.equals("descriptors") || string.equals("tables") || string.equals("schemas")) && file.isDirectory();
            }
        });
        int n = fileArray.length;
        for (int i = 0; i < n && bl; ++i) {
            bl = this.deleteDirectory(fileArray[i]);
        }
        return bl;
    }

    private boolean deleteDirectory(File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n && bl; ++i) {
                bl = !fileArray[i].isDirectory() ? fileArray[i].delete() : this.deleteDirectory(fileArray[i]);
            }
            if (bl) {
                file.delete();
            }
        }
        return bl;
    }
}

