/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.CompositeIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsio.ReadOnlyFilesException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AddOrRefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.CreateNewClassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportModelJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ManageNonDescriptorClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.UiMappingBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.DeleteProjectAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ReadOnlyFileDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.UiProjectBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.EisProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.OXProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.UiQueryBundle;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.BlockIcon;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class ProjectNode
extends MappingsApplicationNode
implements AutomappableNode {
    private DescriptorPackageNode.DescriptorNodeBuilder descriptorNodeBuilder;
    private CollectionChangeListener descriptorsListener;
    private PropertyChangeListener descriptorNameListener;
    private CollectionValueModel descriptorPackageNodesHolder;
    private PropertyValueModel metaDataRepositoryNodeHolder;
    private ListValueModel childrenModel;
    private boolean promptsForEjbJarXmlWrite;
    protected static final String[] PROJECT_ICON_PROPERTY_NAMES = (String[])CollectionTools.addAll((Object[])DEFAULT_ICON_PROPERTY_NAMES, (Object[])new String[]{"validating"});
    protected static final Icon VALIDATING_ICON = new BlockIcon(2);
    protected static final String[] PROJECT_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE = "write ejb-jar.xml on save ";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_ALWAYS = "Yes";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_NEVER = "No";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_PROMPT = "Prompt";
    public static final String WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_DEFAULT = "Prompt";

    public static ProjectNode forProject(MWProject mWProject, ApplicationContext applicationContext, MappingsPlugin mappingsPlugin) {
        if (mWProject instanceof MWRelationalProject) {
            return new RelationalProjectNode((MWRelationalProject)mWProject, applicationContext, mappingsPlugin);
        }
        if (mWProject instanceof MWOXProject) {
            return new OXProjectNode((MWOXProject)mWProject, applicationContext, mappingsPlugin);
        }
        if (mWProject instanceof MWEisProject) {
            return new EisProjectNode((MWEisProject)mWProject, applicationContext, mappingsPlugin);
        }
        throw new IllegalArgumentException(mWProject.toString());
    }

    protected ProjectNode(MWProject mWProject, MappingsPlugin mappingsPlugin, ApplicationContext applicationContext) {
        super((MWModel)mWProject, applicationContext.getNodeManager().getRootNode(), (Plugin)mappingsPlugin, applicationContext);
    }

    protected void initialize() {
        super.initialize();
        this.descriptorNodeBuilder = this.buildDescriptorNodeBuilder();
        this.descriptorsListener = this.buildDescriptorsListener();
        this.descriptorNameListener = this.buildDescriptorNameListener();
        this.descriptorPackageNodesHolder = new SimpleCollectionValueModel();
        this.metaDataRepositoryNodeHolder = new SimplePropertyValueModel();
        this.childrenModel = this.buildChildrenModel();
        this.promptsForEjbJarXmlWrite = true;
    }

    protected abstract DescriptorPackageNode.DescriptorNodeBuilder buildDescriptorNodeBuilder();

    private CollectionChangeListener buildDescriptorsListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                ProjectNode.this.addDescriptorNodesFor(collectionChangeEvent.items());
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                ProjectNode.this.removeDescriptorNodesFor(collectionChangeEvent.items());
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                ProjectNode.this.rebuildDescriptorNodes();
            }

            public String toString() {
                return "descriptors listener";
            }
        };
    }

    private PropertyChangeListener buildDescriptorNameListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = ClassTools.packageNameForClassNamed((String)((String)propertyChangeEvent.getOldValue()));
                String string2 = ClassTools.packageNameForClassNamed((String)((String)propertyChangeEvent.getNewValue()));
                if (!string2.equals(string)) {
                    ProjectNode.this.descriptorChangedPackage((MWDescriptor)propertyChangeEvent.getSource(), string, string2);
                }
            }

            public String toString() {
                return "descriptor name listener";
            }
        };
    }

    private ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildChildrenDisplayStringAdapter(), Child.COMPARATOR){

            protected int indexToAddItems() {
                int n = super.indexToAddItems();
                return n > 0 ? --n : n;
            }

            public String toString() {
                return "children model";
            }
        };
    }

    private ListValueModel buildChildrenDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildUnsortedChildrenModel(), "displayString");
    }

    private CollectionValueModel buildUnsortedChildrenModel() {
        SimpleCollectionValueModel simpleCollectionValueModel = new SimpleCollectionValueModel();
        simpleCollectionValueModel.addItem(new PropertyCollectionValueModelAdapter(this.metaDataRepositoryNodeHolder));
        simpleCollectionValueModel.addItem(this.descriptorPackageNodesHolder);
        return new CompositeCollectionValueModel(simpleCollectionValueModel, Transformer.NULL_INSTANCE);
    }

    protected ApplicationContext expandContext(ApplicationContext applicationContext) {
        return super.expandContext(applicationContext).buildExpandedResourceRepositoryContext(UiProjectBundle.class).buildExpandedResourceRepositoryContext(UiQueryBundle.class).buildExpandedResourceRepositoryContext(UiMappingBundle.class).buildExpandedResourceRepositoryContext(UiDescriptorBundle.class).buildExpandedResourceRepositoryContext(UiCommonBundle.class);
    }

    private Iterator descriptors() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.descriptorPackageNodes()){

            protected Object transform(Object object) {
                return ((DescriptorPackageNode)object).descriptors();
            }
        });
    }

    public void addDescriptorsTo(Collection collection) {
        CollectionTools.addAll((Collection)collection, (Iterator)this.descriptors());
    }

    public boolean isAutoMappable() {
        return true;
    }

    protected void engageValue() {
        super.engageValue();
        this.getProject().addCollectionChangeListener("descriptors", this.descriptorsListener);
        this.addDescriptorNodesFor(this.getProject().descriptors());
        this.metaDataRepositoryNodeHolder.setValue(this.buildMetaDataRepositoryNode());
    }

    protected abstract Child buildMetaDataRepositoryNode();

    protected void disengageValue() {
        this.metaDataRepositoryNodeHolder.setValue(null);
        this.removeDescriptorNodesFor(this.getProject().descriptors());
        this.getProject().removeCollectionChangeListener("descriptors", this.descriptorsListener);
        super.disengageValue();
    }

    protected String[] iconPropertyNames() {
        return PROJECT_ICON_PROPERTY_NAMES;
    }

    protected IconBuilder buildIconBuilder() {
        IconBuilder iconBuilder = super.buildIconBuilder();
        return this.getApplicationContext().getApplication().isDevelopmentMode() ? this.buildDevelopmentModeIconBuilder(iconBuilder) : iconBuilder;
    }

    private IconBuilder buildDevelopmentModeIconBuilder(IconBuilder iconBuilder) {
        return new CompositeIconBuilder(iconBuilder, this.getProject().isValidating(), VALIDATING_ICON, -17, 0, 1, null);
    }

    protected String[] displayStringPropertyNames() {
        return PROJECT_DISPLAY_STRING_PROPERTY_NAMES;
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        this.addToMenuDescription(rootMenuDescription, workbenchContext);
        return rootMenuDescription;
    }

    protected abstract void addToMenuDescription(GroupContainerDescription var1, WorkbenchContext var2);

    protected MenuGroupDescription buildClassActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getRefreshClassesAction(workbenchContext));
        menuGroupDescription.add(this.getAddOrRefreshClassesAction(workbenchContext));
        menuGroupDescription.add(this.getCreateNewClassAction(workbenchContext));
        menuGroupDescription.add(this.getManageNonDescriptorClassesAction(workbenchContext));
        return menuGroupDescription;
    }

    protected MenuGroupDescription buildCloseDeleteActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getCloseAction(workbenchContext));
        menuGroupDescription.add(this.getDeleteProjectAction(workbenchContext));
        return menuGroupDescription;
    }

    protected MenuGroupDescription buildSaveActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getSaveAction(workbenchContext));
        menuGroupDescription.add(this.getSaveAsAction(workbenchContext));
        return menuGroupDescription;
    }

    protected MenuGroupDescription buildExportActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.buildExportMenuDescription(workbenchContext));
        return menuGroupDescription;
    }

    protected abstract GroupContainerDescription buildExportMenuDescription(WorkbenchContext var1);

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    public String helpTopicID() {
        return "project";
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarDescription();
    }

    protected final FrameworkAction getDeleteProjectAction(WorkbenchContext workbenchContext) {
        return new DeleteProjectAction(workbenchContext);
    }

    protected ExportDeploymentXmlAction getExportDeploymentXmlAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getExportDeploymentXmlAction(workbenchContext);
    }

    protected ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(workbenchContext);
    }

    protected RefreshClassesAction getRefreshClassesAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getRefreshClassesAction(workbenchContext);
    }

    protected AddOrRefreshClassesAction getAddOrRefreshClassesAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getAddOrRefreshClassesAction(workbenchContext);
    }

    protected CreateNewClassAction getCreateNewClassAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getCreateNewClassAction(workbenchContext);
    }

    protected ManageNonDescriptorClassesAction getManageNonDescriptorClassesAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getManageNonDescriptorClassesAction(workbenchContext);
    }

    protected ExportModelJavaSourceAction getModelJavaSourceAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getExportModelJavaSourceAction(workbenchContext);
    }

    protected FrameworkAction getSaveAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAction();
    }

    protected FrameworkAction getSaveAsAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getSaveAsAction();
    }

    protected FrameworkAction getCloseAction(WorkbenchContext workbenchContext) {
        return workbenchContext.getActionRepository().getCloseAction();
    }

    public File saveFile() {
        return this.getProject().saveFile();
    }

    public boolean save(File file, WorkbenchContext workbenchContext) {
        boolean bl = this.preferences().getBoolean("last refresh", true);
        this.getProject().getClassRepository().setPersistLastRefresh(bl);
        File file2 = this.saveFile();
        if (file2 == null) {
            if (this.getProject().isLegacyProject()) {
                JOptionPane.showMessageDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("PROJECT_SAVED_IN_NEW_FILE_FORMAT_DIALOG"));
            }
            return this.saveAs(file, workbenchContext);
        }
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        return this.saveInternal(file2, workbenchContext);
    }

    private boolean promptToWriteEjbJarXml(WorkbenchContext workbenchContext) {
        if (this.preferences().get(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE, "Prompt").equals(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_ALWAYS)) {
            return true;
        }
        if (this.preferences().get(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE, "Prompt").equals(WRITE_EJB_JAR_XML_ON_SAVE_PREFERENCE_NEVER)) {
            return false;
        }
        int n = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("WRITE_PROJECT_EJB_JAR_ON_SAVE_DIALOG"), this.resourceRepository().getString("WRITE_PROJECT_EJB_JAR_ON_SAVE_DIALOG.title"), 0);
        return n == 0;
    }

    public boolean saveAs(File file, WorkbenchContext workbenchContext) {
        File file2 = this.saveFile();
        File file3 = this.getProject().getSaveDirectory();
        if (file3 == null) {
            file3 = file;
            file2 = new File(file, this.getProject().getName() + ".mwp");
        }
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        LocalFileChooser localFileChooser = new LocalFileChooser(workbenchContext);
        localFileChooser.setDialogTitle(this.resourceRepository().getString("SAVE_AS_DIALOG_TITLE"));
        localFileChooser.setCurrentDirectory(file3);
        localFileChooser.setSelectedFile(file2);
        localFileChooser.setMultiSelectionEnabled(false);
        localFileChooser.setFileFilter(this.buildSaveAsDialogFileFilter(workbenchContext));
        int n = localFileChooser.showSaveDialog(workbenchContext.getCurrentWindow());
        if (n != 0) {
            return false;
        }
        file2 = localFileChooser.getSelectedFile();
        File file4 = file2.getParentFile();
        this.getProject().setSaveDirectory(file4);
        String string = file2.getName();
        if (string.toLowerCase().endsWith(".mwp")) {
            string = FileTools.stripExtension((String)string);
        }
        this.getProject().setName(string);
        workbenchContext.getNavigatorSelectionModel().pushExpansionState();
        boolean bl = this.saveInternal(file2, workbenchContext);
        workbenchContext.getNavigatorSelectionModel().popAndRestoreExpansionState();
        return bl;
    }

    private FileFilter buildSaveAsDialogFileFilter(final WorkbenchContext workbenchContext) {
        return new FileFilter(){

            public String getDescription() {
                return workbenchContext.getApplicationContext().getResourceRepository().getString("SAVE_AS_DIALOG_MWP_FILE_FILTER");
            }

            public boolean accept(File file) {
                return file.isDirectory() || ".mwp".equals(FileTools.extension((File)file));
            }
        };
    }

    private boolean saveInternal(File file, WorkbenchContext workbenchContext) {
        boolean bl;
        block3: {
            bl = false;
            ProjectIOManager projectIOManager = this.getMappingsPlugin().getIOManager();
            try {
                projectIOManager.write(this.getProject());
                bl = true;
            }
            catch (ReadOnlyFilesException readOnlyFilesException) {
                ReadOnlyFileDialog readOnlyFileDialog = new ReadOnlyFileDialog(workbenchContext, CollectionTools.collection((Object[])readOnlyFilesException.getFiles()));
                readOnlyFileDialog.show();
                if (readOnlyFileDialog.saveAsWasPressed()) {
                    return this.saveAs(null, workbenchContext);
                }
                if (!readOnlyFileDialog.saveWasPressed()) break block3;
                return this.saveInternal(file, workbenchContext);
            }
        }
        return bl;
    }

    public String getAutomapSuccessfulStringKey() {
        return "AUTOMAP_PROJECT_SUCCESSFUL";
    }

    public boolean canAutomapDescriptors() {
        return this.getProject().canAutomapDescriptors();
    }

    public abstract String getCannotAutomapDescriptorsStringKey();

    public MWProject getProject() {
        return (MWProject)this.getValue();
    }

    private Iterator descriptorPackageNodes() {
        return (Iterator)this.descriptorPackageNodesHolder.getValue();
    }

    private DescriptorPackageNode descriptorPackageNodeFor(MWDescriptor mWDescriptor) {
        return this.descriptorPackageNodeNamed(mWDescriptor.packageName());
    }

    public DescriptorPackageNode descriptorPackageNodeNamed(String string) {
        Iterator iterator = this.descriptorPackageNodes();
        while (iterator.hasNext()) {
            DescriptorPackageNode descriptorPackageNode = (DescriptorPackageNode)iterator.next();
            if (!descriptorPackageNode.getName().equals(string)) continue;
            return descriptorPackageNode;
        }
        return null;
    }

    public DescriptorNode descriptorNodeFor(MWDescriptor mWDescriptor) {
        return this.descriptorPackageNodeNamed(mWDescriptor.packageName()).descriptorNodeFor(mWDescriptor);
    }

    public abstract boolean supportsExportProjectJavaSource();

    public abstract boolean supportsExportTableCreatorJavaSource();

    protected DescriptorPackageNode.DescriptorNodeBuilder getDescriptorNodeBuilder() {
        return this.descriptorNodeBuilder;
    }

    public void selectDescriptorNodeFor(MWDescriptor mWDescriptor, NavigatorSelectionModel navigatorSelectionModel) {
        this.selectDescriptorNode(this.descriptorNodeFor(mWDescriptor), navigatorSelectionModel);
    }

    public void selectDescriptorNode(DescriptorNode descriptorNode, NavigatorSelectionModel navigatorSelectionModel) {
        navigatorSelectionModel.setSelectedNode(descriptorNode);
    }

    public void selectMappingNodeFor(MWMapping mWMapping, NavigatorSelectionModel navigatorSelectionModel) {
        MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)this.descriptorNodeFor((MWDescriptor)mWMapping.getParentDescriptor());
        mappingDescriptorNode.selectMappingNodeFor(mWMapping, navigatorSelectionModel);
    }

    public void selectMappingNodeFor(MWClassAttribute mWClassAttribute, NavigatorSelectionModel navigatorSelectionModel) {
        MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)this.descriptorNodeFor(this.getProject().descriptorForType((MWClass)mWClassAttribute.getParent()));
        mappingDescriptorNode.selectMappingNodeFor(mWClassAttribute, navigatorSelectionModel);
    }

    public void selectMethod(MWMethod mWMethod, WorkbenchContext workbenchContext) {
        MWDescriptor mWDescriptor = this.getProject().descriptorForType((MWClass)mWMethod.getParent());
        if (mWDescriptor != null) {
            MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)this.descriptorNodeFor(mWDescriptor);
            this.selectDescriptorNode(mappingDescriptorNode, workbenchContext.getNavigatorSelectionModel());
            mappingDescriptorNode.selectMethod(mWMethod, workbenchContext);
        }
    }

    public void setPromptsForEjbJarXmlWrite(boolean bl) {
        this.promptsForEjbJarXmlWrite = bl;
    }

    protected abstract DescriptorPackageNode buildDescriptorPackageNodeFor(MWDescriptor var1);

    void addDescriptorNodesFor(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addDescriptorNodeFor((MWDescriptor)iterator.next());
        }
    }

    private void addDescriptorNodeFor(MWDescriptor mWDescriptor) {
        mWDescriptor.addPropertyChangeListener("name", this.descriptorNameListener);
        this.addDescriptorNodeTo(mWDescriptor, this.descriptorPackageNodeFor(mWDescriptor));
    }

    private void addDescriptorNodeTo(MWDescriptor mWDescriptor, DescriptorPackageNode descriptorPackageNode) {
        if (descriptorPackageNode == null) {
            descriptorPackageNode = this.buildDescriptorPackageNodeFor(mWDescriptor);
            this.descriptorPackageNodesHolder.addItem(descriptorPackageNode);
        }
        descriptorPackageNode.addDescriptorNodeFor(mWDescriptor);
    }

    void removeDescriptorNodesFor(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeDescriptorNodeFor((MWDescriptor)iterator.next());
        }
    }

    private void removeDescriptorNodeFor(MWDescriptor mWDescriptor) {
        this.removeDescriptorNodeFrom(mWDescriptor, this.descriptorPackageNodeFor(mWDescriptor));
        mWDescriptor.removePropertyChangeListener("name", this.descriptorNameListener);
    }

    private void removeDescriptorNodeFrom(MWDescriptor mWDescriptor, DescriptorPackageNode descriptorPackageNode) {
        descriptorPackageNode.removeDescriptorNodeFor(mWDescriptor);
        if (descriptorPackageNode.descriptorNodesSize() == 0) {
            this.descriptorPackageNodesHolder.removeItem(descriptorPackageNode);
        }
    }

    void rebuildDescriptorNodes() {
        List list = CollectionTools.list((Iterator)this.descriptors());
        this.removeDescriptorNodesFor(list.iterator());
        this.addDescriptorNodesFor(this.getProject().descriptors());
    }

    void descriptorChangedPackage(MWDescriptor mWDescriptor, String string, String string2) {
        this.removeDescriptorNodeFrom(mWDescriptor, this.descriptorPackageNodeNamed(string));
        this.addDescriptorNodeTo(mWDescriptor, this.descriptorPackageNodeNamed(string2));
    }

    private class LocalFileChooser
    extends JFileChooser {
        private WorkbenchContext workbenchContext;

        private LocalFileChooser(WorkbenchContext workbenchContext) {
            this.workbenchContext = workbenchContext;
        }

        public void approveSelection() {
            int n = this.canReplaceExistingFile();
            if (n == 0) {
                super.approveSelection();
            } else if (n == 2) {
                this.cancelSelection();
            }
        }

        private ResourceRepository resourceRepository() {
            return this.workbenchContext.getApplicationContext().getResourceRepository();
        }

        private int canReplaceExistingFile() {
            File file = this.getSelectedFile();
            String string = this.workbenchContext.getApplicationContext().getApplication().getShortProductName();
            if (this.isDocumentOpened(file)) {
                String string2 = this.resourceRepository().getString("SAVE_AS_DIALOG_ALREADY_OPENED", string, file, StringTools.CR);
                LabelArea labelArea = new LabelArea(string2);
                labelArea.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), labelArea, string, 2);
                return 1;
            }
            if (file.exists() && !file.canWrite()) {
                String string3 = this.resourceRepository().getString("SAVE_AS_DIALOG_CANT_SAVE", file, StringTools.CR);
                LabelArea labelArea = new LabelArea(string3);
                labelArea.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), labelArea, string, 2);
                return 1;
            }
            if (ProjectNode.this.saveFile() != null && file.exists() && ProjectNode.this.saveFile().equals(file)) {
                String string4 = this.resourceRepository().getString("SAVE_AS_DIALOG_REPLACE", this.getSelectedFile().getPath());
                LabelArea labelArea = new LabelArea(string4);
                labelArea.setPreferredWidth(800);
                return JOptionPane.showConfirmDialog(this.workbenchContext.getCurrentWindow(), labelArea, string, 1);
            }
            if (!this.isValidSaveDirectory(file.getParentFile())) {
                String string5 = this.resourceRepository().getString("NEED_EMPTY_DIRECTORY_TO_SAVE_DIALOG.message");
                LabelArea labelArea = new LabelArea(string5);
                labelArea.setPreferredWidth(800);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), labelArea, this.resourceRepository().getString("NEED_EMPTY_DIRECTORY_TO_SAVE_DIALOG.title"), 0);
                return 1;
            }
            return 0;
        }

        private boolean isValidSaveDirectory(File file) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return true;
            }
            int n = fileArray.length;
            while (n-- > 0) {
                File file2 = fileArray[n];
                if (file2.isDirectory() || !file2.getName().endsWith(".mwp")) continue;
                return false;
            }
            return true;
        }

        private boolean isDocumentOpened(File file) {
            ApplicationNode[] applicationNodeArray = ProjectNode.this.nodeManager().projectNodesFor(ProjectNode.this.getPlugin());
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                File file2;
                ProjectNode projectNode = (ProjectNode)applicationNodeArray[i];
                if (projectNode == ProjectNode.this || (file2 = projectNode.saveFile()) == null || !file.equals(file2)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Child
    extends Comparable {
        public static final Comparator COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((Child)object).getProjectNodeChildPriority();
                if (n2 == (n = ((Child)object2).getProjectNodeChildPriority())) {
                    return ((Comparable)object).compareTo(object2);
                }
                return n2 - n;
            }

            public String toString() {
                return "ProjectNode.Child.COMPARATOR";
            }
        };

        public int getProjectNodeChildPriority();
    }
}

