/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

final class ReadOnlyFileDialog
extends AbstractDialog {
    private Vector files;
    private boolean saveAsWasPressed;

    ReadOnlyFileDialog(WorkbenchContext workbenchContext, Collection collection) {
        super(workbenchContext);
        this.files = (Vector)CollectionTools.sort(new Vector(collection));
    }

    protected String helpTopicId() {
        return "dialog.readOnly";
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("versionControlAssistance.title"));
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextArea jTextArea = new JTextArea(this.resourceRepository().getString("versionControlAssistance.message"), 0, 50);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(this.getBackground());
        jTextArea.setFont(this.getFont());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jTextArea, gridBagConstraints);
        JList jList = SwingComponentFactory.buildList(this.files);
        JLabel jLabel = new JLabel(this.resourceRepository().getString("readOnlyFiles"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)new JScrollPane(jList), gridBagConstraints);
        return jPanel;
    }

    protected String buildOKText() {
        return this.resourceRepository().getString("save");
    }

    protected Iterator buildCustomActions() {
        return new SingleElementIterator((Object)this.buildSaveAsAction());
    }

    private Action buildSaveAsAction() {
        return new AbstractFrameworkAction(this.getWorkbenchContext()){

            protected void initialize() {
                this.initializeTextAndMnemonic("saveAs");
            }

            protected void execute() {
                ReadOnlyFileDialog.this.saveAsPressed();
            }
        };
    }

    void saveAsPressed() {
        if (this.preConfirm()) {
            this.saveAsWasPressed = true;
            this.dispose();
        }
    }

    boolean saveAsWasPressed() {
        return this.saveAsWasPressed;
    }

    boolean saveWasPressed() {
        return this.wasConfirmed();
    }
}

