/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ZeroArgConstructorPreference {
    public static final String MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_PREFERENCE = "mantain zero argument constructor";
    public static final String YES = "true";
    public static final String NO = "false";
    public static final String PROMPT = "prompt";
    public static final String DEFAULT = "prompt";

    private ZeroArgConstructorPreference() {
    }

    public static void optionallyAddZeroArgumentConstructor(MWClass mWClass, WorkbenchContext workbenchContext) {
        String string = workbenchContext.getApplicationContext().getPreferences().get(MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_PREFERENCE, "prompt").intern();
        if (string == YES || string == "prompt" && ZeroArgConstructorPreference.promptForResponse(mWClass, workbenchContext)) {
            mWClass.addZeroArgumentConstructor();
        }
    }

    private static boolean promptForResponse(MWClass mWClass, WorkbenchContext workbenchContext) {
        Preferences preferences = workbenchContext.getApplicationContext().getPreferences();
        ResourceRepository resourceRepository = workbenchContext.getApplicationContext().getResourceRepository();
        String string = resourceRepository.getString("PREFERENCES.MAPPINGS.CLASS.MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_DIALOG.title");
        String string2 = resourceRepository.getString("PREFERENCES.MAPPINGS.CLASS.MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_DIALOG.message", new Object[]{mWClass.getName(), StringTools.CR});
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(new Boolean(false));
        JComponent jComponent = SwingComponentFactory.buildDoNotAskAgainPanel(string2, simplePropertyValueModel, resourceRepository);
        int n = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), jComponent, string, 0, 3);
        if (simplePropertyValueModel.getValue().equals(Boolean.TRUE)) {
            String string3 = "prompt";
            if (n == 0) {
                string3 = YES;
            } else if (n == 1) {
                string3 = NO;
            }
            preferences.put(MAINTAIN_ZERO_ARGUMENT_CONSTRUCTOR_PREFERENCE, string3);
        }
        return n == 0;
    }
}

