/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWSequencingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ExtendedListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class RelationalProjectSequencingPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel sequencingPolicyHolder;
    private PseudoPreallocationSizeModel pseudoModel;
    private PropertyValueModel sequenceTableHolder;

    RelationalProjectSequencingPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.sequencingPolicyHolder = this.buildSequencingPolicyHolder();
        this.sequenceTableHolder = this.buildSequenceTableHolder(this.sequencingPolicyHolder);
        this.getSelectionHolder().addPropertyChangeListener("value", this.buildSelectionHolderListener());
        this.pseudoModel = new PseudoPreallocationSizeModel();
        this.pseudoModel.setParentNode((Node)((AbstractNodeModel)this.selection()));
    }

    private PropertyChangeListener buildSelectionHolderListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RelationalProjectSequencingPropertiesPage.this.pseudoModel.setParentNode((Node)((AbstractNodeModel)propertyChangeEvent.getNewValue()));
            }
        };
    }

    private PropertyValueModel buildSequencingPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWRelationalProject)this.subject).getSequencingPolicy();
            }
        };
    }

    private PropertyValueModel buildSequenceTableHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "table"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getTable();
            }

            protected void setValueOnSubject(Object object) {
                ((MWSequencingPolicy)this.subject).setTable((MWTable)object);
            }
        };
    }

    private String helpTopicId() {
        return "project.sequencing";
    }

    private ComponentEnabler buildNativeSequencingEnabler(JComponent jComponent) {
        return new ComponentEnabler((ValueModel)this.buildNativeSequencingEnableStateHolder(), Collections.singleton(jComponent));
    }

    private PropertyValueModel buildNativeSequencingEnableStateHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSelectionHolder(), ""){

            protected Object getValueFromSubject() {
                MWRelationalProject mWRelationalProject = (MWRelationalProject)this.subject;
                return mWRelationalProject.getDatabase();
            }
        };
        PropertyAspectAdapter propertyAspectAdapter2 = new PropertyAspectAdapter(propertyAspectAdapter, "databasePlatform"){

            protected Object getValueFromSubject() {
                MWDatabase mWDatabase = (MWDatabase)this.subject;
                return mWDatabase.getDatabasePlatform();
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter2){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                try {
                    DatabasePlatform databasePlatform = (DatabasePlatform)object;
                    return databasePlatform.supportsNativeSequencing();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Boolean.FALSE;
                }
            }
        };
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComponent jComponent = this.buildLabeledSpinnerNumber("SEQUENCING_PREALLOCATION_SIZE_SPINNER_LABEL", this.buildSequencingPrealocationSizeSpinnerModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.addHelpTopicId(jComponent, this.helpTopicId() + ".preallocation");
        this.buildPreallocationSizeEnabler(jComponent);
        PropertyValueModel propertyValueModel = this.buildSequencingTypeHolder(this.sequencingPolicyHolder);
        JRadioButton jRadioButton = this.buildDefaultSequencingRadioButton(propertyValueModel);
        this.addHelpTopicId(jRadioButton, this.helpTopicId() + ".useDefault");
        JRadioButton jRadioButton2 = this.buildNativeSequencingRadioButton(propertyValueModel);
        this.addHelpTopicId(jRadioButton2, this.helpTopicId() + ".native");
        this.buildNativeSequencingEnabler(jRadioButton2);
        JRadioButton jRadioButton3 = this.buildSequenceTableRadioButton(propertyValueModel);
        this.addHelpTopicId(jRadioButton3, "session.login.database.sequencing.table");
        JComponent jComponent2 = this.buildSequenceTablePanel(propertyValueModel);
        GroupBox groupBox = new GroupBox((AbstractButton)jRadioButton, jRadioButton2, (AbstractButton)jRadioButton3, jComponent2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)groupBox, gridBagConstraints);
        this.addHelpTopicId(groupBox, "session.login.database.sequencing.table");
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    protected JComponent buildSequenceTablePanel(PropertyValueModel propertyValueModel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        JLabel jLabel = SwingComponentFactory.buildLabel("SEQUENCING_TABLE_NAME_LIST_CHOOSER_LABEL", this.resourceRepository());
        arrayList.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ListChooser listChooser = this.buildSequenceTableChooser();
        arrayList.add(listChooser);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)listChooser, gridBagConstraints);
        jLabel.setLabelFor(listChooser);
        JLabel jLabel2 = SwingComponentFactory.buildLabel("SEQUENCING_NAME_FIELD_COMBO_BOX_LABEL", this.resourceRepository());
        arrayList.add(jLabel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ListChooser listChooser2 = this.buildSequenceNameColumnChooser();
        arrayList.add(listChooser2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)listChooser2, gridBagConstraints);
        jLabel2.setLabelFor(listChooser2);
        JLabel jLabel3 = SwingComponentFactory.buildLabel("SEQUENCING_COUNTER_FIELD_COMBO_BOX_LABEL", this.resourceRepository());
        arrayList.add(jLabel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ListChooser listChooser3 = this.buildSequenceCounterColumnChooser();
        arrayList.add(listChooser3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)listChooser3, gridBagConstraints);
        jLabel3.setLabelFor(listChooser3);
        new ComponentEnabler(this.buildSequenceTypeBooleanHolder(propertyValueModel), arrayList);
        return jPanel;
    }

    private ValueModel buildSequenceTypeBooleanHolder(PropertyValueModel propertyValueModel) {
        return new TransformationPropertyValueModel(propertyValueModel){

            protected Object transform(Object object) {
                return object == "Use sequencing table" ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    private PropertyValueModel buildPreallocationSizeEnableStateHolder() {
        return new PropertyAspectAdapter("enabled", (Model)this.pseudoModel){

            protected Object getValueFromSubject() {
                PseudoPreallocationSizeModel pseudoPreallocationSizeModel = (PseudoPreallocationSizeModel)((Object)this.subject);
                return pseudoPreallocationSizeModel.isEnabled();
            }
        };
    }

    private ComponentEnabler buildPreallocationSizeEnabler(JComponent jComponent) {
        return new ComponentEnabler((ValueModel)this.buildPreallocationSizeEnableStateHolder(), Collections.singleton(jComponent));
    }

    private SpinnerNumberModel buildSequencingPrealocationSizeSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildSequencingPrealocationSizeHolder(), new Integer(0), null, new Integer(1), new Integer(0));
    }

    private PropertyValueModel buildSequencingPrealocationSizeHolder() {
        return new PropertyAspectAdapter(this.sequencingPolicyHolder, "preallocationSize"){

            protected Object getValueFromSubject() {
                return new Integer(((MWSequencingPolicy)this.subject).getPreallocationSize());
            }

            protected void setValueOnSubject(Object object) {
                ((MWSequencingPolicy)this.subject).setPreallocationSize(((Number)object).intValue());
            }
        };
    }

    private PropertyValueModel buildSequencingTypeHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "SequencingType"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getSequencingType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWSequencingPolicy)this.subject).setSequencingType((String)object);
            }
        };
    }

    private JRadioButton buildDefaultSequencingRadioButton(PropertyValueModel propertyValueModel) {
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("DEFAULT_SEQUENCING_RADIO_BUTTON_TEXT", this.buildRadioButtonModelAdapter(propertyValueModel, "Use default sequencing", true), this.resourceRepository());
        return jRadioButton;
    }

    private JRadioButton buildNativeSequencingRadioButton(PropertyValueModel propertyValueModel) {
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("NATIVE_SEQUENCING_RADIO_BUTTON_TEXT", this.buildRadioButtonModelAdapter(propertyValueModel, "Use native sequencing", false), this.resourceRepository());
        return jRadioButton;
    }

    private JRadioButton buildSequenceTableRadioButton(PropertyValueModel propertyValueModel) {
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("CUSTOM_SEQUENCE_TABLE_RADIO_BUTTON_TEXT", this.buildRadioButtonModelAdapter(propertyValueModel, "Use sequencing table", false), this.resourceRepository());
        return jRadioButton;
    }

    private ButtonModel buildRadioButtonModelAdapter(PropertyValueModel propertyValueModel, String string, boolean bl) {
        return new RadioButtonModelAdapter(propertyValueModel, string, bl);
    }

    private ListChooser buildSequenceTableChooser() {
        return RelationalProjectComponentFactory.buildTableChooser(this.getSelectionHolder(), this.sequenceTableHolder, this.buildSequenceTableChooserDialogBuilder(), this.getWorkbenchContextHolder());
    }

    private DefaultListChooserDialog.Builder buildSequenceTableChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTableStringConverter());
        return builder;
    }

    private StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWTable)object).getName();
            }
        };
    }

    private ListChooser buildSequenceNameColumnChooser() {
        PropertyValueModel propertyValueModel = this.buildSequenceNameColumnAdapter(this.sequencingPolicyHolder);
        DefaultListChooser defaultListChooser = new DefaultListChooser(RelationalProjectSequencingPropertiesPage.buildComboBoxModelAdapter(this.buildExtendedColumnsAdapter(this.sequenceTableHolder), propertyValueModel), this.getWorkbenchContextHolder(), this.buildSequenceNameColumnChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildColumnListCellRenderer());
        return defaultListChooser;
    }

    private DefaultListChooserDialog.Builder buildSequenceNameColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_NAME_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_NAME_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildColumnStringConverter());
        return builder;
    }

    private PropertyValueModel buildSequenceNameColumnAdapter(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "nameColumn"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getNameColumn();
            }

            protected void setValueOnSubject(Object object) {
                ((MWSequencingPolicy)this.subject).setNameColumn((MWColumn)object);
            }
        };
    }

    private static ComboBoxModel buildComboBoxModelAdapter(ListValueModel listValueModel, PropertyValueModel propertyValueModel) {
        return new ComboBoxModelAdapter(listValueModel, propertyValueModel);
    }

    private ListCellRenderer buildColumnListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private StringConverter buildColumnStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWColumn)object).getName();
            }
        };
    }

    private ListChooser buildSequenceCounterColumnChooser() {
        PropertyValueModel propertyValueModel = this.buildSequenceCounterColumnAdapter(this.sequencingPolicyHolder);
        DefaultListChooser defaultListChooser = new DefaultListChooser(RelationalProjectSequencingPropertiesPage.buildComboBoxModelAdapter(this.buildExtendedColumnsAdapter(this.sequenceTableHolder), propertyValueModel), this.getWorkbenchContextHolder(), this.buildSequenceCounterColumnChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildColumnListCellRenderer());
        return defaultListChooser;
    }

    private DefaultListChooserDialog.Builder buildSequenceCounterColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_COUNTER_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_COUNTER_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildColumnStringConverter());
        return builder;
    }

    private PropertyValueModel buildSequenceCounterColumnAdapter(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "counterColumn"){

            protected Object getValueFromSubject() {
                return ((MWSequencingPolicy)this.subject).getCounterColumn();
            }

            protected void setValueOnSubject(Object object) {
                ((MWSequencingPolicy)this.subject).setCounterColumn((MWColumn)object);
            }
        };
    }

    private ListValueModel buildExtendedColumnsAdapter(PropertyValueModel propertyValueModel) {
        return new ExtendedListValueModelWrapper(new CollectionListValueModelAdapter(this.buildColumnsAdapter(propertyValueModel)));
    }

    private CollectionValueModel buildColumnsAdapter(PropertyValueModel propertyValueModel) {
        return new CollectionAspectAdapter(propertyValueModel, "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private class PseudoPreallocationSizeModel
    extends AbstractNodeModel {
        private boolean enabled;
        private PropertyChangeListener listener;

        private PseudoPreallocationSizeModel() {
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PseudoPreallocationSizeModel.this.updateEnableState();
                }
            };
        }

        protected void checkParent(Node node) {
        }

        private void disengageListeners() {
            MWRelationalProject mWRelationalProject = (MWRelationalProject)this.getParent();
            if (mWRelationalProject != null) {
                mWRelationalProject.getSequencingPolicy().removePropertyChangeListener("SequencingType", this.listener);
                mWRelationalProject.removePropertyChangeListener("databasePlatform", this.listener);
            }
        }

        public String displayString() {
            return null;
        }

        private void engageListeners() {
            MWRelationalProject mWRelationalProject = (MWRelationalProject)this.getParent();
            if (mWRelationalProject != null) {
                mWRelationalProject.getSequencingPolicy().addPropertyChangeListener("SequencingType", this.listener);
                mWRelationalProject.addPropertyChangeListener("databasePlatform", this.listener);
            }
        }

        protected void initialize() {
            super.initialize();
            this.listener = this.buildPropertyChangeListener();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            this.enabled = bl;
            this.firePropertyChanged("enabled", bl2, bl);
        }

        public void setParentNode(Node node) {
            this.disengageListeners();
            super.setParent(node);
            this.engageListeners();
            if (node != null) {
                this.updateEnableState();
            }
        }

        private void updateEnableState() {
            boolean bl;
            MWRelationalProject mWRelationalProject = (MWRelationalProject)this.getParent();
            DatabasePlatform databasePlatform = mWRelationalProject.getDatabase().getDatabasePlatform();
            boolean bl2 = bl = databasePlatform.getName().toLowerCase().indexOf("oracle") != -1;
            if (mWRelationalProject.getSequencingPolicy().getSequencingType() == "Use native sequencing") {
                this.setEnabled(bl);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

