/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.login;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWProperty;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class PropertyPane
extends AbstractSubjectPanel {
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private ObjectListSelectionModel selectionModel;
    private JTable table;

    public PropertyPane(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    private ActionListener buildAddActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor propertyEditor = PropertyPane.this.currentWindow() instanceof Dialog ? new PropertyEditor("LOGIN_PROPERTY_EDITOR_ADD_TITLE", (Dialog)PropertyPane.this.currentWindow()) : new PropertyEditor("LOGIN_PROPERTY_EDITOR_ADD_TITLE");
                propertyEditor.setVisible(true);
                if (propertyEditor.wasConfirmed()) {
                    propertyEditor.apply();
                }
            }
        };
    }

    private ActionListener buildEditActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor propertyEditor = PropertyPane.this.currentWindow() instanceof Dialog ? new PropertyEditor("LOGIN_PROPERTY_EDITOR_EDIT_TITLE", (Dialog)PropertyPane.this.currentWindow(), (MWProperty)PropertyPane.this.selectionModel.getSelectedValue()) : new PropertyEditor("LOGIN_PROPERTY_EDITOR_EDIT_TITLE", (MWProperty)PropertyPane.this.selectionModel.getSelectedValue());
                propertyEditor.setVisible(true);
                if (propertyEditor.wasConfirmed()) {
                    propertyEditor.apply();
                }
            }
        };
    }

    private void buildEditButtonEnabler() {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PropertyPane.this.editButton.setEnabled(PropertyPane.this.selectionModel.getSelectedValues().length == 1);
                }
            }
        });
    }

    private CollectionValueModel buildPropertyCollectionHolder() {
        return new CollectionAspectAdapter(this.buildLoginSpecHolder(), "property"){

            protected Iterator getValueFromSubject() {
                MWEisLoginSpec mWEisLoginSpec = (MWEisLoginSpec)this.subject;
                return mWEisLoginSpec.getProperties().iterator();
            }

            protected int sizeFromSubject() {
                MWEisLoginSpec mWEisLoginSpec = (MWEisLoginSpec)this.subject;
                return mWEisLoginSpec.propertySize();
            }
        };
    }

    private ObjectListSelectionModel buildPropertySelectionModel() {
        ListModelAdapter listModelAdapter = new ListModelAdapter(this.buildPropertyCollectionHolder());
        return new ObjectListSelectionModel(listModelAdapter);
    }

    private TableModel buildPropertyTableAdapter() {
        return new TableModelAdapter(this.buildPropertyCollectionHolder(), (ColumnAdapter)new PropertyColumnAdapter());
    }

    private ActionListener buildRemoveActionListener(final ObjectListSelectionModel objectListSelectionModel) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = objectListSelectionModel.getSelectedValues();
                MWEisProject mWEisProject = (MWEisProject)PropertyPane.this.subject();
                MWEisLoginSpec mWEisLoginSpec = mWEisProject.getEisLoginSpec();
                int n = objectArray.length;
                while (--n >= 0) {
                    mWEisLoginSpec.removeProperty((MWProperty)objectArray[n]);
                }
            }
        };
    }

    private void buildRemoveButtonEnabler() {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PropertyPane.this.removeButton.setEnabled(!PropertyPane.this.selectionModel.isSelectionEmpty());
                }
            }
        });
    }

    private TableColumnModel buildTableColumnModel() {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0);
        tableColumn.setCellRenderer(new SelectionTableCellRenderer());
        tableColumn.setHeaderValue(" ");
        tableColumn.setMaxWidth(20);
        tableColumn.setMinWidth(20);
        tableColumn.setPreferredWidth(20);
        tableColumn.setResizable(false);
        defaultTableColumnModel.addColumn(tableColumn);
        TableColumn tableColumn2 = new TableColumn(1);
        tableColumn2.setHeaderValue(this.resourceRepository().getString("LOGIN_PROPERTY_NAME_COLUMN"));
        tableColumn2.setMinWidth(50);
        tableColumn2.setResizable(true);
        defaultTableColumnModel.addColumn(tableColumn2);
        TableColumn tableColumn3 = new TableColumn(2);
        tableColumn3.setHeaderValue(this.resourceRepository().getString("LOGIN_PROPERTY_VALUE_COLUMN"));
        tableColumn3.setMinWidth(50);
        tableColumn3.setResizable(true);
        defaultTableColumnModel.addColumn(tableColumn3);
        return defaultTableColumnModel;
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.selectionModel = this.buildPropertySelectionModel();
        this.table = SwingComponentFactory.buildTable(this.buildPropertyTableAdapter(), this.buildTableColumnModel(), this.selectionModel);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setAutoResizeMode(4);
        this.table.setAutoscrolls(true);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addPropertyChangeListener("enabled", new PropertyChangeHandler());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setMinimumSize(new Dimension(0, 0));
        this.scrollPane.setPreferredSize(new Dimension(0, 0));
        this.scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.addButton = this.buildButton("LOGIN_PROPERTY_ADD_BUTTON");
        this.addButton.addActionListener(this.buildAddActionListener());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.editButton = this.buildButton("LOGIN_PROPERTY_EDIT_BUTTON");
        this.editButton.addActionListener(this.buildEditActionListener());
        this.editButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        this.buildEditButtonEnabler();
        this.removeButton = this.buildButton("LOGIN_PROPERTY_REMOVE_BUTTON");
        this.removeButton.addActionListener(this.buildRemoveActionListener(this.selectionModel));
        this.removeButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.buildRemoveButtonEnabler();
        this.addHelpTopicId(this, "session.login.properties");
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.table.setEnabled(bl);
        this.table.getTableHeader().setEnabled(bl);
        if (bl) {
            this.editButton.setEnabled(this.selectionModel.getSelectedValues().length == 1);
            this.removeButton.setEnabled(!this.selectionModel.isSelectionEmpty());
        } else {
            this.table.clearSelection();
            this.editButton.setEnabled(bl);
            this.removeButton.setEnabled(bl);
        }
    }

    private PropertyAspectAdapter buildLoginSpecHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            protected Object getValueFromSubject() {
                return ((MWEisProject)this.subject).getEisLoginSpec();
            }
        };
    }

    private class VirtualProperty {
        public String key;
        private MWProperty propertyAdapter;
        public String value;

        VirtualProperty(MWProperty mWProperty) {
            this.initialize(mWProperty);
        }

        void apply() {
            if (this.propertyAdapter == null) {
                MWEisProject mWEisProject = (MWEisProject)PropertyPane.this.subject();
                MWEisLoginSpec mWEisLoginSpec = mWEisProject.getEisLoginSpec();
                this.propertyAdapter = mWEisLoginSpec.addProperty(this.key, this.value);
            } else {
                this.propertyAdapter.setKey(this.key);
                this.propertyAdapter.setValue(this.value);
            }
        }

        private void initialize(MWProperty mWProperty) {
            this.propertyAdapter = mWProperty;
            if (mWProperty != null) {
                this.key = mWProperty.getKey();
                this.value = mWProperty.getValue();
            } else {
                this.key = "";
                this.value = "";
            }
        }
    }

    private class SelectionTableCellRenderer
    extends SimpleTableCellRenderer {
        private SelectionTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                component.setBackground(jTable.getTableHeader().getBackground());
            }
            return component;
        }
    }

    private class PropertyEditorView
    extends AbstractSubjectPanel {
        static final String VALUE_PROPERTY = "value";
        static final String NAME_PROPERTY = "name";

        public PropertyEditorView(PropertyValueModel propertyValueModel, ApplicationContext applicationContext) {
            super((ValueModel)propertyValueModel, applicationContext);
        }

        private Document buildNameDocumentAdapter() {
            return new DocumentAdapter(this.buildNameHolder());
        }

        private PropertyValueModel buildNameHolder() {
            return new SimplePropertyValueModel(){

                public Object getValue() {
                    VirtualProperty virtualProperty = (VirtualProperty)PropertyEditorView.this.subject();
                    return virtualProperty.key;
                }

                public void setValue(Object object) {
                    VirtualProperty virtualProperty = (VirtualProperty)PropertyEditorView.this.subject();
                    String string = virtualProperty.key;
                    virtualProperty.key = ((String)object).trim();
                    PropertyEditorView.this.firePropertyChange(PropertyEditorView.NAME_PROPERTY, string, virtualProperty.key);
                }
            };
        }

        private Document buildValueDocumentAdapter() {
            return new DocumentAdapter(this.buildValueHolder());
        }

        private PropertyValueModel buildValueHolder() {
            return new SimplePropertyValueModel(){

                public Object getValue() {
                    VirtualProperty virtualProperty = (VirtualProperty)PropertyEditorView.this.subject();
                    return virtualProperty.value;
                }

                public void setValue(Object object) {
                    VirtualProperty virtualProperty = (VirtualProperty)PropertyEditorView.this.subject();
                    String string = virtualProperty.value;
                    virtualProperty.value = ((String)object).trim();
                    PropertyEditorView.this.firePropertyChange(PropertyEditorView.VALUE_PROPERTY, string, virtualProperty.value);
                }
            };
        }

        public Component getInitialFocusComponent() {
            return (Component)this.getClientProperty("initialFocus");
        }

        protected void initializeLayout() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JComponent jComponent = this.buildLabeledTextField("LOGIN_PROPERTY_EDITOR_NAME_FIELD", this.buildNameDocumentAdapter());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            this.putClientProperty("initialFocus", jComponent.getComponent(1));
            JComponent jComponent2 = this.buildLabeledTextField("LOGIN_PROPERTY_EDITOR_VALUE_FIELD", this.buildValueDocumentAdapter());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)jComponent2, gridBagConstraints);
        }
    }

    private class PropertyEditor
    extends AbstractValidatingDialog {
        private Component initialFocusComponent;
        private final VirtualProperty virtualProperty;

        public PropertyEditor(String string) {
            this(string, (MWProperty)null);
        }

        public PropertyEditor(String string, Dialog dialog) {
            this(string, dialog, null);
        }

        public PropertyEditor(String string, Dialog dialog, MWProperty mWProperty) {
            super(PropertyPane.this.getWorkbenchContext(), PropertyPane.this.resourceRepository().getString(string), dialog);
            this.virtualProperty = new VirtualProperty(mWProperty);
        }

        public PropertyEditor(String string, MWProperty mWProperty) {
            super(PropertyPane.this.getWorkbenchContext(), PropertyPane.this.resourceRepository().getString(string));
            this.virtualProperty = new VirtualProperty(mWProperty);
        }

        public void apply() {
            if (this.wasConfirmed()) {
                this.virtualProperty.apply();
            }
        }

        protected Component buildMainPanel() {
            PropertyEditorView propertyEditorView = new PropertyEditorView(new SimplePropertyValueModel(this.virtualProperty), this.getApplicationContext());
            PropertyChangeListener propertyChangeListener = this.buildValidationPropertyListener();
            propertyEditorView.addPropertyChangeListener("name", propertyChangeListener);
            propertyEditorView.addPropertyChangeListener("value", propertyChangeListener);
            this.initialFocusComponent = propertyEditorView.getInitialFocusComponent();
            return propertyEditorView;
        }

        private PropertyChangeListener buildValidationPropertyListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PropertyEditor.this.validate(propertyChangeEvent.getPropertyName());
                }
            };
        }

        protected String helpTopicId() {
            return "session.login.properties.propertyEditor";
        }

        protected Component initialFocusComponent() {
            return this.initialFocusComponent;
        }

        protected void prepareToShow() {
            super.prepareToShow();
            ((JTextField)this.initialFocusComponent).selectAll();
            this.getOKAction().setEnabled(this.virtualProperty.propertyAdapter != null);
        }

        private void validate(String string) {
            String string2;
            String string3 = this.virtualProperty.value.length() == 0 ? "_EMPTY_VALUE" : null;
            String string4 = null;
            if (this.virtualProperty.key.length() == 0) {
                string4 = "_EMPTY_NAME";
            } else {
                string2 = (MWEisProject)PropertyPane.this.subject();
                MWEisLoginSpec mWEisLoginSpec = string2.getEisLoginSpec();
                Iterator iterator = mWEisLoginSpec.properties();
                while (iterator.hasNext()) {
                    MWProperty mWProperty = (MWProperty)iterator.next();
                    if (mWProperty == this.virtualProperty.propertyAdapter || !mWProperty.getKey().equalsIgnoreCase(this.virtualProperty.key)) continue;
                    string4 = "_INVALID_NAME";
                    break;
                }
            }
            string2 = "LOGIN_PROPERTY_EDITOR";
            if (string4 != null) {
                string2 = string2 + string4;
            }
            if (string3 != null) {
                string2 = string2 + string3;
            }
            if (string4 == null && string3 == null) {
                this.clearErrorMessage();
                this.getOKAction().setEnabled(true);
            } else {
                this.setErrorMessage(this.resourceRepository().getString(string2));
                this.getOKAction().setEnabled(false);
            }
        }
    }

    private static class PropertyColumnAdapter
    implements ColumnAdapter {
        public static final int COLUMN_COUNT = 3;
        public static final int NAME_COLUMN = 1;
        public static final int SELECTION_COLUMN = 0;
        public static final int VALUE_COLUMN = 2;

        private PropertyColumnAdapter() {
        }

        private PropertyValueModel buildNameAdapter(final MWProperty mWProperty) {
            return new PropertyAspectAdapter("key", (Model)mWProperty){

                protected Object getValueFromSubject() {
                    return mWProperty.getKey();
                }
            };
        }

        private PropertyValueModel buildValueAdapter(final MWProperty mWProperty) {
            return new PropertyAspectAdapter("value", (Model)mWProperty){

                protected Object getValueFromSubject() {
                    return mWProperty.getValue();
                }
            };
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWProperty mWProperty = (MWProperty)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{new SimplePropertyValueModel(), this.buildNameAdapter(mWProperty), this.buildValueAdapter(mWProperty)};
            return propertyValueModelArray;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return null;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (PropertyPane.this.table.isEnabled()) {
                PropertyPane.this.scrollPane.getViewport().setBackground(PropertyPane.this.table.getBackground());
            } else {
                PropertyPane.this.scrollPane.getViewport().setBackground(UIManager.getColor("control"));
            }
        }
    }
}

