/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;

class AddQueryDialog
extends AbstractDialog
implements CaretListener,
ActionListener {
    private boolean supportsReportQuery;
    private ButtonGroup typeButtonGroup;
    private JTextField nameTextField;
    private JRadioButton readObjectQueryRadioButton;
    private JRadioButton readAllQueryRadioButton;
    private JRadioButton reportQueryRadioButton;

    protected AddQueryDialog(WorkbenchContext workbenchContext, boolean bl) {
        super(workbenchContext);
        this.supportsReportQuery = bl;
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.buildQueryTypePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.helpManager().addTopicID(jPanel2, this.helpTopicId() + ".type");
        JPanel jPanel3 = this.buildNamePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.helpManager().addTopicID(jPanel3, this.helpTopicId() + ".name");
        this.getOKAction().setEnabled(false);
        return jPanel;
    }

    protected JPanel buildQueryTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("TYPE_BORDER_LABEL_ON_ADD_QUERY_DIALOG")));
        this.typeButtonGroup = new ButtonGroup();
        this.readObjectQueryRadioButton = new JRadioButton(this.resourceRepository().getString("READ_OBJECT_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
        this.readObjectQueryRadioButton.setSelected(true);
        this.readObjectQueryRadioButton.addActionListener(this);
        this.readObjectQueryRadioButton.setActionCommand("READ_OBJECT_QUERY");
        this.typeButtonGroup.add(this.readObjectQueryRadioButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.readObjectQueryRadioButton, gridBagConstraints);
        this.readAllQueryRadioButton = new JRadioButton(this.resourceRepository().getString("READ_ALL_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
        this.readAllQueryRadioButton.addActionListener(this);
        this.readAllQueryRadioButton.setActionCommand("READ_ALL_QUERY");
        this.typeButtonGroup.add(this.readAllQueryRadioButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.readAllQueryRadioButton, gridBagConstraints);
        if (this.supportsReportQuery()) {
            this.reportQueryRadioButton = new JRadioButton(this.resourceRepository().getString("REPORT_RADIOBUTTON_ON_ADD_QUERY_DIALOG"));
            this.reportQueryRadioButton.addActionListener(this);
            this.reportQueryRadioButton.setActionCommand("REPORT_QUERY");
            this.typeButtonGroup.add(this.reportQueryRadioButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel.add((Component)this.reportQueryRadioButton, gridBagConstraints);
        }
        return jPanel;
    }

    protected void enableQueryTypePanel(boolean bl) {
        this.readAllQueryRadioButton.setEnabled(bl);
        this.readObjectQueryRadioButton.setEnabled(bl);
        if (this.supportsReportQuery()) {
            this.reportQueryRadioButton.setEnabled(bl);
        }
    }

    protected JPanel buildNamePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.resourceRepository().getString("NAME_TEXT_FIELD_LABEL_ON_ADD_QUERY_DIALOG"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField();
        this.nameTextField.setDocument(new RegexpDocument(5));
        this.nameTextField.addCaretListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getNameTextField().requestFocus();
        this.validateQuery();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.validateQuery();
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.namedQueries";
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("ADD_QUERY_DIALOG.title"));
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }

    protected JTextField getNameTextField() {
        return this.nameTextField;
    }

    protected void setQueryType(String string) {
        if (string == "READ_OBJECT_QUERY") {
            this.readObjectQueryRadioButton.setSelected(true);
        } else if (string == "READ_ALL_QUERY") {
            this.readAllQueryRadioButton.setSelected(true);
        } else {
            this.reportQueryRadioButton.setSelected(true);
        }
    }

    protected void validateQuery() {
        String string = this.getQueryName();
        boolean bl = string != null;
        this.getOKAction().setEnabled(bl &= !string.equals(""));
    }

    private boolean supportsReportQuery() {
        return this.supportsReportQuery;
    }

    public String getQueryName() {
        return this.nameTextField.getText();
    }

    public String getQueryType() {
        return this.typeButtonGroup.getSelection().getActionCommand();
    }
}

