/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.AddQueryDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryQuickViewItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QuickViewPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class QueriesPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel queryManagerHolder;
    private PropertyValueModel queryHolder;
    private CollectionValueModel queriesHolder;

    protected QueriesPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.queryManagerHolder = this.buildQueryManagerHolder();
        this.queryHolder = new SimplePropertyValueModel();
        this.queriesHolder = this.buildQueriesHolder();
    }

    protected abstract PropertyValueModel buildQueryManagerHolder();

    protected ListCellRenderer buildQueriesListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return ((MWQuery)object).signature();
            }
        };
    }

    private ListValueModel buildItemListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSortedQueryListValueModelAdapter(), "signature");
    }

    private ListValueModel buildSortedQueryListValueModelAdapter() {
        return new SortedListValueModelAdapter(this.buildItemNameListValueModelAdapter());
    }

    private ListValueModel buildItemNameListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.queriesHolder, "name");
    }

    private CollectionValueModel buildQueriesHolder() {
        return new CollectionAspectAdapter(this.queryManagerHolder, "queries"){

            protected Iterator getValueFromSubject() {
                return ((MWQueryManager)this.subject).queries();
            }

            protected int sizeFromSubject() {
                return ((MWQueryManager)this.subject).queriesSize();
            }
        };
    }

    protected ListSelectionListener buildQueryListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ObjectListSelectionModel objectListSelectionModel = (ObjectListSelectionModel)listSelectionEvent.getSource();
                    Object[] objectArray = objectListSelectionModel.getSelectedValues();
                    if (objectArray.length == 1) {
                        QueriesPropertiesPage.this.queryHolder.setValue(objectArray[0]);
                    } else {
                        QueriesPropertiesPage.this.queryHolder.setValue(null);
                    }
                }
            }
        };
    }

    protected AddRemoveListPanel buildQueriesListPanel() {
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAddRemoveListPanelAdapter(), this.buildItemListValueModelAdapter(), this.resourceRepository().getString("NAMED_QUERIES_LIST"));
        addRemoveListPanel.setCellRenderer(this.buildQueriesListCellRenderer());
        addRemoveListPanel.addListSelectionListener(this.buildQueryListSelectionListener());
        return addRemoveListPanel;
    }

    protected AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                QueriesPropertiesPage.this.promptToAddQuery(objectListSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                QueriesPropertiesPage.this.removeSelectedQueries(objectListSelectionModel);
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                QueriesPropertiesPage.this.promptToRenameQuery(objectListSelectionModel);
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    protected void promptToAddQuery(ObjectListSelectionModel objectListSelectionModel) {
        MWMappingDescriptor mWMappingDescriptor = this.getQueryManager().getOwningDescriptor();
        AddQueryDialog addQueryDialog = new AddQueryDialog(this.getWorkbenchContext(), mWMappingDescriptor.getTransactionalPolicy().getQueryManager().supportsReportQueries());
        addQueryDialog.show();
        if (addQueryDialog.wasConfirmed()) {
            String string = addQueryDialog.getQueryType();
            String string2 = addQueryDialog.getQueryName();
            Object object = string == "READ_OBJECT_QUERY" ? this.getQueryManager().addReadObjectQuery(string2) : (string == "READ_ALL_QUERY" ? this.getQueryManager().addReadAllQuery(string2) : ((MWRelationalQueryManager)this.getQueryManager()).addReportQuery(string2));
            objectListSelectionModel.setSelectedValue(object);
        }
    }

    protected void removeSelectedQueries(ObjectListSelectionModel objectListSelectionModel) {
        Iterator iterator = CollectionTools.iterator((Object[])objectListSelectionModel.getSelectedValues());
        while (iterator.hasNext()) {
            this.getQueryManager().removeQuery((MWQuery)iterator.next());
        }
    }

    public void promptToRenameQuery(ObjectListSelectionModel objectListSelectionModel) {
        final MWQuery mWQuery = (MWQuery)objectListSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder(){

            public String getTitle() {
                return QueriesPropertiesPage.this.resourceRepository().getString("RENAME_QUERY_DIALOG.title");
            }

            public String getTextFieldDescription() {
                return QueriesPropertiesPage.this.resourceRepository().getString("RENAME_QUERY_DIALOG.message");
            }

            public String getOriginalName() {
                return mWQuery.getName();
            }

            public String getHelpTopicId() {
                return "descriptor.queryManager.namedQueries";
            }

            protected NewNameDialog.DocumentFactory buildDefaultDocumentFactory() {
                return new NewNameDialog.DocumentFactory(){

                    public Document buildDocument() {
                        return new RegexpDocument(5);
                    }
                };
            }
        };
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasConfirmed()) {
            mWQuery.setName(newNameDialog.getNewName());
            objectListSelectionModel.setSelectedValue(mWQuery);
        }
    }

    protected final MWQueryManager getQueryManager() {
        return (MWQueryManager)this.getQueryManagerHolder().getValue();
    }

    protected String helpTopicId() {
        return "descriptor.queries";
    }

    protected PropertyValueModel getQueryManagerHolder() {
        return this.queryManagerHolder;
    }

    protected PropertyValueModel getQueryHolder() {
        return this.queryHolder;
    }

    protected QuickViewPanel.QuickViewItem buildQueryParameterQuickViewItem(MWQueryItem mWQueryItem) {
        return new QueryQuickViewItem(mWQueryItem){

            public void select() {
                QueriesPropertiesPage.this.selectGeneralPanel();
                QueriesPropertiesPage.this.getQueryGeneralPanel().selectParameter((MWQueryParameter)this.getValue());
            }

            public String displayString() {
                MWQueryParameter mWQueryParameter = (MWQueryParameter)this.getValue();
                return QueriesPropertiesPage.this.resourceRepository().getString("QUICK_VIEW_PARAMETER_LABEL", mWQueryParameter.getName(), ClassTools.shortNameForClassNamed((String)mWQueryParameter.getType().getName()));
            }
        };
    }

    protected abstract QueryGeneralPanel getQueryGeneralPanel();

    protected abstract JTabbedPane getQueryTabbedPane();

    protected void selectGeneralPanel() {
        this.getQueryTabbedPane().setSelectedComponent(this.getQueryGeneralPanel());
    }

    protected JComponent buildEmptyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.setFocusable(false);
        jTabbedPane.setRequestFocusEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jTabbedPane, gridBagConstraints);
        return jPanel;
    }

    protected final Document buildQueryVarietyDocumentAdapter() {
        return new DocumentAdapter(this.buildVarietyTypeHolder());
    }

    private PropertyValueModel buildVarietyTypeHolder() {
        return new TransformationPropertyValueModel(this.getQueryHolder()){

            protected Object transform(Object object) {
                MWQuery mWQuery = (MWQuery)object;
                if (mWQuery == null || QueriesPropertiesPage.this.getQueryManager() == null) {
                    return QueriesPropertiesPage.this.resourceRepository().getString("QUERY_VARIETY_NONE_SELECTED");
                }
                return QueriesPropertiesPage.this.resourceRepository().getString("QUERY_VARIETY_TOPLINK_NAMED_QUERY");
            }
        };
    }
}

