/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class QuickViewPanel
extends AbstractSubjectPanel {
    private QuickViewModel quickViewModel;

    protected QuickViewPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void initialize(ValueModel valueModel) {
        super.initialize(valueModel);
        this.quickViewModel = new QuickViewModel();
        this.getSubjectHolder().addPropertyChangeListener("value", this.buildSubjectHolderListener());
        this.quickViewModel.setParentNode((Node)((AbstractNodeModel)this.subject()));
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel("QUICK_VIEW_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        JList jList = SwingComponentFactory.buildList(this.buildQuickViewListAdapter());
        jList.setCellRenderer(new QuickViewRenderer());
        jList.addListSelectionListener(this.buildListSelectionListener());
        jList.addFocusListener(this.buildListFocusListener());
        jList.addMouseListener(this.buildMouseListener());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.getViewport().setPreferredSize(new Dimension(0, 0));
        this.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JButton jButton = this.buildButton("QUICK_VIEW_REMOVE_BUTTON");
        jButton.putClientProperty("list", jList);
        jButton.addActionListener(this.buildRemoveActionListener());
        jButton.setEnabled(false);
        jPanel.add(jButton);
        jList.putClientProperty("remove", jButton);
    }

    private MouseListener buildMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                JList jList = (JList)mouseEvent.getComponent();
                Rectangle rectangle = jList.getCellBounds(n = jList.locationToIndex(mouseEvent.getPoint()), n);
                if (rectangle != null && rectangle.width > 0 && rectangle.height > 0) {
                    ((QuickViewItem)jList.getModel().getElementAt(n)).select();
                }
            }
        };
    }

    private FocusListener buildListFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ((JList)focusEvent.getSource()).repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                ((JList)focusEvent.getSource()).repaint();
            }
        };
    }

    private ListSelectionListener buildListSelectionListener() {
        return new ListSelectionListener(){

            private void updateRemoveButtonEnablement(JButton jButton, Object[] objectArray) {
                boolean bl;
                boolean bl2 = bl = objectArray.length > 0;
                if (bl) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        QuickViewItem quickViewItem = (QuickViewItem)objectArray[i];
                        bl &= quickViewItem.isRemovable();
                    }
                }
                jButton.setEnabled(bl);
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JList jList = (JList)listSelectionEvent.getSource();
                Object[] objectArray = jList.getSelectedValues();
                JButton jButton = (JButton)jList.getClientProperty("remove");
                this.updateRemoveButtonEnablement(jButton, objectArray);
            }
        };
    }

    private ListModel buildQuickViewListAdapter() {
        return new ListModelAdapter(this.buildQuickViewListValueModel());
    }

    private ListValueModel buildQuickViewListValueModel() {
        return new ListAspectAdapter("items", (Model)this.quickViewModel){

            protected ListIterator getValueFromSubject() {
                return ((QuickViewModel)((Object)this.subject)).items();
            }

            protected int sizeFromSubject() {
                return ((QuickViewModel)((Object)this.subject)).itemsSize();
            }
        };
    }

    private ActionListener buildRemoveActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                JList jList = (JList)jButton.getClientProperty("list");
                Object[] objectArray = jList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((QuickViewItem)objectArray[i]).remove();
                }
            }
        };
    }

    protected abstract QuickViewSectionFactory buildSectionFactory(Node var1);

    private PropertyChangeListener buildSubjectHolderListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                QuickViewPanel.this.quickViewModel.setParentNode((Node)QuickViewPanel.this.subject());
            }
        };
    }

    private class QuickViewSectionRenderer
    implements ListCellRenderer {
        private QuickViewSectionRenderer() {
        }

        private Color getBackground(JList jList, boolean bl, boolean bl2) {
            if (bl) {
                if (bl2) {
                    return jList.getSelectionBackground();
                }
                return UIManager.getColor("Panel.background");
            }
            return jList.getBackground();
        }

        private Border getBorder(JList jList, int n, boolean bl, boolean bl2) {
            Border border = bl ? (bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Panel.background").darker()), BorderFactory.createMatteBorder(1, 1, 0, 1, UIManager.getColor("Panel.background")))) : BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Panel.background")), BorderFactory.createEmptyBorder(1, 1, 0, 1));
            return this.updateBorder(border, n);
        }

        private Color getForeground(JList jList, boolean bl, boolean bl2) {
            if (bl) {
                if (bl2) {
                    return jList.getSelectionForeground();
                }
                return UIManager.getColor("Panel.foreground");
            }
            return jList.getForeground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = new JLabel();
            this.updateUI(jLabel, (QuickViewSection)object, jList, n, bl, bl2);
            return jLabel;
        }

        private Border updateBorder(Border border, int n) {
            if (n > 0) {
                return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, UIManager.getColor("List.background")), border);
            }
            return border;
        }

        private void updateUI(JLabel jLabel, QuickViewSection quickViewSection, JList jList, int n, boolean bl, boolean bl2) {
            Color color = this.getBackground(jList, bl, bl2);
            Color color2 = this.getForeground(jList, bl, bl2);
            Border border = this.getBorder(jList, n, bl, bl2);
            jLabel.setOpaque(true);
            jLabel.setBackground(color);
            jLabel.setBorder(border);
            jLabel.setComponentOrientation(jList.getComponentOrientation());
            jLabel.setEnabled(jList.isEnabled());
            jLabel.setForeground(color2);
            jLabel.setIcon(quickViewSection.icon());
            jLabel.setText(quickViewSection.displayString());
            jLabel.getAccessibleContext().setAccessibleName(quickViewSection.accessibleName());
            Font font = jList.getFont();
            jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
    }

    private class QuickViewRenderer
    implements ListCellRenderer {
        private ListCellRenderer[] cachedRenderers;
        private static final int ITEM_RENDERER = 0;
        private static final int SECTION_RENDERER = 1;

        QuickViewRenderer() {
            this.initialize();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ListCellRenderer listCellRenderer = this.retrieveCellRenderer(object);
            return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        }

        private void initialize() {
            this.cachedRenderers = new ListCellRenderer[3];
            this.cachedRenderers[0] = new QuickViewItemRenderer();
            this.cachedRenderers[1] = new QuickViewSectionRenderer();
        }

        private ListCellRenderer retrieveCellRenderer(Object object) {
            if (object instanceof QuickViewSection) {
                return this.cachedRenderers[1];
            }
            return this.cachedRenderers[0];
        }
    }

    private class QuickViewModel
    extends AbstractNodeModel {
        public List items;
        private List sectionSynchronizers;
        public static final String ITEMS_LIST = "items";

        private QuickViewModel() {
        }

        protected final void checkParent(Node node) {
        }

        private void disengageListeners() {
            for (SectionSynchronizer sectionSynchronizer : this.sectionSynchronizers) {
                sectionSynchronizer.disengageListeners();
            }
        }

        public final String displayString() {
            return null;
        }

        protected void initialize() {
            super.initialize();
            this.items = new Vector();
            this.sectionSynchronizers = new Vector();
        }

        public ListIterator items() {
            return this.items.listIterator();
        }

        public int itemsSize() {
            return this.items.size();
        }

        public final void setParentNode(Node node) {
            if (this.getParent() != null) {
                this.disengageListeners();
                this.removeItemsFromList(0, this.items.size(), this.items, ITEMS_LIST);
                this.sectionSynchronizers.clear();
                this.items.clear();
            }
            super.setParent(node);
            if (node != null) {
                this.updateItems();
            }
        }

        private void updateItems() {
            QuickViewSection[] quickViewSectionArray = QuickViewPanel.this.buildSectionFactory(this.getParent()).buildSections();
            for (int i = 0; i < quickViewSectionArray.length; ++i) {
                QuickViewSection quickViewSection = quickViewSectionArray[i];
                this.items.add(quickViewSection);
                SectionSynchronizer sectionSynchronizer = new SectionSynchronizer(quickViewSection, this.items.size());
                this.sectionSynchronizers.add(sectionSynchronizer);
                CollectionTools.addAll((Collection)this.items, (Iterator)sectionSynchronizer.items());
            }
            this.fireItemsAdded(ITEMS_LIST, 0, this.items);
        }

        private class SectionSynchronizer {
            private int index;
            private ListValueModel itemsHolder;
            private ListChangeListener listener;

            SectionSynchronizer(QuickViewSection quickViewSection, int n) {
                this.initialize(quickViewSection, n);
            }

            public void disengageListeners() {
                this.itemsHolder.removeListChangeListener("value", this.listener);
            }

            private void initialize(QuickViewSection quickViewSection, int n) {
                this.index = n;
                this.listener = new ListChangeHandler();
                this.itemsHolder = quickViewSection.buildItemsHolder();
                this.itemsHolder.addListChangeListener("value", this.listener);
            }

            Iterator items() {
                return (Iterator)this.itemsHolder.getValue();
            }

            int itemsSize() {
                return this.itemsHolder.size();
            }

            private void updateSectionsIndex(SectionSynchronizer sectionSynchronizer) {
                for (int i = 1 + QuickViewModel.this.sectionSynchronizers.indexOf(sectionSynchronizer); i < QuickViewModel.this.sectionSynchronizers.size(); ++i) {
                    SectionSynchronizer sectionSynchronizer2 = (SectionSynchronizer)QuickViewModel.this.sectionSynchronizers.get(i);
                    sectionSynchronizer2.index = sectionSynchronizer.itemsSize() + sectionSynchronizer.index + 1;
                    sectionSynchronizer = sectionSynchronizer2;
                }
            }

            private class ListChangeHandler
            implements ListChangeListener {
                private ListChangeHandler() {
                }

                public void itemsAdded(ListChangeEvent listChangeEvent) {
                    QuickViewModel.this.addItemsToList(SectionSynchronizer.this.index + listChangeEvent.getIndex(), CollectionTools.list((Iterator)listChangeEvent.items()), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                    SectionSynchronizer.this.updateSectionsIndex(SectionSynchronizer.this);
                }

                public void itemsRemoved(ListChangeEvent listChangeEvent) {
                    int n = SectionSynchronizer.this.itemsHolder.size();
                    QuickViewModel.this.removeItemsFromList(SectionSynchronizer.this.index + listChangeEvent.getIndex(), listChangeEvent.size(), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                    SectionSynchronizer.this.updateSectionsIndex(SectionSynchronizer.this);
                }

                public void itemsReplaced(ListChangeEvent listChangeEvent) {
                    QuickViewModel.this.removeItemsFromList(SectionSynchronizer.this.index + listChangeEvent.getIndex(), listChangeEvent.size(), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                    QuickViewModel.this.addItemsToList(SectionSynchronizer.this.index + listChangeEvent.getIndex(), CollectionTools.list((Iterator)listChangeEvent.items()), QuickViewModel.this.items, QuickViewModel.ITEMS_LIST);
                }

                public void listChanged(ListChangeEvent listChangeEvent) {
                }
            }
        }
    }

    private class QuickViewItemRenderer
    extends SimpleListCellRenderer {
        private QuickViewItemRenderer() {
        }

        public String buildAccessibleName(Object object) {
            return ((QuickViewItem)object).accessibleName();
        }

        protected Icon buildIcon(Object object) {
            return ((QuickViewItem)object).icon();
        }

        protected String buildText(Object object) {
            return ((QuickViewItem)object).displayString();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            QuickViewItemRenderer quickViewItemRenderer = new QuickViewItemRenderer();
            quickViewItemRenderer.getListCellRendererComponentInternal(jList, object, n, bl, bl2);
            quickViewItemRenderer.updateBackground(jList, bl);
            quickViewItemRenderer.updateBorder();
            return quickViewItemRenderer;
        }

        private Component getListCellRendererComponentInternal(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }

        private void updateBackground(JList jList, boolean bl) {
            if (bl) {
                if (jList.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setBackground(UIManager.getColor("Panel.background"));
                }
            } else {
                this.setBackground(jList.getBackground());
            }
        }

        private void updateBorder() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, UIManager.getColor("List.background")), this.getBorder()));
        }
    }

    protected static interface QuickViewSectionFactory {
        public QuickViewSection[] buildSections();
    }

    protected static interface QuickViewSection
    extends QuickViewItem {
        public ListValueModel buildItemsHolder();
    }

    public static interface QuickViewItem {
        public void select();

        public Object getValue();

        public boolean isRemovable();

        public void remove();

        public String displayString();

        public Icon icon();

        public String accessibleName();
    }
}

