/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class AddArgumentDialog
extends NewNameDialog {
    private PropertyValueModel argumentTypeHolder;
    private PropertyValueModel passTypeHolder;

    protected AddArgumentDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
        super(workbenchContext, builder);
    }

    protected AddArgumentBuilder builder() {
        return (AddArgumentBuilder)super.builder();
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("ADD_ARGUMENT_DIALOG_DESCRIPTION"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JComponent jComponent = this.buildNewNameWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        Component component = this.buildCustomPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(component, gridBagConstraints);
        return jPanel;
    }

    protected JComponent buildNewNameWidgets() {
        Document document = this.buildDocumentWithStateObject();
        document.addDocumentListener(this.buildDocumentListener());
        this.textField = new JTextField(20);
        JComponent jComponent = this.buildLabeledTextField("ENTER_NEW_ARGUMENT_NAME", document, this.textField);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        new ComponentEnabler((ValueModel)this.buildIsNamedHolder(), jComponent);
        return jComponent;
    }

    protected Component buildCustomPane() {
        Pane pane = new Pane(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        pane.add((Component)this.buildArgumentTypePane(), "First");
        pane.add((Component)this.buildPassTypePane(), "Last");
        return pane;
    }

    private PropertyValueModel buildArgumentTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "argumentType"){

            protected Object getValueFromSubject() {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                return argumentStateObject.getArgumentType();
            }

            protected void setValueOnSubject(Object object) {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                argumentStateObject.setArgumentType((ArgumentType)((Object)object));
                if (argumentStateObject.isNamed()) {
                    AddArgumentDialog.this.getOKAction().setEnabled(AddArgumentDialog.this.getNameInternal().length() > 0);
                } else {
                    AddArgumentDialog.this.clearErrorMessage();
                }
            }
        };
    }

    private PropertyValueModel buildPassTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "argumentPassType"){

            protected Object getValueFromSubject() {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                return argumentStateObject.getArgumentPassType();
            }

            protected void setValueOnSubject(Object object) {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                argumentStateObject.setArgumentPassType((ArgumentPassType)((Object)object));
            }
        };
    }

    private PropertyValueModel buildSupportsValueHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "supportsValue"){

            protected Object getValueFromSubject() {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                return new Boolean(argumentStateObject.supportsValue());
            }

            protected void setValueOnSubject(Object object) {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                argumentStateObject.setSupportsValue((Boolean)object);
            }
        };
    }

    private PropertyValueModel buildIsNamedHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "isNamed"){

            protected Object getValueFromSubject() {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                return new Boolean(argumentStateObject.isNamed());
            }

            protected void setValueOnSubject(Object object) {
                ArgumentStateObject argumentStateObject = (ArgumentStateObject)((Object)this.subject);
                argumentStateObject.setIsNamed((Boolean)object);
            }
        };
    }

    protected ArgumentStateObject buildStateObject() {
        return new ArgumentStateObject(this.builder());
    }

    ArgumentType getArgumentType() {
        return ((ArgumentStateObject)this.subject()).getArgumentType();
    }

    ArgumentPassType getArgumentPassType() {
        return ((ArgumentStateObject)this.subject()).getArgumentPassType();
    }

    boolean isOutType() {
        return ((ArgumentStateObject)this.subject()).supportsValue();
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.procedures.arguments";
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("ADD_ARGUMENT_DIALOG_TITLE"));
        this.getOKAction().setEnabled(false);
    }

    protected final JComponent buildArgumentTypePane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>(6);
        this.argumentTypeHolder = this.buildArgumentTypeHolder();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.buildTitledBorder("TYPE_BORDER_LABEL_ON_ADD_ARGUMENT_DIALOG"));
        JRadioButton jRadioButton = this.buildRadioButton("NAMED_IN_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildNamedInArgumentRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        arrayList.add(jRadioButton);
        JRadioButton jRadioButton2 = this.buildRadioButton("NAMED_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildNamedOutArgumentRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        arrayList.add(jRadioButton2);
        JRadioButton jRadioButton3 = this.buildRadioButton("NAMED_IN_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildNamedInOutArgumentRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        arrayList.add(jRadioButton3);
        JRadioButton jRadioButton4 = this.buildRadioButton("UNNAMED_IN_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildUnNamedInArgumentRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton4, gridBagConstraints);
        arrayList.add(jRadioButton4);
        JRadioButton jRadioButton5 = this.buildRadioButton("UNNAMED_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildUnNamedOutArgumentRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton5, gridBagConstraints);
        arrayList.add(jRadioButton5);
        JRadioButton jRadioButton6 = this.buildRadioButton("UNNAMED_IN_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildUnNamedInOutArgumentRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton6, gridBagConstraints);
        arrayList.add(jRadioButton6);
        this.helpManager().addTopicID(jPanel, this.helpTopicId() + ".type");
        return jPanel;
    }

    private ButtonModel buildNamedInArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.NAMED_IN);
    }

    private ButtonModel buildNamedInOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.NAMED_IN_OUT);
    }

    private ButtonModel buildNamedOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.NAMED_OUT);
    }

    private ButtonModel buildUnNamedInArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.UNNAMED_IN);
    }

    private ButtonModel buildUnNamedInOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.UNNAMED_IN_OUT);
    }

    private ButtonModel buildUnNamedOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.UNNAMED_OUT);
    }

    protected final JComponent buildPassTypePane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JRadioButton> arrayList = new ArrayList<JRadioButton>(2);
        this.passTypeHolder = this.buildPassTypeHolder();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.buildTitledBorder("PASS_TYPE_BORDER_LABEL_ON_ADD_ARGUMENT_DIALOG"));
        JRadioButton jRadioButton = this.buildRadioButton("PARAMETER_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildParameterPassTypeRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        arrayList.add(jRadioButton);
        JRadioButton jRadioButton2 = this.buildRadioButton("VALUE_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildValuePassTypeRadioButtonModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        arrayList.add(jRadioButton2);
        new ComponentEnabler((ValueModel)this.buildSupportsValueHolder(), arrayList);
        this.helpManager().addTopicID(jPanel, this.helpTopicId() + ".passType");
        return jPanel;
    }

    private ButtonModel buildParameterPassTypeRadioButtonModel() {
        return new RadioButtonModelAdapter(this.passTypeHolder, (Object)ArgumentPassType.PARAMETER);
    }

    private ButtonModel buildValuePassTypeRadioButtonModel() {
        return new RadioButtonModelAdapter(this.passTypeHolder, (Object)ArgumentPassType.VALUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ArgumentPassType {
        PARAMETER,
        VALUE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ArgumentType {
        NAMED_IN,
        NAMED_OUT,
        NAMED_IN_OUT,
        UNNAMED_IN,
        UNNAMED_OUT,
        UNNAMED_IN_OUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArgumentStateObject
    extends NewNameDialog.StateObject {
        private ArgumentType argumentType;
        public static final String ARGUMENT_TYPE_PROPERTY = "argumentType";
        private ArgumentPassType argumentPassType;
        public static final String ARGUMENT_PASS_TYPE_PROPERTY = "argumentPassType";
        private boolean supportsValue;
        public static final String SUPPORTS_VALUE = "supportsValue";
        private boolean isNamed;
        public static final String IS_NAMED = "isNamed";

        ArgumentStateObject(NewNameDialog.Builder builder) {
            super(builder);
            this.argumentType = ArgumentType.NAMED_IN;
            this.argumentPassType = ArgumentPassType.PARAMETER;
            this.supportsValue = true;
            this.isNamed = true;
        }

        @Override
        protected void editName(List<Problem> list) {
            String string = this.getName();
            if (this.getArgumentType() != ArgumentType.UNNAMED_IN && this.getArgumentType() != ArgumentType.UNNAMED_IN_OUT && this.getArgumentType() != ArgumentType.UNNAMED_OUT && StringTools.stringIsEmpty((String)string)) {
                list.add(this.buildProblem("NEW_NAME_DIALOG.EMPTY_VALUE"));
                return;
            }
            AddArgumentDialog.this.clearErrorMessage();
        }

        public ArgumentType getArgumentType() {
            return this.argumentType;
        }

        public void setArgumentType(ArgumentType argumentType) {
            ArgumentType argumentType2 = this.argumentType;
            this.argumentType = argumentType;
            this.firePropertyChanged(ARGUMENT_TYPE_PROPERTY, (Object)argumentType2, (Object)argumentType);
            if (this.argumentType == ArgumentType.NAMED_IN || this.argumentType == ArgumentType.NAMED_IN_OUT || this.argumentType == ArgumentType.UNNAMED_IN || this.argumentType == ArgumentType.UNNAMED_IN_OUT) {
                this.setSupportsValue(true);
            } else {
                this.setSupportsValue(false);
            }
            if (this.argumentType == ArgumentType.NAMED_IN || this.argumentType == ArgumentType.NAMED_IN_OUT || this.argumentType == ArgumentType.NAMED_OUT) {
                this.setIsNamed(true);
            } else {
                this.setIsNamed(false);
            }
        }

        public ArgumentPassType getArgumentPassType() {
            return this.argumentPassType;
        }

        public void setArgumentPassType(ArgumentPassType argumentPassType) {
            ArgumentPassType argumentPassType2 = this.argumentPassType;
            this.argumentPassType = argumentPassType;
            this.firePropertyChanged(ARGUMENT_PASS_TYPE_PROPERTY, (Object)argumentPassType2, (Object)argumentPassType);
        }

        public boolean supportsValue() {
            return this.supportsValue;
        }

        public void setSupportsValue(boolean bl) {
            boolean bl2 = this.supportsValue;
            this.supportsValue = bl;
            this.firePropertyChanged(SUPPORTS_VALUE, bl2, bl);
        }

        public boolean isNamed() {
            return this.isNamed;
        }

        public void setIsNamed(boolean bl) {
            boolean bl2 = this.isNamed;
            this.isNamed = bl;
            this.firePropertyChanged(IS_NAMED, bl2, bl);
        }
    }

    static class AddArgumentBuilder
    extends NewNameDialog.Builder {
        AddArgumentBuilder() {
        }

        public AddArgumentDialog buildDialog(WorkbenchContext workbenchContext) {
            return (AddArgumentDialog)super.buildDialog(workbenchContext);
        }

        protected AddArgumentDialog buildDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
            return new AddArgumentDialog(workbenchContext, builder);
        }
    }
}

