/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentElement;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeModel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

abstract class AttributeItemDialog
extends AbstractDialog {
    private MWQuery query;
    private MWAttributeItem attributeItem;
    private QueryableTree queryableTree;
    private Filter traversableFilter;
    private Filter chooseableFilter;

    AttributeItemDialog(MWQuery mWQuery, MWAttributeItem mWAttributeItem, Filter filter, Filter filter2, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.query = mWQuery;
        this.attributeItem = mWAttributeItem;
        this.traversableFilter = filter;
        this.chooseableFilter = filter2;
        this.getOKAction().setEnabled(false);
    }

    AttributeItemDialog(MWQuery mWQuery, MWAttributeItem mWAttributeItem, WorkbenchContext workbenchContext) {
        this(mWQuery, mWAttributeItem, null, null, workbenchContext);
        this.traversableFilter = this.buildTraversableFilter();
        this.chooseableFilter = this.buildChooseableFilter();
    }

    protected Filter buildTraversableFilter() {
        return Filter.NULL_INSTANCE;
    }

    protected Filter buildChooseableFilter() {
        return Filter.NULL_INSTANCE;
    }

    protected abstract String titleKey();

    protected abstract String editTitleKey();

    private MWMappingDescriptor getDescriptor() {
        return this.query.getOwningDescriptor();
    }

    protected MWQuery getQuery() {
        return this.query;
    }

    protected MWAttributeItem getAttributeItem() {
        return this.attributeItem;
    }

    protected QueryableTree getQueryableTree() {
        return this.queryableTree;
    }

    protected void initializeContentPane() {
        super.initializeContentPane();
        if (this.attributeItem != null) {
            this.initializeEditMode(this.attributeItem);
            this.setTitle(this.resourceRepository().getString(this.editTitleKey()));
        } else {
            this.setTitle(this.resourceRepository().getString(this.titleKey()));
        }
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.buildQueryableTree());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    protected QueryableTree buildQueryableTree() {
        this.queryableTree = new QueryableTree(this.buildQueryableTreeModel(), this.getWorkbenchContext());
        this.queryableTree.addTreeSelectionListener(this.buildTreeSelectionHandler());
        SwingComponentFactory.addDoubleClickMouseListener(this.queryableTree, new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent mouseEvent) {
                TreePath treePath = AttributeItemDialog.this.queryableTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    AttributeItemDialog.this.clickOK();
                }
            }
        });
        return this.queryableTree;
    }

    protected QueryableTreeModel buildQueryableTreeModel() {
        return new QueryableTreeModel(new DefaultMutableTreeNode(this.getDescriptor()), this.traversableFilter);
    }

    protected void initializeEditMode(MWAttributeItem mWAttributeItem) {
        MWQueryableArgumentElement mWQueryableArgumentElement = mWAttributeItem.getQueryableArgument().getQueryableArgumentElement();
        if (mWQueryableArgumentElement.getQueryable() != null && this.chooseableFilter.accept((Object)mWQueryableArgumentElement.getQueryable())) {
            this.queryableTree.setSelectedQueryableArgumentElement(mWAttributeItem.getQueryableArgument().getQueryableArgumentElement());
        }
        this.setTitle(this.resourceRepository().getString(this.titleKey()));
    }

    private TreeSelectionListener buildTreeSelectionHandler() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                AttributeItemDialog.this.treeSelectionChanged(treeSelectionEvent);
            }
        };
    }

    protected void treeSelectionChanged(TreeSelectionEvent treeSelectionEvent) {
        this.updateOKButton();
    }

    protected void updateOKButton() {
        boolean bl;
        boolean bl2 = bl = this.queryableTree.getSelectionCount() > 0;
        if (bl) {
            QueryableTreeNode queryableTreeNode = (QueryableTreeNode)this.queryableTree.getSelectionPath().getLastPathComponent();
            this.getOKAction().setEnabled(this.chooseableFilter.accept((Object)queryableTreeNode.getQueryable()));
        } else {
            this.getOKAction().setEnabled(false);
        }
    }

    protected void cancelPressed() {
        ((DefaultMutableTreeNode)this.queryableTree.getModel().getRoot()).removeAllChildren();
        super.cancelPressed();
    }

    protected boolean preConfirm() {
        TreePath treePath = this.queryableTree.getSelectionPath();
        ArrayList<MWQueryable> arrayList = new ArrayList<MWQueryable>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        QueryableTreeNode queryableTreeNode = (QueryableTreeNode)treePath.getLastPathComponent();
        arrayList2.add(queryableTreeNode.isAllowsNull());
        MWQueryable mWQueryable = queryableTreeNode.getQueryable();
        arrayList.add(mWQueryable);
        treePath = treePath.getParentPath();
        while (treePath.getPathCount() > 1) {
            queryableTreeNode = (QueryableTreeNode)treePath.getLastPathComponent();
            arrayList2.add(new Boolean(queryableTreeNode.isAllowsNull()));
            MWQueryable mWQueryable2 = queryableTreeNode.getQueryable();
            arrayList.add(mWQueryable2);
            treePath = treePath.getParentPath();
        }
        int n = this.attributeItemsSize();
        if (this.attributeItem != null) {
            n = this.indexOfAttributeItem(this.attributeItem);
            this.removeAttributeItem(n);
        }
        this.addAttributeItem(n, arrayList.iterator(), arrayList2.iterator());
        ((DefaultMutableTreeNode)this.queryableTree.getModel().getRoot()).removeAllChildren();
        return super.preConfirm();
    }

    protected abstract int attributeItemsSize();

    protected abstract int indexOfAttributeItem(MWAttributeItem var1);

    protected abstract void removeAttributeItem(int var1);

    protected abstract void addAttributeItem(int var1, Iterator var2, Iterator var3);
}

