/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.FirstArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.SecondArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;

final class BasicExpressionPanel
extends AbstractPanel {
    private PropertyValueModel basicExpressionHolder;
    private PropertyValueModel firstArgumentHolder;
    private PropertyValueModel secondArgumentHolder;
    private FirstArgumentPanel firstArgumentPanel;
    private SecondArgumentPanel secondArgumentPanel;
    private JComboBox operatorComboBox;
    private ValueModel basicExpressionEnablerModel;
    public static final String EQUAL = "EQUAL";
    public static final String EQUALS_IGNORE_CASE = "EQUALS IGNORE CASE";
    public static final String GREATER_THAN = "GREATER THAN";
    public static final String GREATER_THAN_EQUAL = "GREATER THAN EQUAL";
    public static final String LESS_THAN = "LESS THAN";
    public static final String LESS_THAN_EQUAL = "LESS THAN EQUAL";
    public static final String LIKE = "LIKE";
    public static final String LIKE_IGNORE_CASE = "LIKE IGNORE CASE";
    public static final String NOT_EQUAL = "NOT EQUAL";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String IS_NULL = "IS NULL";
    public static final String NOT_NULL = "NOT NULL";

    BasicExpressionPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.initialize(propertyValueModel);
    }

    private void initialize(PropertyValueModel propertyValueModel) {
        this.basicExpressionHolder = this.buildBasicExpressionHolder(propertyValueModel);
        this.firstArgumentHolder = this.buildFirstArgumentHolder();
        this.secondArgumentHolder = this.buildSecondArgumentHolder();
        this.basicExpressionEnablerModel = this.buildBasicExpressionEnablerModel();
        this.initializeLayout();
    }

    private PropertyValueModel buildFirstArgumentHolder() {
        return new PropertyAspectAdapter(this.basicExpressionHolder, "firstArgument"){

            protected Object getValueFromSubject() {
                return ((MWBasicExpression)this.subject).getFirstArgument();
            }
        };
    }

    private PropertyValueModel buildSecondArgumentHolder() {
        return new PropertyAspectAdapter(this.basicExpressionHolder, "secondArgument"){

            protected Object getValueFromSubject() {
                return ((MWBasicExpression)this.subject).getSecondArgument();
            }
        };
    }

    private PropertyValueModel buildBasicExpressionHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWBasicExpression;
            }
        };
    }

    private ValueModel buildBasicExpressionEnablerModel() {
        return new PropertyAspectAdapter(this.basicExpressionHolder){

            protected Object buildValue() {
                if (BasicExpressionPanel.this.basicExpressionHolder.getValue() == null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
    }

    private Iterator allowableOperatorTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(EQUAL);
        arrayList.add(NOT_EQUAL);
        arrayList.add(EQUALS_IGNORE_CASE);
        arrayList.add(GREATER_THAN);
        arrayList.add(GREATER_THAN_EQUAL);
        arrayList.add(LESS_THAN);
        arrayList.add(LESS_THAN_EQUAL);
        arrayList.add(LIKE);
        arrayList.add(NOT_LIKE);
        arrayList.add(LIKE_IGNORE_CASE);
        arrayList.add(IS_NULL);
        arrayList.add(NOT_NULL);
        return arrayList.iterator();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.firstArgumentPanel = new FirstArgumentPanel(this.firstArgumentHolder, this.basicExpressionEnablerModel, this.getWorkbenchContextHolder());
        this.firstArgumentPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("FIRST_ARGUMENT_PANEL_TITLE.title")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.firstArgumentPanel, gridBagConstraints);
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("OPERATOR_LABEL:"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("OPERATOR_LABEL:"));
        arrayList.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.operatorComboBox = this.buildOperatorComboBox();
        arrayList.add(this.operatorComboBox);
        new ComponentEnabler(this.basicExpressionEnablerModel, arrayList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jLabel.setLabelFor(this.operatorComboBox);
        jPanel.add((Component)this.operatorComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jPanel, gridBagConstraints);
        this.secondArgumentPanel = new SecondArgumentPanel(this.secondArgumentHolder, this.basicExpressionHolder, this.getWorkbenchContextHolder());
        this.secondArgumentPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("SECOND_ARGUMENT_PANEL_TITLE.title")));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.secondArgumentPanel, gridBagConstraints);
        Dimension dimension = this.firstArgumentPanel.getPreferredSize();
        Dimension dimension2 = this.secondArgumentPanel.getPreferredSize();
        dimension.width = Math.max(dimension.width, dimension2.height);
        dimension.height = Math.max(dimension.height, dimension2.height) + 8;
        this.firstArgumentPanel.setMinimumSize(dimension);
        this.firstArgumentPanel.setPreferredSize(dimension);
        this.secondArgumentPanel.setMinimumSize(dimension);
        this.secondArgumentPanel.setPreferredSize(dimension);
    }

    private JComboBox buildOperatorComboBox() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setModel(this.buildOperatorComboBoxModel());
        return jComboBox;
    }

    private ComboBoxModel buildOperatorComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildOperatorTypeCollectionHolder(), this.buildOperatorAdapter());
    }

    private CollectionValueModel buildOperatorTypeCollectionHolder() {
        return new AbstractReadOnlyCollectionValueModel(){

            public Object getValue() {
                return BasicExpressionPanel.this.allowableOperatorTypes();
            }
        };
    }

    private PropertyValueModel buildOperatorAdapter() {
        return new PropertyAspectAdapter(this.basicExpressionHolder, "operatorType"){

            protected Object getValueFromSubject() {
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.EQUAL) {
                    return BasicExpressionPanel.EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.NOT_EQUAL) {
                    return BasicExpressionPanel.NOT_EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.EQUALS_IGNORE_CASE) {
                    return BasicExpressionPanel.EQUALS_IGNORE_CASE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.GREATER_THAN) {
                    return BasicExpressionPanel.GREATER_THAN;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.GREATER_THAN_EQUAL) {
                    return BasicExpressionPanel.GREATER_THAN_EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LESS_THAN) {
                    return BasicExpressionPanel.LESS_THAN;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LESS_THAN_EQUAL) {
                    return BasicExpressionPanel.LESS_THAN_EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LIKE) {
                    return BasicExpressionPanel.LIKE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.NOT_LIKE) {
                    return BasicExpressionPanel.NOT_LIKE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LIKE_IGNORE_CASE) {
                    return BasicExpressionPanel.LIKE_IGNORE_CASE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.IS_NULL) {
                    return BasicExpressionPanel.IS_NULL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.NOT_NULL) {
                    return BasicExpressionPanel.NOT_NULL;
                }
                throw new IllegalArgumentException();
            }

            protected void setValueOnSubject(Object object) {
                if (object == BasicExpressionPanel.EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.EQUAL);
                } else if (object == BasicExpressionPanel.NOT_EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.NOT_EQUAL);
                } else if (object == BasicExpressionPanel.EQUALS_IGNORE_CASE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.EQUALS_IGNORE_CASE);
                } else if (object == BasicExpressionPanel.GREATER_THAN) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.GREATER_THAN);
                } else if (object == BasicExpressionPanel.GREATER_THAN_EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.GREATER_THAN_EQUAL);
                } else if (object == BasicExpressionPanel.LESS_THAN) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LESS_THAN);
                } else if (object == BasicExpressionPanel.LESS_THAN_EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LESS_THAN_EQUAL);
                } else if (object == BasicExpressionPanel.LIKE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LIKE);
                } else if (object == BasicExpressionPanel.NOT_LIKE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.NOT_LIKE);
                } else if (object == BasicExpressionPanel.LIKE_IGNORE_CASE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LIKE_IGNORE_CASE);
                } else if (object == BasicExpressionPanel.IS_NULL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.IS_NULL);
                } else if (object == BasicExpressionPanel.NOT_NULL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.NOT_NULL);
                }
            }
        };
    }
}

