/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWEJBQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStringQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CustomStoredProcedureQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.StringQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public final class CustomQuerySelectionCriteriaPanel
extends AbstractPanel {
    private QueryFormatPanel queryFormatPanel;
    private Map<Class<? extends MWQueryFormat>, JComponent> queryFormatPanelMap;
    private PropertyValueModel queryHolder;

    public CustomQuerySelectionCriteriaPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.addHelpTopicId(this, this.helpTopicId());
        this.queryHolder = propertyValueModel;
        this.initializeLayout();
    }

    private Transformer buildPaneTransformer() {
        return new Transformer(){

            public JComponent transform(Object object) {
                if (object == null) {
                    return null;
                }
                return (JComponent)CustomQuerySelectionCriteriaPanel.this.queryFormatPanelMap.get(object.getClass());
            }
        };
    }

    private PropertyValueModel buildQueryFormatHolder() {
        return new PropertyAspectAdapter(this.buildRelationalOptionsHolder(), "queryFormatType"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getQueryFormat();
            }
        };
    }

    private ValueModel buildRelationalOptionsHolder() {
        return new TransformationValueModel(this.buildRelationalQueryHolder()){

            protected Object transformNonNull(Object object) {
                return ((MWRelationalQuery)object).getRelationalOptions();
            }
        };
    }

    private ValueModel buildRelationalQueryHolder() {
        return new TransformationValueModel(this.queryHolder){

            protected Object transformNonNull(Object object) {
                return object;
            }
        };
    }

    private String helpTopicId() {
        return "descriptor.queries.format";
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.initializeMaps();
        SwitcherPanel switcherPanel = new SwitcherPanel(this.buildQueryFormatHolder(), this.buildPaneTransformer());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)switcherPanel, gridBagConstraints);
    }

    private void initializeMaps() {
        this.queryFormatPanel = new QueryFormatPanel(this.queryHolder, this.buildQueryFormatHolder(), this.getWorkbenchContextHolder());
        this.queryFormatPanelMap = new Hashtable<Class<? extends MWQueryFormat>, JComponent>();
        this.queryFormatPanelMap.put(MWStoredProcedureQueryFormat.class, this.queryFormatPanel);
        this.queryFormatPanelMap.put(MWSQLQueryFormat.class, this.queryFormatPanel);
        this.queryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.queryFormatPanel);
    }

    private boolean promptToChangeSelectionCriteriaType() {
        if (this.preferences().getBoolean("query change query format", false)) {
            return true;
        }
        String string = this.resourceRepository().getString("QUERY_QUERY_FORMAT_TITLE");
        String string2 = this.resourceRepository().getString("QUERY_QUERY_FORMAT_MESSAGE");
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(new Boolean(false));
        JComponent jComponent = SwingComponentFactory.buildDoNotAskAgainPanel(string2, simplePropertyValueModel, this.resourceRepository());
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), jComponent, string, 0, 2);
        if (simplePropertyValueModel.getValue().equals(Boolean.TRUE)) {
            if (n == 0) {
                this.preferences().putBoolean("query change query format", true);
            } else if (n == 1) {
                this.preferences().putBoolean("query change query format", false);
            }
        }
        return n == 0;
    }

    private boolean queryFormatCanChange() {
        boolean bl;
        String string = TriStateBoolean.UNDEFINED.toString();
        String string2 = this.preferences().get("query change query format", "undefined");
        if (string2.equals(string)) {
            bl = this.promptToChangeSelectionCriteriaType();
        } else {
            bl = TriStateBoolean.TRUE.toString().equals(string2);
            if (!bl) {
                JOptionPane.showMessageDialog(this.getRootPane(), this.resourceRepository().getString("QUERY_FORMAT_CHANGE_DISSALLOWED"), this.application().getShortProductName(), 1);
            }
        }
        return bl;
    }

    private final class QueryFormatPanel
    extends AbstractQueryFormatPanel {
        private CustomStoredProcedureQueryFormatSubPanel storedProcedurePanel;
        private StringQueryFormatSubPanel stringQueryFormatPanel;
        private Map<Class<? extends MWQueryFormat>, JComponent> subQueryFormatPanelMap;

        public QueryFormatPanel(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, WorkbenchContextHolder workbenchContextHolder) {
            super(propertyValueModel, propertyValueModel2, workbenchContextHolder);
            this.initializeLayout();
        }

        private ValueModel buildStoredProcedureQueryFormatHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object object) {
                    return object instanceof MWStoredProcedureQueryFormat ? (MWStoredProcedureQueryFormat)object : null;
                }
            };
        }

        private Transformer buildPaneTransformer() {
            return new Transformer(){

                public JComponent transform(Object object) {
                    if (object == null) {
                        return null;
                    }
                    return (JComponent)QueryFormatPanel.this.subQueryFormatPanelMap.get(object.getClass());
                }
            };
        }

        private ValueModel buildQueryComponentEnableBooleanHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object object) {
                    return object != null;
                }
            };
        }

        private PropertyValueModel buildQueryFormatTypeHolder() {
            return new PropertyAspectAdapter(CustomQuerySelectionCriteriaPanel.this.buildRelationalOptionsHolder(), "queryFormatType"){

                protected Object getValueFromSubject() {
                    return ((MWRelationalQuery)this.subject).getQueryFormatType();
                }

                protected void setValueOnSubject(Object object) {
                    if (CustomQuerySelectionCriteriaPanel.this.queryFormatCanChange()) {
                        ((MWRelationalQuery)this.subject).setQueryFormatType((String)object);
                    }
                }
            };
        }

        private ListCellRenderer buildSelectionCriteraCellRenderer() {
            return new SimpleListCellRenderer(){

                public String buildText(Object object) {
                    if (object == "storedProcedure") {
                        return QueryFormatPanel.this.resourceRepository().getString("STORED_PROCEDURE_OPTION");
                    }
                    if (object == "sqlFormat") {
                        return QueryFormatPanel.this.resourceRepository().getString("SQL_OPTION");
                    }
                    return QueryFormatPanel.this.resourceRepository().getString("EJBQL_OPTION");
                }
            };
        }

        private ComboBoxModel buildSelectionCriteriaComboModel() {
            return new ComboBoxModelAdapter(this.selectionCriteriaOptionsModel(), this.buildQueryFormatTypeHolder());
        }

        private ValueModel buildStringQueryFormatHolder() {
            return new TransformationValueModel(this.queryFormatHolder){

                protected Object transform(Object object) {
                    return object instanceof MWStringQueryFormat ? (MWStringQueryFormat)object : null;
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.initializeMaps();
            JComponent jComponent = this.buildLabeledComboBox("SELECTION_CRITERIA_TYPE_LABEL", this.buildSelectionCriteriaComboModel(), this.buildSelectionCriteraCellRenderer());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
            new ComponentEnabler(this.buildQueryComponentEnableBooleanHolder(), jComponent);
            SwitcherPanel switcherPanel = new SwitcherPanel(this.queryFormatHolder, this.buildPaneTransformer());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)switcherPanel, gridBagConstraints);
        }

        private void initializeMaps() {
            this.stringQueryFormatPanel = new StringQueryFormatSubPanel(this.buildStringQueryFormatHolder(), this.getWorkbenchContextHolder());
            this.storedProcedurePanel = new CustomStoredProcedureQueryFormatSubPanel(this.buildStoredProcedureQueryFormatHolder(), this.getWorkbenchContextHolder());
            this.subQueryFormatPanelMap = new Hashtable<Class<? extends MWQueryFormat>, JComponent>();
            this.subQueryFormatPanelMap.put(MWStoredProcedureQueryFormat.class, this.storedProcedurePanel);
            this.subQueryFormatPanelMap.put(MWSQLQueryFormat.class, this.stringQueryFormatPanel);
            this.subQueryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.stringQueryFormatPanel);
        }

        private CollectionValueModel selectionCriteriaOptionsModel() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("storedProcedure");
            arrayList.add("sqlFormat");
            arrayList.add("ejbqlFormat");
            return new ReadOnlyCollectionValueModel(arrayList);
        }
    }

    private abstract class AbstractQueryFormatPanel
    extends AbstractPanel {
        protected PropertyValueModel queryHolder;
        protected PropertyValueModel queryFormatHolder;

        protected AbstractQueryFormatPanel(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, WorkbenchContextHolder workbenchContextHolder) {
            super(workbenchContextHolder);
            this.queryFormatHolder = propertyValueModel2;
            this.queryHolder = propertyValueModel;
        }
    }
}

