/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CompoundExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionBuilderDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

final class ExpressionQueryFormatSubPanel
extends AbstractSubjectPanel {
    private DefaultTreeModel expressionTreeModel;
    private TreeSelectionModel treeSelectionModel;
    private PropertyValueModel expressionQueryFormatHolder;

    ExpressionQueryFormatSubPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected ActionListener buildEditExpressionAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionQueryFormatSubPanel.this.editExpresion();
            }
        };
    }

    private PropertyChangeListener buildQueryPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ExpressionQueryFormatSubPanel.this.populateTree();
            }
        };
    }

    protected void initializeLayout() {
        this.expressionQueryFormatHolder = this.buildExpressionQueryFormatHolder();
        this.expressionQueryFormatHolder.addPropertyChangeListener("value", this.buildQueryPropertyChangeListener());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel("EXPRESSION_PANEL_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this.expressionTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("RootNode"), true);
        ExpressionTree expressionTree = new ExpressionTree(this.expressionTreeModel);
        this.treeSelectionModel = expressionTree.getSelectionModel();
        this.treeSelectionModel.setSelectionMode(1);
        jLabel.setLabelFor(expressionTree);
        expressionTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ExpressionQueryFormatSubPanel.this.editExpresion();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(expressionTree);
        jScrollPane.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints);
        JButton jButton = this.buildButton("EDIT_EXPRESSION_BUTTON");
        jButton.addActionListener(this.buildEditExpressionAction());
        new ComponentEnabler(this.buildQueryBooleanHolder(), Collections.singleton(jButton));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
    }

    private MWExpressionQueryFormat getExpressionQueryFormat() {
        return (MWExpressionQueryFormat)this.expressionQueryFormatHolder.getValue();
    }

    private PropertyValueModel buildExpressionQueryFormatHolder() {
        return new FilteringPropertyValueModel((PropertyValueModel)this.getSubjectHolder()){

            protected boolean accept(Object object) {
                return object instanceof MWExpressionQueryFormat;
            }
        };
    }

    private void populateTree() {
        if (this.getExpressionQueryFormat() == null) {
            this.expressionTreeModel.setRoot(new DefaultMutableTreeNode(""));
        } else {
            CompoundExpressionTreeNode compoundExpressionTreeNode = new CompoundExpressionTreeNode(this.getExpressionQueryFormat().getExpression());
            this.expressionTreeModel.setRoot(compoundExpressionTreeNode);
            compoundExpressionTreeNode.setModel(this.expressionTreeModel);
            ((ExpressionTreeNode)compoundExpressionTreeNode).initializeChildren();
        }
    }

    private void editExpresion() {
        int n = this.treeSelectionModel.getLeadSelectionRow();
        ExpressionBuilderDialog expressionBuilderDialog = new ExpressionBuilderDialog(this.getExpressionQueryFormat().getExpression(), n, this.getWorkbenchContext());
        expressionBuilderDialog.show();
        if (expressionBuilderDialog.wasCanceled()) {
            this.getExpressionQueryFormat().getExpression().restoreChanges();
        } else {
            this.getExpressionQueryFormat().getExpression().clearChanges();
        }
        expressionBuilderDialog = null;
        this.populateTree();
    }

    private ValueModel buildQueryBooleanHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            public Object buildValue() {
                return this.subject == null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }
}

