/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAbstractRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class JoinedAttributesPanel
extends AbstractAttributeItemsPanel {
    public JoinedAttributesPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected PropertyValueModel buildQueryHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWAbstractRelationalReadQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "query.joinedAtributes";
    }

    String listTitleKey() {
        return "JOINED_ATTRIBUTES_LIST";
    }

    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            public String optionalButtonKey() {
                return "JOINED_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                JoinedAttributesPanel.this.editSelectedAttribute((MWAttributeItem)((MWJoinedItem)objectListSelectionModel.getSelectedValue()));
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                JoinedAttributesPanel.this.addJoinedAttribute();
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                Object[] objectArray = objectListSelectionModel.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWAbstractRelationalReadQuery)JoinedAttributesPanel.this.getQuery()).removeJoinedItem((MWJoinedItem)objectArray[i]);
                }
            }

            public void moveItemsDown(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWAbstractRelationalReadQuery)JoinedAttributesPanel.this.getQuery()).moveJoinedItemDown((MWJoinedItem)objectArray[i]);
                }
            }

            public void moveItemsUp(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWAbstractRelationalReadQuery)JoinedAttributesPanel.this.getQuery()).moveJoinedItemUp((MWJoinedItem)objectArray[i]);
                }
            }
        };
    }

    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "joinedItems"){

            protected ListIterator getValueFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).joinedItems();
            }

            protected int sizeFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).joinedItemsSize();
            }
        };
    }

    protected boolean panelEnabled(MWQueryFormat mWQueryFormat) {
        return true;
    }

    private void addJoinedAttribute() {
        this.editSelectedAttribute(null);
    }

    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem mWAttributeItem) {
        return new AttributeItemDialog(this.getQuery(), mWAttributeItem, this.getWorkbenchContext()){

            protected String titleKey() {
                return "JOINED_ATTRIBUTES_DIALOG_TITLE";
            }

            protected String editTitleKey() {
                return "JOINED_ATTRIBUTES_EDIT_DIALOG_TITLE";
            }

            protected String helpTopicId() {
                return "dialog.joinedAttribute";
            }

            protected Filter buildTraversableFilter() {
                return new Filter(){

                    public boolean accept(Object object) {
                        return ((MWQueryable)object).isTraversableForJoinedAttribute();
                    }
                };
            }

            protected Filter buildChooseableFilter() {
                return new Filter(){

                    public boolean accept(Object object) {
                        return ((MWQueryable)object).isValidForJoinedAttribute();
                    }
                };
            }

            protected int attributeItemsSize() {
                return ((MWAbstractRelationalReadQuery)this.getQuery()).joinedItemsSize();
            }

            protected int indexOfAttributeItem(MWAttributeItem mWAttributeItem) {
                return ((MWAbstractRelationalReadQuery)this.getQuery()).indexOfJoinedItem((MWJoinedItem)mWAttributeItem);
            }

            protected void removeAttributeItem(int n) {
                ((MWAbstractRelationalReadQuery)this.getQuery()).removeJoinedItem(n);
            }

            protected void addAttributeItem(int n, Iterator iterator, Iterator iterator2) {
                ((MWAbstractRelationalReadQuery)this.getQuery()).addJoinedItem(n, iterator, iterator2);
            }
        };
    }
}

