/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeModel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class QueryableEditDialog
extends AbstractDialog {
    private QueryableTree queryKeyTree;
    private MWQueryableArgument argument;

    QueryableEditDialog(MWQueryableArgument mWQueryableArgument, WorkbenchContext workbenchContext) {
        super(workbenchContext, (Dialog)workbenchContext.getCurrentWindow());
        this.argument = mWQueryableArgument;
    }

    protected String helpTopicId() {
        return "dialogEditQueryable";
    }

    private TreeSelectionListener buildTreeSelectionHandler() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                QueryableEditDialog.this.updateOKButton();
            }
        };
    }

    private MWMappingDescriptor getDescriptor() {
        return this.argument.getParentQuery().getOwningDescriptor();
    }

    protected Component buildMainPanel() {
        this.getOKAction().setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("CHOOSE_QUERY_KEY_DIALOG_TITLE.title"));
        this.queryKeyTree = new QueryableTree(new QueryableTreeModel(new DefaultMutableTreeNode(this.getDescriptor()), this.buildQueryableFilter()), this.getWorkbenchContext());
        JScrollPane jScrollPane = new JScrollPane(this.queryKeyTree);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        this.queryKeyTree.addTreeSelectionListener(this.buildTreeSelectionHandler());
        this.queryKeyTree.setSelectedQueryableArgumentElement(this.argument.getQueryableArgumentElement());
        SwingComponentFactory.addDoubleClickMouseListener(this.queryKeyTree, new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent mouseEvent) {
                TreePath treePath = QueryableEditDialog.this.queryKeyTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    QueryableEditDialog.this.clickOK();
                }
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private Filter buildQueryableFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return ((MWQueryable)object).isTraversableForQueryExpression();
            }
        };
    }

    protected boolean preConfirm() {
        TreePath treePath = this.queryKeyTree.getSelectionPath();
        ArrayList<MWQueryable> arrayList = new ArrayList<MWQueryable>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        QueryableTreeNode queryableTreeNode = (QueryableTreeNode)treePath.getLastPathComponent();
        arrayList2.add(queryableTreeNode.isAllowsNull());
        MWQueryable mWQueryable = queryableTreeNode.getQueryable();
        arrayList.add(mWQueryable);
        treePath = treePath.getParentPath();
        while (treePath.getPathCount() > 1) {
            queryableTreeNode = (QueryableTreeNode)treePath.getLastPathComponent();
            arrayList2.add(new Boolean(queryableTreeNode.isAllowsNull()));
            MWQueryable mWQueryable2 = queryableTreeNode.getQueryable();
            arrayList.add(mWQueryable2);
            treePath = treePath.getParentPath();
        }
        this.argument.setQueryableArgument(arrayList.iterator(), arrayList2.iterator());
        ((DefaultMutableTreeNode)this.queryKeyTree.getModel().getRoot()).removeAllChildren();
        return super.preConfirm();
    }

    protected void cancelPressed() {
        ((DefaultMutableTreeNode)this.queryKeyTree.getModel().getRoot()).removeAllChildren();
        super.cancelPressed();
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.queryKeyTree.getSelectionCount() > 0);
    }
}

