/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class QueryableTreeModel
implements TreeModel {
    private DefaultMutableTreeNode rootDescriptor;
    private Filter queryableFilter;
    private List queryableObjects;

    QueryableTreeModel(DefaultMutableTreeNode defaultMutableTreeNode) {
        this(defaultMutableTreeNode, Filter.NULL_INSTANCE);
    }

    QueryableTreeModel(DefaultMutableTreeNode defaultMutableTreeNode, Filter filter) {
        this.rootDescriptor = defaultMutableTreeNode;
        this.queryableFilter = filter;
        this.queryableObjects = this.buildQueryableObjects();
    }

    protected Filter getQueryableFilter() {
        return this.queryableFilter;
    }

    public Object getRoot() {
        return this.rootDescriptor;
    }

    MWTableDescriptor getDescriptor() {
        return (MWTableDescriptor)((DefaultMutableTreeNode)this.getRoot()).getUserObject();
    }

    List buildQueryableObjects() {
        List list = this.getDescriptor().getQueryables(this.queryableFilter);
        Collections.sort(list, Node.DEFAULT_COMPARATOR);
        return list;
    }

    public Object getChild(Object object, int n) {
        MWQueryable mWQueryable = QueryableTreeNode.class.isAssignableFrom(object.getClass()) ? ((MWQueryable)((QueryableTreeNode)object).getUserObject()).subQueryableElementAt(n, this.queryableFilter) : (MWQueryable)this.queryableObjects.get(n);
        if (((DefaultMutableTreeNode)object).getChildCount() > n) {
            return ((DefaultMutableTreeNode)object).getChildAt(n);
        }
        QueryableTreeNode queryableTreeNode = new QueryableTreeNode(mWQueryable, !mWQueryable.isLeaf(this.queryableFilter));
        ((DefaultMutableTreeNode)object).add(queryableTreeNode);
        return queryableTreeNode;
    }

    public int getChildCount(Object object) {
        if (object == this.getRoot()) {
            return this.queryableObjects.size();
        }
        return ((QueryableTreeNode)object).getQueryable().subQueryableElements(this.queryableFilter).size();
    }

    public boolean isLeaf(Object object) {
        if (object == this.getRoot()) {
            return false;
        }
        return ((QueryableTreeNode)object).isLeaf(this.queryableFilter);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.getRoot()) {
            return this.queryableObjects.indexOf(((QueryableTreeNode)object2).getQueryable());
        }
        List list = ((QueryableTreeNode)object2).getQueryable().subQueryableElements(this.queryableFilter);
        if (list != null && list.size() > 0) {
            return list.indexOf(((QueryableTreeNode)object2).getQueryable());
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }
}

