/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWDeleteQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWInsertQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWUpdateQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CustomQuerySelectionCriteriaPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class RelationalCustomSqlPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel queryManagerHolder;

    public RelationalCustomSqlPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.queryManagerHolder = this.buildQueryManagerHolder();
    }

    private PropertyValueModel buildQueryManagerHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getQueryManager();
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.customSQL";
    }

    protected Component buildPage() {
        this.setName("Queries");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTabbedPane jTabbedPane = new JTabbedPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jTabbedPane, gridBagConstraints);
        JComponent jComponent = this.buildInsertQueryPanel();
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jComponent.getBorder()));
        this.addHelpTopicId(jComponent, this.helpTopicId() + ".insert");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_INSERT_TAB"), jComponent);
        JComponent jComponent2 = this.buildUpdateQueryPanel();
        jComponent2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jComponent2.getBorder()));
        this.addHelpTopicId(jComponent2, this.helpTopicId() + ".update");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_UPDATE_TAB"), jComponent2);
        JComponent jComponent3 = this.buildDeleteQueryPanel();
        jComponent3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jComponent3.getBorder()));
        this.addHelpTopicId(jComponent3, this.helpTopicId() + ".delete");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_DELETE_TAB"), jComponent3);
        JComponent jComponent4 = this.buildReadObjectQueryPanel();
        jComponent4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jComponent4.getBorder()));
        this.addHelpTopicId(jComponent4, this.helpTopicId() + ".readObject");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_READ_OBJECT_TAB"), jComponent4);
        JComponent jComponent5 = this.buildReadAllQueryPanel();
        jComponent5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jComponent5.getBorder()));
        this.addHelpTopicId(jComponent5, this.helpTopicId() + ".readAll");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_READ_ALL_TAB"), jComponent5);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private JComponent buildInsertQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildInsertQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildInsertQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "insertQuery"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getInsertQuery();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setInsertQuery((MWInsertQuery)object);
            }
        };
    }

    private JComponent buildUpdateQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildUpdateQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildUpdateQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "updateQuery"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getUpdateQuery();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setUpdateQuery((MWUpdateQuery)object);
            }
        };
    }

    private JComponent buildDeleteQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildDeleteQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildDeleteQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "deleteQuery"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getDeleteQuery();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setDeleteQuery((MWDeleteQuery)object);
            }
        };
    }

    private JComponent buildReadObjectQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildReadObjectQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildReadObjectQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readObjectQuery"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadObjectQuery();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setReadObjectQuery((MWCustomReadObjectQuery)object);
            }
        };
    }

    private JComponent buildReadAllQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildReadAllQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildReadAllQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readAllQuery"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadAllQuery();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setReadAllQuery((MWCustomReadAllQuery)object);
            }
        };
    }

    private JTextArea buildTextArea(PropertyValueModel propertyValueModel) {
        JTextArea jTextArea = new JTextArea(new DocumentAdapter(propertyValueModel));
        jTextArea.setFont(new Font("dialog", 0, 12));
        return jTextArea;
    }
}

