/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.TriStateBooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

class RelationalQueryComponentFactory
extends QueryComponentFactory {
    private static List triStateBooleanOptions;

    RelationalQueryComponentFactory() {
    }

    static JComboBox buildCacheStatementComboBox(PropertyValueModel propertyValueModel, final ResourceRepository resourceRepository) {
        PropertyValueModel propertyValueModel2 = RelationalQueryComponentFactory.buildRelationalOptionsHolder(propertyValueModel);
        final PropertyValueModel propertyValueModel3 = RelationalQueryComponentFactory.buildProjectCacheStatementHolder(propertyValueModel2);
        JComboBox<Object> jComboBox = new JComboBox<Object>(new ComboBoxModelAdapter(RelationalQueryComponentFactory.buildTriStateBooleanValueModel(), RelationalQueryComponentFactory.buildCacheStatementAdapter(propertyValueModel2)));
        jComboBox.setRenderer(new AdaptableListCellRenderer(new TriStateBooleanCellRendererAdapter(resourceRepository){

            protected String undefinedString() {
                Boolean bl = (Boolean)propertyValueModel3.getValue();
                return resourceRepository.getString("QUERY_DESCRIPTOR_DEFAULT_VALUE", bl);
            }
        }));
        propertyValueModel3.addPropertyChangeListener("value", RelationalQueryComponentFactory.buildProjectDefaultListener(jComboBox));
        return jComboBox;
    }

    private static PropertyValueModel buildCacheStatementAdapter(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter((ValueModel)propertyValueModel, "cacheStatement"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).isCacheStatement();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQuery)this.subject).setCacheStatement((TriStateBoolean)object);
            }
        };
    }

    private static PropertyChangeListener buildProjectDefaultListener(final JComboBox jComboBox) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jComboBox.repaint();
            }
        };
    }

    private static PropertyValueModel buildProjectCacheStatementHolder(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter(propertyValueModel){

            protected Object getValueFromSubject() {
                return new Boolean(((MWRelationalProjectDefaultsPolicy)((MWRelationalSpecificQueryOptions)this.subject).getProject().getDefaultsPolicy()).shouldQueriesCacheAllStatements());
            }
        };
    }

    static JComboBox buildBindParametersComboBox(PropertyValueModel propertyValueModel, final ResourceRepository resourceRepository) {
        PropertyValueModel propertyValueModel2 = RelationalQueryComponentFactory.buildRelationalOptionsHolder(propertyValueModel);
        final PropertyValueModel propertyValueModel3 = RelationalQueryComponentFactory.buildProjectBindParametersHolder(propertyValueModel2);
        JComboBox<Object> jComboBox = new JComboBox<Object>(new ComboBoxModelAdapter(RelationalQueryComponentFactory.buildTriStateBooleanValueModel(), RelationalQueryComponentFactory.buildBindParametersPropertyAdapter(propertyValueModel2)));
        jComboBox.setRenderer(new AdaptableListCellRenderer(new TriStateBooleanCellRendererAdapter(resourceRepository){

            protected String undefinedString() {
                Boolean bl = (Boolean)propertyValueModel3.getValue();
                return resourceRepository.getString("QUERY_DESCRIPTOR_DEFAULT_VALUE", bl);
            }
        }));
        propertyValueModel3.addPropertyChangeListener("value", RelationalQueryComponentFactory.buildProjectDefaultListener(jComboBox));
        return jComboBox;
    }

    private static PropertyValueModel buildBindParametersPropertyAdapter(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter((ValueModel)propertyValueModel, "bindAllParameters"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).isBindAllParameters();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQuery)this.subject).setBindAllParameters((TriStateBoolean)object);
            }
        };
    }

    private static PropertyValueModel buildProjectBindParametersHolder(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter(propertyValueModel){

            protected Object getValueFromSubject() {
                return new Boolean(((MWRelationalProjectDefaultsPolicy)((MWRelationalSpecificQueryOptions)this.subject).getProject().getDefaultsPolicy()).shouldQueriesBindAllParameters());
            }
        };
    }

    private static PropertyValueModel buildRelationalOptionsHolder(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter(propertyValueModel){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getRelationalOptions();
            }
        };
    }

    private static CollectionValueModel buildTriStateBooleanValueModel() {
        return new AbstractReadOnlyCollectionValueModel(){

            public Object getValue() {
                return RelationalQueryComponentFactory.triStateBooleanOptions();
            }
        };
    }

    public static Iterator triStateBooleanOptions() {
        if (triStateBooleanOptions == null) {
            triStateBooleanOptions = new ArrayList();
            triStateBooleanOptions.add(TriStateBoolean.UNDEFINED);
            triStateBooleanOptions.add(TriStateBoolean.TRUE);
            triStateBooleanOptions.add(TriStateBoolean.FALSE);
        }
        return triStateBooleanOptions.listIterator();
    }
}

