/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBatchReadItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryQuickViewItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QuickViewPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.OrderingAttributesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QuerySelectionCriteriaPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReadAllQueryOptimizationPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryOptionsPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class RelationalReadAllQueryPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private JTabbedPane tabbedPane;
    private QueryGeneralPanel queryGeneralPanel;
    private JPanel queryFormatPanel;
    private OrderingAttributesPanel queryOrderingPanel;
    private ReadAllQueryOptimizationPanel queryOptimizationPanel;
    private RelationalQueryOptionsPanel queryOptionsPanel;

    RelationalReadAllQueryPanel(PropertyValueModel propertyValueModel, ObjectListSelectionModel objectListSelectionModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.queryHolder = propertyValueModel;
        this.initializeLayout(objectListSelectionModel);
    }

    private Filter buildOrderingChooseableFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return ((MWQueryable)object).isValidForReadAllQueryOrderable();
            }
        };
    }

    private Filter buildOrderingTraversableFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return ((MWQueryable)object).isTraversableForReadAllQueryOrderable();
            }
        };
    }

    private void initializeLayout(ObjectListSelectionModel objectListSelectionModel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tabbedPane = new JTabbedPane();
        this.queryGeneralPanel = new QueryGeneralPanel(this.queryHolder, objectListSelectionModel, this.getWorkbenchContextHolder());
        this.queryFormatPanel = new QuerySelectionCriteriaPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryOrderingPanel = new OrderingAttributesPanel(this.queryHolder, this.buildOrderingTraversableFilter(), this.buildOrderingChooseableFilter(), this.getWorkbenchContextHolder());
        this.queryOptimizationPanel = new ReadAllQueryOptimizationPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryOptionsPanel = new RelationalQueryOptionsPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.tabbedPane.addTab(this.resourceRepository().getString("GENERAL_TAB"), this.queryGeneralPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("FORMAT_TAB"), this.queryFormatPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("ORDER_TAB"), this.queryOrderingPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("OPTIMIZATION_TAB"), this.queryOptimizationPanel);
        this.tabbedPane.addTab(this.resourceRepository().getString("OPTIONS_TAB"), this.queryOptionsPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    protected QuickViewPanel.QuickViewItem buildBatchReadAttributeQuickViewItem(MWBatchReadItem mWBatchReadItem) {
        return new QueryQuickViewItem((MWQueryItem)mWBatchReadItem){

            public void select() {
                RelationalReadAllQueryPanel.this.tabbedPane.setSelectedComponent(RelationalReadAllQueryPanel.this.queryOptimizationPanel);
                RelationalReadAllQueryPanel.this.queryOptimizationPanel.selectBatchReadItem((MWBatchReadItem)this.getValue());
            }
        };
    }

    protected QuickViewPanel.QuickViewItem buildJoinedAttributeQuickViewItem(MWJoinedItem mWJoinedItem) {
        return new QueryQuickViewItem((MWQueryItem)mWJoinedItem){

            public void select() {
                RelationalReadAllQueryPanel.this.tabbedPane.setSelectedComponent(RelationalReadAllQueryPanel.this.queryOptimizationPanel);
                RelationalReadAllQueryPanel.this.queryOptimizationPanel.selectJoinedItem((MWJoinedItem)this.getValue());
            }
        };
    }

    protected QuickViewPanel.QuickViewItem buildOrderingAttributeQuickViewItem(Ordering ordering) {
        return new QueryQuickViewItem((MWQueryItem)ordering){

            public void select() {
                RelationalReadAllQueryPanel.this.tabbedPane.setSelectedComponent(RelationalReadAllQueryPanel.this.queryOrderingPanel);
                RelationalReadAllQueryPanel.this.queryOrderingPanel.select((MWQueryItem)this.getValue());
            }
        };
    }

    protected void selectQueryOptimizationTab() {
        this.tabbedPane.setSelectedComponent(this.queryOptimizationPanel);
    }

    protected void selectQueryOrderingTab() {
        this.tabbedPane.setSelectedComponent(this.queryOrderingPanel);
    }

    protected QueryGeneralPanel getQueryGeneralPanel() {
        return this.queryGeneralPanel;
    }

    protected JTabbedPane getQueryTabbedPane() {
        return this.tabbedPane;
    }
}

