/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class ReportQueryAttributeDialog
extends AttributeItemDialog {
    private JComboBox functionComboBox = new JComboBox(this.buildFunctionComboBoxModel());
    private JTextField itemNameTextField = new JTextField();

    ReportQueryAttributeDialog(MWReportQuery mWReportQuery, MWReportAttributeItem mWReportAttributeItem, WorkbenchContext workbenchContext) {
        super((MWQuery)mWReportQuery, (MWAttributeItem)mWReportAttributeItem, workbenchContext);
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.report.attributes";
    }

    protected String titleKey() {
        return "REPORT_QUERY_ATTRIBUTES_DIALOG_TITLE";
    }

    protected String editTitleKey() {
        return "REPORT_QUERY_ATTRIBUTES_EDIT_DIALOG_TITLE";
    }

    protected Filter buildChooseableFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return ((MWQueryable)object).isValidForReportQueryAttribute();
            }
        };
    }

    protected Filter buildTraversableFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return ((MWQueryable)object).isTraversableForReportQueryAttribute();
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        QueryableTree queryableTree = this.buildQueryableTree();
        JScrollPane jScrollPane = new JScrollPane(queryableTree);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JLabel jLabel = SwingComponentFactory.buildLabel("FUNCTION_LABEL", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.functionComboBox.setEditable(true);
        this.functionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ReportQueryAttributeDialog.this.updateOKButton();
                ReportQueryAttributeDialog.this.calculateItemName();
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.functionComboBox, gridBagConstraints);
        jLabel.setLabelFor(this.functionComboBox);
        JLabel jLabel2 = SwingComponentFactory.buildLabel("ATTRIBUTE_ITEM_NAME_LABEL", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.itemNameTextField, gridBagConstraints);
        jLabel2.setLabelFor(this.itemNameTextField);
        return jPanel;
    }

    private ComboBoxModel buildFunctionComboBoxModel() {
        return new DefaultComboBoxModel<String>(MWReportAttributeItem.FUNCTIONS);
    }

    String getFunction() {
        return (String)this.functionComboBox.getSelectedItem();
    }

    String getItemName() {
        return this.itemNameTextField.getText();
    }

    protected void initializeEditMode(MWAttributeItem mWAttributeItem) {
        super.initializeEditMode(mWAttributeItem);
        this.functionComboBox.setSelectedItem(((MWReportAttributeItem)mWAttributeItem).getFunction());
        this.itemNameTextField.setText(((MWReportAttributeItem)mWAttributeItem).getName());
    }

    protected void treeSelectionChanged(TreeSelectionEvent treeSelectionEvent) {
        super.treeSelectionChanged(treeSelectionEvent);
        this.calculateItemName();
    }

    protected void updateOKButton() {
        if (this.getFunction() == "Count" && this.getQueryableTree().getSelectionCount() == 0) {
            this.getOKAction().setEnabled(true);
            return;
        }
        super.updateOKButton();
    }

    private void calculateItemName() {
        TreePath treePath = this.getQueryableTree().getSelectionPath();
        if (treePath == null) {
            return;
        }
        QueryableTreeNode queryableTreeNode = (QueryableTreeNode)treePath.getLastPathComponent();
        MWQueryable mWQueryable = queryableTreeNode.getQueryable();
        String string = mWQueryable.getName();
        treePath = treePath.getParentPath();
        while (treePath.getPathCount() > 1) {
            queryableTreeNode = (QueryableTreeNode)treePath.getLastPathComponent();
            MWQueryable mWQueryable2 = queryableTreeNode.getQueryable();
            string = mWQueryable2.getName() + string;
            treePath = treePath.getParentPath();
        }
        if (this.getFunction() != "None") {
            string = string + this.getFunction();
        }
        this.itemNameTextField.setText(string);
    }

    protected int attributeItemsSize() {
        return ((MWReportQuery)this.getQuery()).attributeItemsSize();
    }

    protected int indexOfAttributeItem(MWAttributeItem mWAttributeItem) {
        return ((MWReportQuery)this.getQuery()).indexOfAttributeItem((MWReportAttributeItem)mWAttributeItem);
    }

    protected void addAttributeItem(int n, Iterator iterator, Iterator iterator2) {
        MWReportAttributeItem mWReportAttributeItem = ((MWReportQuery)this.getQuery()).addAttributeItem(n, this.getItemName(), iterator, iterator2);
        mWReportAttributeItem.setFunction(this.getFunction());
    }

    protected void removeAttributeItem(int n) {
        ((MWReportQuery)this.getQuery()).removeAttributeItem(n);
    }

    protected boolean preConfirm() {
        TreePath treePath = this.getQueryableTree().getSelectionPath();
        if (treePath == null) {
            if (this.getFunction() != "Count") {
                throw new IllegalStateException("Must select an item from the tree unless the chosen funciton is Count");
            }
            MWReportAttributeItem mWReportAttributeItem = ((MWReportQuery)this.getQuery()).addAttributeItem(null, (MWQueryable)null);
            mWReportAttributeItem.setFunction(this.getFunction());
            return true;
        }
        return super.preConfirm();
    }
}

