/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.event.MouseEvent;
import java.util.ListIterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReportQueryAttributeDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class ReportQueryAttributesPanel
extends AbstractAttributeItemsPanel {
    public ReportQueryAttributesPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "attributeItems"){

            protected ListIterator getValueFromSubject() {
                return ((MWReportQuery)this.subject).attributeItems();
            }

            protected int sizeFromSubject() {
                return ((MWReportQuery)this.subject).attributeItemsSize();
            }
        };
    }

    protected AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                ReportQueryAttributesPanel.this.addAttribute();
            }

            public String optionalButtonKey() {
                return "REPORT_QUERY_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                ReportQueryAttributesPanel.this.editSelectedAttribute((MWAttributeItem)((MWReportAttributeItem)objectListSelectionModel.getSelectedValue()));
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                Object[] objectArray = objectListSelectionModel.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWReportQuery)ReportQueryAttributesPanel.this.getQuery()).removeAttributeItem((MWReportAttributeItem)objectArray[i]);
                }
            }

            public void moveItemsDown(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWReportQuery)ReportQueryAttributesPanel.this.getQuery()).moveAttributeItemDown((MWReportAttributeItem)objectArray[i]);
                }
            }

            public void moveItemsUp(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWReportQuery)ReportQueryAttributesPanel.this.getQuery()).moveAttributeItemUp((MWReportAttributeItem)objectArray[i]);
                }
            }
        };
    }

    private void addAttribute() {
        this.editSelectedAttribute(null);
    }

    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem mWAttributeItem) {
        return new ReportQueryAttributeDialog((MWReportQuery)this.getQuery(), (MWReportAttributeItem)mWAttributeItem, this.getWorkbenchContext());
    }

    private ComboBoxModel buildFunctionComboBoxModel() {
        return new DefaultComboBoxModel<String>(MWReportAttributeItem.FUNCTIONS);
    }

    private ComboBoxTableCellRenderer buildFunctionComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildFunctionComboBoxModel());
    }

    protected PropertyValueModel buildQueryHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWReportQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "query.report.attributes";
    }

    String listTitleKey() {
        return "REPORT_QUERY_ATTRIBUTES_LIST";
    }

    protected boolean panelEnabled(MWQueryFormat mWQueryFormat) {
        return mWQueryFormat.reportAttributesAllowed();
    }

    protected AddRemovePanel buildAddRemovePanel() {
        final AddRemoveTablePanel addRemoveTablePanel = new AddRemoveTablePanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAttributesPanelAdapter(), this.buildAttributesHolder(), (ColumnAdapter)new AttributeItemsColumnAdapter(this.resourceRepository()), 3);
        addRemoveTablePanel.setBorder(this.buildTitledBorder(this.listTitleKey()));
        SwingComponentFactory.addDoubleClickMouseListener(addRemoveTablePanel.getComponent(), new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent mouseEvent) {
                ReportQueryAttributesPanel.this.editSelectedAttribute((MWAttributeItem)addRemoveTablePanel.getSelectionModel().getSelectedValue());
            }
        });
        this.addHelpTopicId(addRemoveTablePanel, this.helpTopicId());
        this.updateTableColumns((JTable)addRemoveTablePanel.getComponent());
        return addRemoveTablePanel;
    }

    private void updateTableColumns(JTable jTable) {
        int n = 0;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(2);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildFunctionComboBoxRenderer();
        tableColumn.setCellRenderer(this.buildFunctionComboBoxRenderer());
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildFunctionComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new SimpleTableCellRenderer(){

            protected String buildText(Object object) {
                if (object != null) {
                    return ((MWQueryableArgument)object).displayString();
                }
                return "";
            }
        });
        jTable.setRowHeight(n);
    }

    private static class AttributeItemsColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int ITEM_NAME_COLUMN = 0;
        public static final int ATTRIBUTE_COLUMN = 1;
        public static final int FUNCTION_COLUMN = 2;
        public static final int COLUMN_COUNT = 3;
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        private static final String[] COLUMN_NAME_KEYS = new String[]{"ITEM_NAME_COLUMN_HEADER", "ATTRIBUTE_COLUMN_HEADER", "FUNCTION_COLUMN_HEADER"};

        private AttributeItemsColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        private PropertyValueModel buildAttributeAdapter(MWReportAttributeItem mWReportAttributeItem) {
            return new PropertyAspectAdapter(EMPTY_STRING_ARRAY, (Model)mWReportAttributeItem){

                protected Object getValueFromSubject() {
                    return ((MWReportAttributeItem)this.subject).getQueryableArgument();
                }
            };
        }

        private PropertyValueModel buildFunctionAdapter(MWReportAttributeItem mWReportAttributeItem) {
            return new PropertyAspectAdapter("function", (Model)mWReportAttributeItem){

                protected Object getValueFromSubject() {
                    return ((MWReportAttributeItem)this.subject).getFunction();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWReportAttributeItem)this.subject).setFunction((String)object);
                }
            };
        }

        private PropertyValueModel buildItemNameAdapter(MWReportAttributeItem mWReportAttributeItem) {
            return new PropertyAspectAdapter("name", (Model)mWReportAttributeItem){

                protected Object getValueFromSubject() {
                    return ((MWReportAttributeItem)this.subject).getName();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWReportAttributeItem)this.subject).setName((String)object);
                }
            };
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWReportAttributeItem mWReportAttributeItem = (MWReportAttributeItem)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildItemNameAdapter(mWReportAttributeItem), this.buildAttributeAdapter(mWReportAttributeItem), this.buildFunctionAdapter(mWReportAttributeItem)};
            return propertyValueModelArray;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public boolean isColumnEditable(int n) {
            return n == 2;
        }
    }
}

