/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.OrderingAttributeDialog;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class ReportQueryOrderingAttributeDialog
extends OrderingAttributeDialog {
    private ObjectListSelectionModel attributesListSelectionModel;
    private Component existingAttributePanel;
    private Component newAttributePanel;
    private PropertyValueModel attributeTypeHolder;

    ReportQueryOrderingAttributeDialog(MWReportQuery mWReportQuery, MWReportOrderingItem mWReportOrderingItem, Filter filter, Filter filter2, WorkbenchContext workbenchContext) {
        super((MWOrderableQuery)mWReportQuery, (Ordering)mWReportOrderingItem, filter, filter2, workbenchContext);
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.reportQuery.orderingAttributes";
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.attributeTypeHolder = new SimplePropertyValueModel();
        RadioButtonModelAdapter radioButtonModelAdapter = new RadioButtonModelAdapter(this.attributeTypeHolder, "Selected Attribute");
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("ORDERING_ATTRIBUTES_DIALOG_SELECTED_ATTRIBUTE_BUTTON", radioButtonModelAdapter, this.resourceRepository());
        jRadioButton.setSelected(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        RadioButtonModelAdapter radioButtonModelAdapter2 = new RadioButtonModelAdapter(this.attributeTypeHolder, "New Attribute");
        JRadioButton jRadioButton2 = SwingComponentFactory.buildRadioButton("ORDERING_ATTRIBUTES_DIALOG_NEW_ATTRIBUTE_BUTTON", radioButtonModelAdapter2, this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        this.existingAttributePanel = this.buildExistingAttributePanel();
        this.newAttributePanel = this.buildNewAttributePanel();
        SwitcherPanel switcherPanel = new SwitcherPanel(this.attributeTypeHolder, this.buildSwitchPanelTransformer());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)switcherPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("ORDERING_ATTRIBUTES_DIALOG_ORDER_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JComboBox jComboBox = this.buildOrderComboBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        jPanel2.add((Component)jComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private ListModel buildReportAttributesListModel() {
        DefaultListModel defaultListModel = new DefaultListModel();
        ListIterator listIterator = ((MWReportQuery)this.getQuery()).attributeItems();
        while (listIterator.hasNext()) {
            defaultListModel.addElement(listIterator.next());
        }
        return defaultListModel;
    }

    private Transformer buildSwitchPanelTransformer() {
        return new Transformer(){

            public Object transform(Object object) {
                if (object == "Selected Attribute") {
                    return ReportQueryOrderingAttributeDialog.this.getExistingAttributePanel();
                }
                ReportQueryOrderingAttributeDialog.this.attributesListSelectionModel.setSelectedValue(null);
                return ReportQueryOrderingAttributeDialog.this.getNewAttributePanel();
            }
        };
    }

    private Component getExistingAttributePanel() {
        return this.existingAttributePanel;
    }

    private Component buildExistingAttributePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ListModel listModel = this.buildReportAttributesListModel();
        JList<Object> jList = new JList<Object>(listModel);
        this.attributesListSelectionModel = new ObjectListSelectionModel(listModel);
        jList.setSelectionModel(this.attributesListSelectionModel);
        jList.setSelectionMode(0);
        jList.setCellRenderer(new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return ((MWReportAttributeItem)object).getName();
            }
        });
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ReportQueryOrderingAttributeDialog.this.updateOKButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private Component getNewAttributePanel() {
        return this.newAttributePanel;
    }

    private Component buildNewAttributePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.buildQueryableTree());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    protected void initializeEditMode(MWAttributeItem mWAttributeItem) {
        if (((MWReportOrderingItem)mWAttributeItem).getItemName() == null) {
            super.initializeEditMode(mWAttributeItem);
            this.attributeTypeHolder.setValue("New Attribute");
        } else {
            for (int i = 0; i < this.attributesListSelectionModel.getListModel().getSize(); ++i) {
                MWReportAttributeItem mWReportAttributeItem = (MWReportAttributeItem)this.attributesListSelectionModel.getListModel().getElementAt(i);
                if (mWReportAttributeItem.getQueryableArgument() != mWAttributeItem.getQueryableArgument()) continue;
                this.attributesListSelectionModel.setSelectedValue(mWReportAttributeItem);
                break;
            }
            this.initializeOrderComboBox(mWAttributeItem);
        }
    }

    protected void updateOKButton() {
        if (this.attributesListSelectionModel.getSelectedValue() != null) {
            this.getOKAction().setEnabled(true);
        } else {
            super.updateOKButton();
        }
    }

    protected boolean preConfirm() {
        MWReportAttributeItem mWReportAttributeItem = (MWReportAttributeItem)this.attributesListSelectionModel.getSelectedValue();
        if (mWReportAttributeItem == null) {
            return super.preConfirm();
        }
        int n = this.attributeItemsSize();
        if (this.getAttributeItem() != null) {
            n = this.indexOfAttributeItem(this.getAttributeItem());
            this.removeAttributeItem(n);
        }
        MWReportOrderingItem mWReportOrderingItem = ((MWReportQuery)this.getQuery()).addOrderingItem(mWReportAttributeItem);
        mWReportOrderingItem.setAscending(this.isAscending());
        return true;
    }
}

