/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWAbstractEisReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml.EisQueryOptionsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml.InteractionPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class EisQueryPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private JTabbedPane queryPropertiesPane;
    private QueryGeneralPanel queryGeneralPanel;

    EisQueryPanel(PropertyValueModel propertyValueModel, ObjectListSelectionModel objectListSelectionModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.queryHolder = propertyValueModel;
        this.initializeLayout(objectListSelectionModel);
    }

    private void initializeLayout(ObjectListSelectionModel objectListSelectionModel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.queryPropertiesPane = new JTabbedPane();
        this.queryGeneralPanel = new QueryGeneralPanel(this.queryHolder, objectListSelectionModel, this.getWorkbenchContextHolder());
        InteractionPanel interactionPanel = new InteractionPanel(this.getApplicationContext(), this.buildInteractionHolder(), this.buildComponentEnablerBooleanHolder(), "descriptor.eis.query");
        EisQueryOptionsPanel eisQueryOptionsPanel = new EisQueryOptionsPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("GENERAL_TAB"), this.queryGeneralPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("CALL_TAB"), interactionPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("OPTIONS_TAB"), eisQueryOptionsPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.queryPropertiesPane, gridBagConstraints);
    }

    private PropertyValueModel buildInteractionHolder() {
        return new PropertyAspectAdapter(this.queryHolder){

            protected Object getValueFromSubject() {
                return ((MWAbstractEisReadQuery)this.subject).getEisInteraction();
            }
        };
    }

    protected PropertyValueModel buildComponentEnablerBooleanHolder() {
        return new PropertyAspectAdapter(this.queryHolder){

            protected Object getValueFromSubject() {
                return true;
            }
        };
    }

    protected QueryGeneralPanel getQueryGeneralPanel() {
        return this.queryGeneralPanel;
    }

    protected JTabbedPane getQueryTabbedPane() {
        return this.queryPropertiesPane;
    }
}

