/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class InteractionPanel
extends AbstractPanel {
    private PropertyValueModel eisInteractionHolder;
    private String helpTopicId;
    private JTable inputArgumentsTable;
    private JTable outputArgumentsTable;
    private JTable propertiesTable;
    private JButton addInputArgumentButton;
    private JButton removeInputArgumentButton;
    private JButton addPropertyButton;
    private JButton removePropertyButton;
    private JButton addOutputArgumentButton;
    private JButton removeOutputArgumentButton;

    public InteractionPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, String string) {
        super(applicationContext);
        this.initialize(propertyValueModel, propertyValueModel2, string);
    }

    public InteractionPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string) {
        this(applicationContext, propertyValueModel, null, string);
    }

    public InteractionPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2) {
        this(applicationContext, propertyValueModel, propertyValueModel2, "descriptor.queryManager.customCalls");
    }

    public InteractionPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel) {
        this(applicationContext, propertyValueModel, null, "descriptor.queryManager.customCalls");
    }

    protected void initialize(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, String string) {
        this.helpTopicId = string;
        this.eisInteractionHolder = propertyValueModel;
        this.initializeLayout(propertyValueModel2);
    }

    public void initializeLayout(PropertyValueModel propertyValueModel) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)pane, gridBagConstraints);
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{this.resourceRepository().getString("XML_INTERACTION")});
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        pane.add(jComboBox, gridBagConstraints);
        JComponent jComponent = this.buildLabeledTextField("FUNCTION_NAME", this.buildFunctionNameDocument(this.buildFunctionNameHolder()));
        CollectionTools.addAll(arrayList, (Object[])jComponent.getComponents());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        pane.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildLabeledTextField("INPUT_RECORD_NAME", this.buildInputRecordDocument(this.buildInputRecordNameHolder()));
        CollectionTools.addAll(arrayList, (Object[])jComponent2.getComponents());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        pane.add((Component)jComponent2, gridBagConstraints);
        JComponent jComponent3 = this.buildLabeledTextField("INPUT_ROOT_ELEMENT_NAME", this.buildInputRootElementNameDocument(this.buildInputRootElementNameHolder()));
        CollectionTools.addAll(arrayList, (Object[])jComponent3.getComponents());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        pane.add((Component)jComponent3, gridBagConstraints);
        JLabel jLabel = this.buildLabel("INPUT_ARGUMENTS");
        arrayList.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        this.inputArgumentsTable = this.buildInputArgumentsTable();
        arrayList.add(this.inputArgumentsTable);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.inputArgumentsTable.setPreferredScrollableViewportSize(new Dimension(25, 50));
        JScrollPane jScrollPane = new JScrollPane(this.inputArgumentsTable);
        jScrollPane.getViewport().setBackground(this.inputArgumentsTable.getBackground());
        pane.add((Component)jScrollPane, gridBagConstraints);
        this.addInputArgumentButton = this.buildButton("ADD_ARGUMENT_BUTTON");
        this.addInputArgumentButton.addActionListener(this.buildAddArgumentAction());
        this.removeInputArgumentButton = this.buildButton("REMOVE_ARGUMENT_BUTTON");
        this.removeInputArgumentButton.addActionListener(this.buildRemoveArgumentAction());
        this.removeInputArgumentButton.setEnabled(false);
        ButtonPane buttonPane = new ButtonPane(this.inputArgumentsTable, this.addInputArgumentButton, this.removeInputArgumentButton);
        arrayList.add(buttonPane);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        pane.add((Component)buttonPane, gridBagConstraints);
        JLabel jLabel2 = this.buildLabel("OUTPUT_ARGUMENTS");
        arrayList.add(jLabel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)jLabel2, gridBagConstraints);
        this.addAlignLeft(jLabel2);
        this.outputArgumentsTable = this.buildOutputArgumentsTable();
        arrayList.add(this.outputArgumentsTable);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.outputArgumentsTable.setPreferredScrollableViewportSize(new Dimension(25, 50));
        jScrollPane = new JScrollPane(this.outputArgumentsTable);
        jScrollPane.getViewport().setBackground(this.outputArgumentsTable.getBackground());
        pane.add((Component)jScrollPane, gridBagConstraints);
        this.addOutputArgumentButton = this.buildButton("ADD_ARGUMENT_BUTTON");
        this.addOutputArgumentButton.addActionListener(this.buildAddArgumentAction());
        this.removeOutputArgumentButton = this.buildButton("REMOVE_ARGUMENT_BUTTON");
        this.removeOutputArgumentButton.addActionListener(this.buildRemoveArgumentAction());
        this.removeOutputArgumentButton.setEnabled(false);
        ButtonPane buttonPane2 = new ButtonPane(this.outputArgumentsTable, this.addOutputArgumentButton, this.removeOutputArgumentButton);
        arrayList.add(buttonPane2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        pane.add((Component)buttonPane2, gridBagConstraints);
        JComponent jComponent4 = this.buildLabeledTextField("INPUT_RESULT_PATH", this.buildInputResultPathDocument(this.buildInputResultPathHolder()));
        CollectionTools.addAll(arrayList, (Object[])jComponent4.getComponents());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        pane.add((Component)jComponent4, gridBagConstraints);
        JComponent jComponent5 = this.buildLabeledTextField("OUTPUT_RESULTS_PATH", this.buildOutputResultPathDocument(this.buildOutputResultPathHolder()));
        CollectionTools.addAll(arrayList, (Object[])jComponent5.getComponents());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        pane.add((Component)jComponent5, gridBagConstraints);
        JLabel jLabel3 = this.buildLabel("PROPERTIES");
        arrayList.add(jLabel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)jLabel3, gridBagConstraints);
        this.addAlignLeft(jLabel3);
        this.propertiesTable = this.buildPropertiesTable();
        arrayList.add(this.propertiesTable);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.propertiesTable.setPreferredScrollableViewportSize(new Dimension(25, 50));
        jScrollPane = new JScrollPane(this.propertiesTable);
        jScrollPane.getViewport().setBackground(this.propertiesTable.getBackground());
        pane.add((Component)jScrollPane, gridBagConstraints);
        this.addPropertyButton = this.buildButton("ADD_ARGUMENT_BUTTON");
        this.addPropertyButton.addActionListener(this.buildAddArgumentAction());
        this.removePropertyButton = this.buildButton("REMOVE_ARGUMENT_BUTTON");
        this.removePropertyButton.addActionListener(this.buildRemoveArgumentAction());
        this.removePropertyButton.setEnabled(false);
        ButtonPane buttonPane3 = new ButtonPane(this.propertiesTable, this.addPropertyButton, this.removePropertyButton);
        arrayList.add(buttonPane3);
        buttonPane3.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        pane.add((Component)buttonPane3, gridBagConstraints);
        this.addHelpTopicId(pane, this.helpTopicId());
        if (propertyValueModel != null) {
            new ComponentEnabler((ValueModel)propertyValueModel, arrayList);
        }
    }

    private PropertyValueModel buildFunctionNameHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "funtionName"){

            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getFunctionName();
            }

            protected void setValueOnSubject(Object object) {
                ((MWEisInteraction)this.subject).setFunctionName((String)object);
            }
        };
    }

    private DocumentAdapter buildFunctionNameDocument(PropertyValueModel propertyValueModel) {
        return new DocumentAdapter(propertyValueModel);
    }

    private PropertyValueModel buildInputRecordNameHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "inputRecordName"){

            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getInputRecordName();
            }

            protected void setValueOnSubject(Object object) {
                ((MWEisInteraction)this.subject).setInputRecordName((String)object);
            }
        };
    }

    private DocumentAdapter buildInputRecordDocument(PropertyValueModel propertyValueModel) {
        return new DocumentAdapter(propertyValueModel);
    }

    private PropertyValueModel buildInputRootElementNameHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "inputRootElementName"){

            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getInputRootElementName();
            }

            protected void setValueOnSubject(Object object) {
                ((MWEisInteraction)this.subject).setInputRootElementName((String)object);
            }
        };
    }

    private DocumentAdapter buildInputRootElementNameDocument(PropertyValueModel propertyValueModel) {
        return new DocumentAdapter(propertyValueModel);
    }

    private PropertyValueModel buildInputResultPathHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "inputResultPath"){

            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getInputResultPath();
            }

            protected void setValueOnSubject(Object object) {
                ((MWEisInteraction)this.subject).setInputResultPath((String)object);
            }
        };
    }

    private DocumentAdapter buildInputResultPathDocument(PropertyValueModel propertyValueModel) {
        return new DocumentAdapter(propertyValueModel);
    }

    private PropertyValueModel buildOutputResultPathHolder() {
        return new PropertyAspectAdapter(this.eisInteractionHolder, "outputResultPath"){

            protected Object getValueFromSubject() {
                return ((MWEisInteraction)this.subject).getOutputResultPath();
            }

            protected void setValueOnSubject(Object object) {
                ((MWEisInteraction)this.subject).setOutputResultPath((String)object);
            }
        };
    }

    private DocumentAdapter buildOutputResultPathDocument(PropertyValueModel propertyValueModel) {
        return new DocumentAdapter(propertyValueModel);
    }

    protected ListSelectionListener buildListSelectionHandler() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    InteractionPanel.this.updateRemoveArgumentButton();
                }
            }
        };
    }

    private void updateRemoveArgumentButton() {
        boolean bl = this.inputArgumentsTable.getSelectedRows().length > 0;
        this.removeInputArgumentButton.setEnabled(bl);
        bl = this.outputArgumentsTable.getSelectedRows().length > 0;
        this.removeOutputArgumentButton.setEnabled(bl);
        bl = this.propertiesTable.getSelectedRows().length > 0;
        this.removePropertyButton.setEnabled(bl);
    }

    protected ActionListener buildAddArgumentAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == InteractionPanel.this.addInputArgumentButton) {
                    InteractionPanel.this.addInputArgument();
                } else if (actionEvent.getSource() == InteractionPanel.this.addOutputArgumentButton) {
                    InteractionPanel.this.addOutputArgument();
                } else {
                    InteractionPanel.this.addProperty();
                }
            }
        };
    }

    protected ActionListener buildRemoveArgumentAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == InteractionPanel.this.removeInputArgumentButton) {
                    InteractionPanel.this.removeSelectedInputArguments();
                } else if (actionEvent.getSource() == InteractionPanel.this.removeOutputArgumentButton) {
                    InteractionPanel.this.removeSelectedOutputArguments();
                } else {
                    InteractionPanel.this.removeSelectedProperty();
                }
            }
        };
    }

    protected void addInputArgument() {
        this.getEisInteraction().addInputArgument();
        int n = this.getEisInteraction().inputArgumentsSize() - 1;
        JTable jTable = this.inputArgumentsTable;
        jTable.setRowSelectionInterval(n, n);
        jTable.editCellAt(n, 0);
        ((JTextField)jTable.getEditorComponent()).grabFocus();
        ((JTextField)jTable.getEditorComponent()).selectAll();
    }

    protected void addOutputArgument() {
        this.getEisInteraction().addOutputArgument();
        int n = this.getEisInteraction().outputArgumentsSize() - 1;
        JTable jTable = this.outputArgumentsTable;
        jTable.setRowSelectionInterval(n, n);
        jTable.editCellAt(n, 0);
        ((JTextField)jTable.getEditorComponent()).grabFocus();
        ((JTextField)jTable.getEditorComponent()).selectAll();
    }

    protected void addProperty() {
        this.getEisInteraction().addProperty();
        int n = this.getEisInteraction().propertySize() - 1;
        JTable jTable = this.propertiesTable;
        jTable.setRowSelectionInterval(n, n);
        jTable.editCellAt(n, 0);
        ((JTextField)jTable.getEditorComponent()).grabFocus();
        ((JTextField)jTable.getEditorComponent()).selectAll();
    }

    protected void removeSelectedInputArguments() {
        if (this.inputArgumentsTable.isEditing()) {
            this.inputArgumentsTable.getCellEditor().stopCellEditing();
        }
        int[] nArray = this.inputArgumentsTable.getSelectedRows();
        int n = nArray.length;
        while (--n >= 0) {
            MWEisInteraction.ArgumentPair argumentPair = this.getEisInteraction().getInputArgumentPair(nArray[n]);
            this.getEisInteraction().removeInputArgument(argumentPair);
        }
    }

    protected void removeSelectedOutputArguments() {
        if (this.outputArgumentsTable.isEditing()) {
            this.outputArgumentsTable.getCellEditor().stopCellEditing();
        }
        int[] nArray = this.outputArgumentsTable.getSelectedRows();
        int n = nArray.length;
        while (--n >= 0) {
            MWEisInteraction.ArgumentPair argumentPair = this.getEisInteraction().getOutputArgumentPair(nArray[n]);
            this.getEisInteraction().removeOutputArgument(argumentPair);
        }
    }

    protected void removeSelectedProperty() {
        if (this.propertiesTable.isEditing()) {
            this.propertiesTable.getCellEditor().stopCellEditing();
        }
        int[] nArray = this.propertiesTable.getSelectedRows();
        int n = nArray.length;
        while (--n >= 0) {
            MWEisInteraction.ArgumentPair argumentPair = this.getEisInteraction().getProperty(nArray[n]);
            this.getEisInteraction().removeProperty(argumentPair);
        }
    }

    private JTable buildInputArgumentsTable() {
        this.inputArgumentsTable = SwingComponentFactory.buildTable(this.buildInputArgumentsTableModel());
        this.inputArgumentsTable.getSelectionModel().addListSelectionListener(this.buildListSelectionHandler());
        this.inputArgumentsTable.setAutoResizeMode(4);
        TableColumn tableColumn = this.inputArgumentsTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(122);
        TableColumn tableColumn2 = this.inputArgumentsTable.getColumnModel().getColumn(1);
        tableColumn2.setMinWidth(122);
        return this.inputArgumentsTable;
    }

    private String[] argumentColumnNameKeys() {
        return new String[]{"ARGUMENT_NAME_COLUMN_HEADER", "ARGUMENT_FIELD_NAME_COLUMN_HEADER"};
    }

    private String[] propertyColumnNameKeys() {
        return new String[]{"PROPERTY_NAME", "PROPERTY_VALUE"};
    }

    private TableModel buildInputArgumentsTableModel() {
        return new TableModelAdapter(this.buildInputArgumentsAdapter(), this.buildArgumentTableColumnAdapter(this.argumentColumnNameKeys()));
    }

    private ColumnAdapter buildArgumentTableColumnAdapter(String[] stringArray) {
        return new ArgumentColumnAdapter(this.resourceRepository(), stringArray);
    }

    private ListValueModel buildInputArgumentsAdapter() {
        return new ListAspectAdapter(this.eisInteractionHolder, "inputArguments"){

            protected ListIterator getValueFromSubject() {
                return ((MWEisInteraction)this.subject).inputArguments();
            }
        };
    }

    private JTable buildPropertiesTable() {
        this.propertiesTable = SwingComponentFactory.buildTable(this.buildPropertiesTableModel());
        this.propertiesTable.getSelectionModel().addListSelectionListener(this.buildListSelectionHandler());
        this.propertiesTable.setAutoResizeMode(4);
        return this.propertiesTable;
    }

    private TableModel buildPropertiesTableModel() {
        return new TableModelAdapter(this.buildPropertiesAdapter(), this.buildArgumentTableColumnAdapter(this.propertyColumnNameKeys()));
    }

    private ListValueModel buildPropertiesAdapter() {
        return new ListAspectAdapter(this.eisInteractionHolder, "properties"){

            protected ListIterator getValueFromSubject() {
                return ((MWEisInteraction)this.subject).properties();
            }
        };
    }

    private JTable buildOutputArgumentsTable() {
        this.outputArgumentsTable = SwingComponentFactory.buildTable(this.buildOutputArgumentsTableModel());
        this.outputArgumentsTable.getSelectionModel().addListSelectionListener(this.buildListSelectionHandler());
        this.outputArgumentsTable.setAutoResizeMode(4);
        return this.outputArgumentsTable;
    }

    private TableModel buildOutputArgumentsTableModel() {
        return new TableModelAdapter(this.buildOutputArgumentsAdapter(), this.buildArgumentTableColumnAdapter(this.argumentColumnNameKeys()));
    }

    private ListValueModel buildOutputArgumentsAdapter() {
        return new ListAspectAdapter(this.eisInteractionHolder, "outputArguments"){

            protected ListIterator getValueFromSubject() {
                return ((MWEisInteraction)this.subject).outputArguments();
            }
        };
    }

    public MWEisInteraction getEisInteraction() {
        return (MWEisInteraction)this.eisInteractionHolder.getValue();
    }

    public String helpTopicId() {
        return this.helpTopicId;
    }

    private class ButtonPane
    extends Pane {
        private JTable table;

        ButtonPane(JTable jTable, JButton jButton, JButton jButton2) {
            super(new GridLayout(1, 2, 5, 0));
            this.initialize(jTable, jButton, jButton2);
        }

        private void initialize(JTable jTable, JButton jButton, JButton jButton2) {
            this.table = jTable;
            this.add(jButton);
            this.add(jButton2);
        }

        protected void updateEnableStateOfChildren(boolean bl) {
            this.getComponent(0).setEnabled(bl);
            this.getComponent(1).setEnabled(bl && this.table.getSelectedRowCount() > 0);
        }
    }

    private static class ArgumentColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int ARGUMENT_NAME_COLUMN = 0;
        public static final int FIELD_NAME_COLUMN = 1;
        private String[] COLUMN_NAME_KEYS;

        protected ArgumentColumnAdapter(ResourceRepository resourceRepository, String[] stringArray) {
            this.resourceRepository = resourceRepository;
            this.COLUMN_NAME_KEYS = stringArray;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return true;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWEisInteraction.ArgumentPair argumentPair = (MWEisInteraction.ArgumentPair)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildArgumentNameAdapter(argumentPair), this.buildArgumentFieldNameAdapter(argumentPair)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildArgumentNameAdapter(MWEisInteraction.ArgumentPair argumentPair) {
            return new PropertyAspectAdapter("argumentName", (Model)argumentPair){

                protected Object getValueFromSubject() {
                    return ((MWEisInteraction.ArgumentPair)this.subject).getArgumentName();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWEisInteraction.ArgumentPair)this.subject).setArgumentName((String)object);
                }
            };
        }

        private PropertyValueModel buildArgumentFieldNameAdapter(MWEisInteraction.ArgumentPair argumentPair) {
            return new PropertyAspectAdapter("argumentFieldName", (Model)argumentPair){

                protected Object getValueFromSubject() {
                    return ((MWEisInteraction.ArgumentPair)this.subject).getArgumentFieldName();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWEisInteraction.ArgumentPair)this.subject).setArgumentFieldName((String)object);
                }
            };
        }
    }
}

