/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.EditableSchemaPropertiesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaDialogUtilities;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class EditSchemaDialog
extends AbstractValidatingDialog {
    private EditableSchemaPropertiesPanel schemaPanel;
    MWXmlSchema schema;
    private Action reimportAction;

    EditSchemaDialog(WorkbenchContext workbenchContext, MWXmlSchema mWXmlSchema) {
        super(workbenchContext);
        this.schema = mWXmlSchema;
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("EDIT_SCHEMA_DIALOG.TITLE"));
        this.setSize(550, 250);
        this.getOKAction().setEnabled(false);
    }

    protected Iterator buildCustomActions() {
        this.reimportAction = this.buildReimportAction();
        return new SingleElementIterator((Object)this.reimportAction);
    }

    private Action buildReimportAction() {
        AbstractAction abstractAction = new AbstractAction(this.buildReimportText()){

            public void actionPerformed(ActionEvent actionEvent) {
                EditSchemaDialog.this.reimportSchema();
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    protected String buildReimportText() {
        return this.resourceRepository().getString("EDIT_SCHEMA_DIALOG.REIMPORT_TEXT");
    }

    protected Component buildMainPanel() {
        this.schemaPanel = this.buildSchemaPanel();
        return this.schemaPanel;
    }

    private EditableSchemaPropertiesPanel buildSchemaPanel() {
        EditableSchemaPropertiesPanel editableSchemaPropertiesPanel = new EditableSchemaPropertiesPanel(this.buildSchemaRepositoryHolder(), (WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
        editableSchemaPropertiesPanel.populate(this.schema);
        editableSchemaPropertiesPanel.addPropertyChangeListener("SCHEMA_PROPERTY", this.buildSchemaPropertyChangeListener());
        return editableSchemaPropertiesPanel;
    }

    private PropertyValueModel buildSchemaRepositoryHolder() {
        return new AbstractReadOnlyPropertyValueModel(){

            public Object getValue() {
                return EditSchemaDialog.this.schema.schemaRepository();
            }
        };
    }

    private PropertyChangeListener buildSchemaPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditSchemaDialog.this.updateForErrors();
            }
        };
    }

    protected String helpTopicId() {
        return "dialog.schemaProperties";
    }

    public void promptToEditSchema() {
        this.show();
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.updateForErrors();
    }

    void updateForErrors() {
        boolean bl;
        boolean bl2 = bl = this.checkSchemaNameOk() && this.checkLoadMechanismOk();
        if (bl) {
            this.setErrorMessage(null);
        }
        this.reimportAction.setEnabled(bl);
        this.getOKAction().setEnabled(bl);
    }

    private boolean checkSchemaNameOk() {
        String string = this.schemaPanel.getSchemaName();
        if (StringTools.stringIsEmpty((String)string)) {
            this.setErrorMessage(this.resourceRepository().getString("SCHEMA_NAME_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        MWXmlSchema mWXmlSchema = this.schema.schemaRepository().getSchema(string);
        if (mWXmlSchema != null && mWXmlSchema != this.schema) {
            this.setErrorMessage(this.resourceRepository().getString("SCHEMA_NAME_NOT_UNIQUE_ERROR_MESSAGE"));
            return false;
        }
        MWXmlSchema mWXmlSchema2 = this.schema.schemaRepository().getSchemaIgnoreCase(string);
        if (mWXmlSchema2 != null && mWXmlSchema2 != this.schema) {
            this.setErrorMessage(this.resourceRepository().getString("SCHEMA_NAME_NOT_UNIQUE_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkLoadMechanismOk() {
        return this.checkFileMechanismOk() && this.checkUrlMechanismOk() && this.checkClasspathResourceMechanismOk();
    }

    private boolean checkFileMechanismOk() {
        String string;
        if (this.schemaPanel.isFileMechanism() && ((string = this.schemaPanel.getFileName()) == null || string.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("FILE_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkUrlMechanismOk() {
        String string;
        if (this.schemaPanel.isUrlMechanism() && ((string = this.schemaPanel.getUrl()) == null || string.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("URL_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkClasspathResourceMechanismOk() {
        String string;
        if (this.schemaPanel.isClasspathResourceMechanism() && ((string = this.schemaPanel.getClasspathResourceName()) == null || string.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("CLASSPATH_RESOURCE_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    protected void okConfirmed() {
        this.setSchemaValues();
        super.okConfirmed();
    }

    void reimportSchema() {
        this.setSchemaValues();
        this.startReloadSchemaThread();
    }

    private void setSchemaValues() {
        this.schema.setName(this.schemaPanel.getSchemaName());
        if (this.schemaPanel.isFileMechanism()) {
            this.schema.setFileSchemaLocation(this.schemaPanel.getFileName());
        } else if (this.schemaPanel.isUrlMechanism()) {
            this.schema.setUrlSchemaLocation(this.schemaPanel.getUrl());
        } else if (this.schemaPanel.isClasspathResourceMechanism()) {
            this.schema.setClasspathSchemaLocation(this.schemaPanel.getClasspathResourceName());
        }
    }

    void showUrlLoadFailure(String string, ResourceException resourceException) {
        if (this.schemaPanel.isFileMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, string, resourceException, "FILE_RESOURCE", this.schemaPanel.getFileName());
        } else if (this.schemaPanel.isUrlMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, string, resourceException, "URL_RESOURCE", this.schemaPanel.getUrl());
        } else if (this.schemaPanel.isClasspathResourceMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, string, resourceException, "CLASSPATH_RESOURCE", this.schemaPanel.getClasspathResourceName());
        }
        this.getOKAction().setEnabled(false);
    }

    void showSchemaLoadFailure(String string) {
        SchemaDialogUtilities.showSchemaLoadFailure((Component)this, string, null);
        this.getOKAction().setEnabled(false);
    }

    void showSchemaLoadFailure(String string, RuntimeException runtimeException) {
        SchemaDialogUtilities.showSchemaLoadFailure((Component)this, string, runtimeException);
        this.getOKAction().setEnabled(false);
    }

    private void startReloadSchemaThread() {
        Thread thread = new Thread((Runnable)new ReloadSchemaRunnable(), "XML Schema  Importation");
        thread.setPriority(3);
        thread.start();
    }

    private class ReloadSchemaRunnable
    implements Runnable {
        private WaitDialog waitDialog;

        ReloadSchemaRunnable() {
            this.initialize();
        }

        private void initialize() {
            this.waitDialog = new WaitDialog((Dialog)EditSchemaDialog.this.getWorkbenchContext().getCurrentWindow(), EditSchemaDialog.this.resourceRepository().getIcon("file.xml.large"), EditSchemaDialog.this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.TITLE"), EditSchemaDialog.this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.DESCRIPTION", EditSchemaDialog.this.schema.getName()));
        }

        private void showWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditSchemaDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    EditSchemaDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }

        private void hideWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditSchemaDialog.this.setCursor(Cursor.getDefaultCursor());
                    EditSchemaDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        private void disposeImportSchemaDialog() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    EditSchemaDialog.this.okConfirmed();
                }
            });
        }

        public void run() {
            try {
                this.reloadSchema();
                this.disposeImportSchemaDialog();
            }
            catch (ResourceException resourceException) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        EditSchemaDialog.this.showUrlLoadFailure(EditSchemaDialog.this.schema.getName(), resourceException);
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        EditSchemaDialog.this.showSchemaLoadFailure(EditSchemaDialog.this.schema.getName(), runtimeException);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reloadSchema() throws RuntimeException, ResourceException {
            this.showWaitCursor();
            AbstractDialog.launchLater(this.waitDialog);
            try {
                EditSchemaDialog.this.schema.reload();
            }
            finally {
                this.hideWaitCursor();
                this.waitDialog.dispose();
            }
        }
    }
}

