/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ClasspathResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.FileResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.UrlResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

final class EditableSchemaPropertiesPanel
extends AbstractPanel {
    private PropertyValueModel schemaRepositoryHolder;
    private PropertyValueModel schemaNameHolder;
    private PropertyValueModel schemaLoadMechanismHolder;
    private static final String FILE_MECHANISM = "file";
    private static final String CLASSPATH_MECHANISM = "classpath";
    private static final String URL_MECHANISM = "url";
    private PropertyValueModel fileHolder;
    private PropertyValueModel classpathResourceNameHolder;
    private PropertyValueModel urlHolder;
    public static final String SCHEMA_PROPERTY = "SCHEMA_PROPERTY";
    private static final long serialVersionUID = 1L;
    private static final String MOST_RECENT_SCHEMA_DIRECTORY_PREFERENCE = "recent schema directory";

    EditableSchemaPropertiesPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.schemaRepositoryHolder = propertyValueModel;
        this.initialize();
    }

    private void initialize() {
        this.schemaNameHolder = this.buildSchemaNameHolder();
        this.schemaLoadMechanismHolder = this.buildSchemaLoadMechanismHolder();
        this.fileHolder = this.buildFileHolder();
        this.classpathResourceNameHolder = this.buildClasspathResourceNameHolder();
        this.urlHolder = this.buildUrlHolder();
        this.initializeLayout();
    }

    private PropertyValueModel buildSchemaNameHolder() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("");
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildErrorListener());
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildSchemaLoadMechanismHolder() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(FILE_MECHANISM);
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildErrorListener());
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildFileHolder() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(null);
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildErrorListener());
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildFileListener());
        return simplePropertyValueModel;
    }

    private PropertyChangeListener buildFileListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                File file = new File((String)propertyChangeEvent.getNewValue());
                if ("".equals(EditableSchemaPropertiesPanel.this.getSchemaName()) && file.exists() && file.isFile()) {
                    EditableSchemaPropertiesPanel.this.setSchemaNameFromFile(file);
                }
            }
        };
    }

    private PropertyValueModel buildClasspathResourceNameHolder() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("");
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildErrorListener());
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildUrlHolder() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("");
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildErrorListener());
        return simplePropertyValueModel;
    }

    private PropertyChangeListener buildErrorListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditableSchemaPropertiesPanel.this.notifyErrorCheckers(propertyChangeEvent);
            }
        };
    }

    void notifyErrorCheckers(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(SCHEMA_PROPERTY, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.resourceRepository().getString("SCHEMA_NAME_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SCHEMA_NAME_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = this.buildSchemaNameTextField();
        this.addHelpTopicId(jTextField, "dialog.schemaProperties.name");
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)jTextField, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.addHelpTopicId(jTextField, "dialog.schemaProperties.source");
        jPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("SOURCE_PANEL_LABEL")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JRadioButton jRadioButton = this.buildFileRadioButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        FileChooserPanel fileChooserPanel = this.buildFileChooserPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, SwingTools.checkBoxIconWidth(), 10, 5);
        jPanel.add((Component)fileChooserPanel, gridBagConstraints);
        JRadioButton jRadioButton2 = this.buildUrlRadioButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        JTextField jTextField2 = this.buildUrlTextField();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, SwingTools.checkBoxIconWidth(), 10, 5);
        jPanel.add((Component)jTextField2, gridBagConstraints);
        JRadioButton jRadioButton3 = this.buildClasspathRadioButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        ClasspathResourcePanel classpathResourcePanel = this.buildClasspathResourcePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, SwingTools.checkBoxIconWidth(), 5, 5);
        jPanel.add((Component)classpathResourcePanel, gridBagConstraints);
        this.setPreferredSize(new Dimension(600, this.getPreferredSize().height));
    }

    private JTextField buildSchemaNameTextField() {
        JTextField jTextField = new JTextField(new DocumentAdapter(this.schemaNameHolder), null, 1);
        return jTextField;
    }

    private JRadioButton buildFileRadioButton() {
        return SwingComponentFactory.buildRadioButton("FILE_RADIO_BUTTON_LABEL", this.buildFileRadioButtonModel(), this.resourceRepository());
    }

    private RadioButtonModelAdapter buildFileRadioButtonModel() {
        return new RadioButtonModelAdapter(this.schemaLoadMechanismHolder, FILE_MECHANISM);
    }

    private FileChooserPanel buildFileChooserPanel() {
        FileChooserPanel fileChooserPanel = new FileChooserPanel(this.getApplicationContext(), this.fileHolder, "FILE_RADIO_BUTTON_LABEL"){

            protected boolean labelVisible() {
                return false;
            }
        };
        fileChooserPanel.setFileChooserFileFilter(this.buildFileFilter());
        fileChooserPanel.setFileChooserRootFileHolder(this.buildFileChooserRootFileHolder());
        fileChooserPanel.setEnabled(true);
        fileChooserPanel.setFileChooserDefaultDirectoryHolder(this.buildFileChooserDefaultDirectoryHolder(MOST_RECENT_SCHEMA_DIRECTORY_PREFERENCE));
        this.schemaLoadMechanismHolder.addPropertyChangeListener("value", this.buildLoadMechanismListener(fileChooserPanel, FILE_MECHANISM));
        return fileChooserPanel;
    }

    private FileFilter buildFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getAbsolutePath().endsWith(".xsd");
            }

            public String getDescription() {
                return EditableSchemaPropertiesPanel.this.resourceRepository().getString("XML_SCHEMA_DEFINITION_DESCRIPTION");
            }
        };
    }

    private MWXmlSchemaRepository schemaRepository() {
        return (MWXmlSchemaRepository)this.schemaRepositoryHolder.getValue();
    }

    MWProject project() {
        return this.schemaRepository().getProject();
    }

    private FileChooserPanel.FileHolder buildFileChooserRootFileHolder() {
        return new FileChooserPanel.FileHolder(){

            public File getFile() {
                return EditableSchemaPropertiesPanel.this.project().getSaveDirectory();
            }

            public void setFile(File file) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private FileChooserPanel.FileHolder buildFileChooserDefaultDirectoryHolder(final String string) {
        return new FileChooserPanel.FileHolder(){

            public File getFile() {
                File file = EditableSchemaPropertiesPanel.this.project().getSaveDirectory();
                if (file != null) {
                    return file;
                }
                String string2 = EditableSchemaPropertiesPanel.this.preferences().get(string, null);
                if (string2 != null) {
                    return new File(string2);
                }
                return FileTools.userHomeDirectory();
            }

            public void setFile(File file) {
                if (file.equals(FileTools.userHomeDirectory())) {
                    file = null;
                } else if (file.equals(EditableSchemaPropertiesPanel.this.project().getSaveDirectory())) {
                    file = null;
                }
                if (file == null) {
                    EditableSchemaPropertiesPanel.this.preferences().remove(string);
                } else {
                    EditableSchemaPropertiesPanel.this.preferences().put(string, file.getPath());
                }
            }
        };
    }

    private JRadioButton buildUrlRadioButton() {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setModel(this.buildUrlRadioButtonModel());
        jRadioButton.setText(this.resourceRepository().getString("URL_RADIO_BUTTON_LABEL"));
        jRadioButton.setMnemonic(this.resourceRepository().getMnemonic("URL_RADIO_BUTTON_LABEL"));
        return jRadioButton;
    }

    private RadioButtonModelAdapter buildUrlRadioButtonModel() {
        return new RadioButtonModelAdapter(this.schemaLoadMechanismHolder, URL_MECHANISM);
    }

    private JTextField buildUrlTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setEnabled(false);
        jTextField.setDocument(new DocumentAdapter(this.urlHolder));
        this.schemaLoadMechanismHolder.addPropertyChangeListener("value", this.buildLoadMechanismListener(jTextField, URL_MECHANISM));
        return jTextField;
    }

    private JRadioButton buildClasspathRadioButton() {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setModel(this.buildClasspathRadioButtonModel());
        jRadioButton.setText(this.resourceRepository().getString("CLASSPATH_RADIO_BUTTON_LABEL"));
        jRadioButton.setMnemonic(this.resourceRepository().getMnemonic("CLASSPATH_RADIO_BUTTON_LABEL"));
        return jRadioButton;
    }

    private RadioButtonModelAdapter buildClasspathRadioButtonModel() {
        return new RadioButtonModelAdapter(this.schemaLoadMechanismHolder, CLASSPATH_MECHANISM);
    }

    private ClasspathResourcePanel buildClasspathResourcePanel() {
        ClasspathResourcePanel classpathResourcePanel = new ClasspathResourcePanel(this.classpathResourceNameHolder);
        classpathResourcePanel.setEnabled(false);
        this.schemaLoadMechanismHolder.addPropertyChangeListener("value", this.buildLoadMechanismListener(classpathResourcePanel, CLASSPATH_MECHANISM));
        return classpathResourcePanel;
    }

    private PropertyChangeListener buildLoadMechanismListener(final Component component, final String string) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(propertyChangeEvent.getNewValue() == string);
            }
        };
    }

    String getSchemaName() {
        return (String)this.schemaNameHolder.getValue();
    }

    void setSchemaNameFromFile(File file) {
        String string = file.getName();
        if (string.lastIndexOf(".") != -1) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        this.schemaNameHolder.setValue(string);
    }

    boolean isFileMechanism() {
        return this.schemaLoadMechanismHolder.getValue() == FILE_MECHANISM;
    }

    String getFileName() {
        return (String)this.fileHolder.getValue();
    }

    boolean isUrlMechanism() {
        return this.schemaLoadMechanismHolder.getValue() == URL_MECHANISM;
    }

    String getUrl() {
        return (String)this.urlHolder.getValue();
    }

    boolean isClasspathResourceMechanism() {
        return this.schemaLoadMechanismHolder.getValue() == CLASSPATH_MECHANISM;
    }

    String getClasspathResourceName() {
        return (String)this.classpathResourceNameHolder.getValue();
    }

    void populate(MWXmlSchema mWXmlSchema) {
        this.schemaNameHolder.setValue(mWXmlSchema.getName());
        ResourceSpecification resourceSpecification = mWXmlSchema.getSchemaSource();
        if (resourceSpecification instanceof FileResourceSpecification) {
            this.schemaLoadMechanismHolder.setValue(FILE_MECHANISM);
            this.fileHolder.setValue(resourceSpecification.getLocation());
        } else if (resourceSpecification instanceof UrlResourceSpecification) {
            this.schemaLoadMechanismHolder.setValue(URL_MECHANISM);
            this.urlHolder.setValue(resourceSpecification.getLocation());
        }
        if (resourceSpecification instanceof ClasspathResourceSpecification) {
            this.schemaLoadMechanismHolder.setValue(CLASSPATH_MECHANISM);
            this.classpathResourceNameHolder.setValue(resourceSpecification.getLocation());
        }
    }

    private class ClasspathResourcePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private ClasspathResourcePanel(PropertyValueModel propertyValueModel) {
            this.initialize(propertyValueModel);
        }

        private void initialize(PropertyValueModel propertyValueModel) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(EditableSchemaPropertiesPanel.this.resourceRepository().getString("RESOURCE_NAME_LABEL"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            JTextField jTextField = this.buildResourceNameTextField(jLabel, propertyValueModel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)jTextField, gridBagConstraints);
            jLabel.setLabelFor(jTextField);
        }

        private JTextField buildResourceNameTextField(JLabel jLabel, PropertyValueModel propertyValueModel) {
            JTextField jTextField = new JTextField();
            jTextField.setDocument(new DocumentAdapter(propertyValueModel));
            jTextField.setPreferredSize(new Dimension(200, (int)jTextField.getPreferredSize().getHeight()));
            jLabel.setLabelFor(jTextField);
            return jTextField;
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            Iterator iterator = CollectionTools.iterator((Object[])this.getComponents());
            while (iterator.hasNext()) {
                ((Component)iterator.next()).setEnabled(bl);
            }
        }
    }
}

