/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.LocalSchemaComponentNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCurator;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

abstract class SchemaComponentNode
extends AbstractTreeNodeValueModel
implements Displayable {
    private AbstractTreeNodeValueModel parent;
    protected MWSchemaComponent component;
    private ListValueModel childrenModel;
    protected SchemaComponentNodeStructure structure;

    SchemaComponentNode(AbstractTreeNodeValueModel abstractTreeNodeValueModel, MWSchemaComponent mWSchemaComponent) {
        this.parent = abstractTreeNodeValueModel;
        this.initialize(mWSchemaComponent);
    }

    protected void initialize(MWSchemaComponent mWSchemaComponent) {
        this.component = mWSchemaComponent;
        this.childrenModel = this.buildChildrenModel();
        this.structure = this.buildStructure(mWSchemaComponent);
    }

    protected ListValueModel buildChildrenModel() {
        return new TransformationListValueModelAdapter(this.buildStructuralComponentsAdapter()){

            protected Object transformItem(Object object) {
                return SchemaComponentNode.this.buildLocalComponentNode((MWSchemaComponent)object);
            }
        };
    }

    protected ListValueModel buildStructuralComponentsAdapter() {
        return new ListCurator((Model)this.component){

            public Iterator getValueForRecord() {
                return ((MWSchemaComponent)this.subject).structuralComponents();
            }
        };
    }

    protected SchemaComponentNode buildLocalComponentNode(MWSchemaComponent mWSchemaComponent) {
        return new LocalSchemaComponentNode(this, mWSchemaComponent);
    }

    protected abstract SchemaComponentNodeStructure buildStructure(MWSchemaComponent var1);

    protected PropertyChangeListener buildDisplayStringChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SchemaComponentNode.this.fireStateChanged();
            }
        };
    }

    protected ListIterator details() {
        return this.structure.details();
    }

    public TreeNodeValueModel getParent() {
        return this.parent;
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    protected void engageValue() {
    }

    protected void disengageValue() {
        this.structure.disengageComponent();
    }

    public Object getValue() {
        return this.component;
    }

    public String displayString() {
        return this.structure.displayString();
    }

    public Icon icon() {
        return null;
    }

    public int compareTo(Object object) {
        return DEFAULT_COMPARATOR.compare(this, object);
    }
}

