/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.UiSchemaResourceBundle;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class SchemaDialogUtilities {
    private static ResourceRepository resourceRepository;

    SchemaDialogUtilities() {
    }

    private static ResourceRepository resourceRepository() {
        if (resourceRepository == null) {
            resourceRepository = SchemaDialogUtilities.buildResourceRepository();
        }
        return resourceRepository;
    }

    private static ResourceRepository buildResourceRepository() {
        return new DefaultResourceRepository(UiSchemaResourceBundle.class);
    }

    static void showUrlLoadFailure(Component component, String string, ResourceException resourceException, ResourceSpecification resourceSpecification) {
        SchemaDialogUtilities.showUrlLoadFailure(component, string, resourceException, resourceSpecification.getSourceKey(), resourceSpecification.getLocation());
    }

    static void showUrlLoadFailure(Component component, String string, ResourceException resourceException, String string2, String string3) {
        String string4 = SchemaDialogUtilities.resourceRepository().getString("URL_LOAD_ERROR.TITLE");
        String string5 = resourceException.getCode();
        String string6 = SchemaDialogUtilities.resourceRepository().getString("URL_LOAD_ERROR.MESSAGE", string);
        string6 = string6 + StringTools.CR;
        string6 = string6 + SchemaDialogUtilities.resourceRepository().getString("URL_LOAD_ERROR." + string2 + "." + string5, new Object[]{string3});
        JOptionPane.showMessageDialog(component, string6, string4, 2);
    }

    static void showSchemaLoadFailure(Component component, String string) {
        SchemaDialogUtilities.showSchemaLoadFailure(component, string, null);
    }

    static void showSchemaLoadFailure(Component component, String string, RuntimeException runtimeException) {
        SchemaDialogUtilities.showSchemaLoadFailure(component, string, (Exception)runtimeException);
    }

    private static void showSchemaLoadFailure(Component component, String string, Exception exception) {
        String string2 = SchemaDialogUtilities.resourceRepository().getString("SCHEMA_LOAD_ERROR.TITLE");
        String string3 = exception.getLocalizedMessage();
        String string4 = SchemaDialogUtilities.resourceRepository().getString("SCHEMA_LOAD_ERROR.MESSAGE", StringTools.CR, string, string3);
        LabelArea labelArea = new LabelArea(string4);
        JOptionPane.showMessageDialog(component, labelArea, string2, 2);
    }

    static void reloadSchemas(WorkbenchContext workbenchContext, Iterator iterator) {
        Thread thread = new Thread((Runnable)new ReloadAllSchemasRunnable(workbenchContext, iterator), "XML Schema  Importation");
        thread.setPriority(3);
        thread.start();
    }

    private static class ReloadAllSchemasRunnable
    implements Runnable {
        private WorkbenchContext context;
        private WaitDialog waitDialog;
        private Iterator schemasIterator;
        private MWXmlSchema[] currentSchema;

        ReloadAllSchemasRunnable(WorkbenchContext workbenchContext, Iterator iterator) {
            this.initialize(workbenchContext, iterator);
        }

        private void initialize(WorkbenchContext workbenchContext, Iterator iterator) {
            this.currentSchema = new MWXmlSchema[1];
            this.context = workbenchContext;
            this.schemasIterator = iterator;
            this.waitDialog = new WaitDialog((Frame)workbenchContext.getCurrentWindow(), workbenchContext.getApplicationContext().getResourceRepository().getIcon("file.xml.large"), SchemaDialogUtilities.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.TITLE"), SchemaDialogUtilities.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.DESCRIPTION", ""));
        }

        private void showWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ReloadAllSchemasRunnable.this.context.getCurrentWindow().setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }

        private void hideWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ReloadAllSchemasRunnable.this.context.getCurrentWindow().setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        private void updateMessage() throws InvocationTargetException, InterruptedException {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    String string = SchemaDialogUtilities.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.DESCRIPTION", ReloadAllSchemasRunnable.this.currentSchema[0].getName());
                    ReloadAllSchemasRunnable.this.waitDialog.setMessage(string);
                }
            });
        }

        private Runnable buildWaitDialogLauncher() {
            return new Runnable(){

                public void run() {
                    ReloadAllSchemasRunnable.this.waitDialog.setVisible(true);
                }
            };
        }

        public void run() {
            try {
                if (this.currentSchema[0] == null) {
                    this.showWaitCursor();
                }
                EventQueue.invokeLater(this.buildWaitDialogLauncher());
                while (this.schemasIterator.hasNext()) {
                    this.currentSchema[0] = (MWXmlSchema)this.schemasIterator.next();
                    this.updateMessage();
                    this.currentSchema[0].reload();
                }
                this.waitDialog.dispose();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.waitDialog.dispose();
                throw new RuntimeException(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                this.waitDialog.dispose();
                throw new RuntimeException(interruptedException);
            }
            catch (ResourceException resourceException) {
                this.waitDialog.dispose();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SchemaDialogUtilities.showUrlLoadFailure(ReloadAllSchemasRunnable.this.context.getCurrentWindow(), ReloadAllSchemasRunnable.this.currentSchema[0].getName(), resourceException, ReloadAllSchemasRunnable.this.currentSchema[0].getSchemaSource());
                    }
                });
                this.run();
            }
            catch (RuntimeException runtimeException) {
                this.waitDialog.dispose();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SchemaDialogUtilities.showSchemaLoadFailure((Component)ReloadAllSchemasRunnable.this.context.getCurrentWindow(), ReloadAllSchemasRunnable.this.currentSchema[0].getName(), runtimeException);
                    }
                });
                this.run();
            }
            this.hideWaitCursor();
        }
    }
}

