/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetailsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaNode;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;

class SchemaStructurePanel
extends AbstractPropertiesPage {
    private PropertyValueModel selectedSchemaComponentHolder;
    private JTree tree;

    SchemaStructurePanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.selectedSchemaComponentHolder = this.buildSelectedSchemaComponentHolder();
        propertyValueModel.addPropertyChangeListener(this.buildNodeListener());
    }

    private PropertyValueModel buildSelectedSchemaComponentHolder() {
        return new FilteringPropertyValueModel(new SimplePropertyValueModel()){

            protected boolean accept(Object object) {
                return object instanceof SchemaComponentNode;
            }
        };
    }

    protected void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildSplitPane(), "Center");
        this.addHelpTopicId(this, "schema.structure");
    }

    private JSplitPane buildSplitPane() {
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDoubleBuffered(true);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setDividerLocation(350);
        SwingTools.setSplitPaneDividerBorder(jSplitPane, BorderFactory.createEmptyBorder());
        jSplitPane.setDividerSize(3);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setTopComponent(this.buildTreePanel());
        JPanel jPanel = this.buildSchemaComponentPropertiesPanel();
        jSplitPane.setBottomComponent(new JScrollPane(jPanel, 21, 31));
        return jSplitPane;
    }

    protected JPanel buildTreePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildTreePane(), "Center");
        return jPanel;
    }

    private JScrollPane buildTreePane() {
        return new JScrollPane(this.buildTree());
    }

    private JTree buildTree() {
        this.tree = SwingComponentFactory.buildTree(this.buildSchemaTreeModel());
        this.tree.setSelectionModel(this.buildTreeSelectionModel());
        this.tree.setCellRenderer(this.buildTreeCellRenderer());
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(20);
        this.tree.setDoubleBuffered(true);
        return this.tree;
    }

    private TreeModelAdapter buildSchemaTreeModel() {
        return new TreeModelAdapter(this.buildSchemaTreeRoot());
    }

    private SchemaNode buildSchemaTreeRoot() {
        return new SchemaNode(this.getSelectionHolder());
    }

    private TreeSelectionModel buildTreeSelectionModel() {
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        defaultTreeSelectionModel.addTreeSelectionListener(this.buildTreeSelectionListener(defaultTreeSelectionModel));
        return defaultTreeSelectionModel;
    }

    private TreeSelectionListener buildTreeSelectionListener(final TreeSelectionModel treeSelectionModel) {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = treeSelectionModel.getSelectionCount() == 1 ? treeSelectionModel.getSelectionPath().getLastPathComponent() : null;
                SchemaStructurePanel.this.selectedSchemaComponentHolder.setValue(object);
            }
        };
    }

    private DefaultTreeCellRenderer buildTreeCellRenderer() {
        return new DisplayableTreeCellRenderer();
    }

    private JPanel buildSchemaComponentPropertiesPanel() {
        return new SchemaComponentDetailsPanel(this.getApplicationContext(), this.selectedSchemaComponentHolder);
    }

    private PropertyChangeListener buildNodeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SchemaStructurePanel.this.resetNode((ApplicationNode)propertyChangeEvent.getNewValue());
            }
        };
    }

    private void resetNode(ApplicationNode applicationNode) {
        if (applicationNode == null) {
            this.tree.setModel(null);
        } else {
            this.tree.setModel(this.buildSchemaTreeModel());
        }
    }
}

