/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.EditSchemaDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaDialogUtilities;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaRepositoryNode;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class XmlSchemaNode
extends MappingsApplicationNode
implements RemovableNode {
    Map propertiesPages;
    private WindowListener windowListener;
    protected static final String[] SCHEMA_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};

    public XmlSchemaNode(MWXmlSchema mWXmlSchema, XmlSchemaRepositoryNode xmlSchemaRepositoryNode) {
        this(mWXmlSchema, xmlSchemaRepositoryNode.getApplicationContext(), xmlSchemaRepositoryNode.getPlugin(), xmlSchemaRepositoryNode);
    }

    private XmlSchemaNode(MWXmlSchema mWXmlSchema, ApplicationContext applicationContext, Plugin plugin, XmlSchemaRepositoryNode xmlSchemaRepositoryNode) {
        super((MWModel)mWXmlSchema, (TreeNodeValueModel)xmlSchemaRepositoryNode, plugin, applicationContext);
    }

    protected void initialize() {
        super.initialize();
        this.propertiesPages = new HashMap();
        this.windowListener = this.buildWindowListener();
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                XmlSchemaNode.this.disposePropertiesPage(windowEvent.getWindow());
            }
        };
    }

    FrameworkAction getReimportSchemaAction(WorkbenchContext workbenchContext) {
        return new ReimportSchemaAction(workbenchContext);
    }

    FrameworkAction getSchemaPropertiesAction(WorkbenchContext workbenchContext) {
        return new SchemaPropertiesAction(workbenchContext);
    }

    public Component propertiesPage(WorkbenchContext workbenchContext) {
        Window window = workbenchContext.getCurrentWindow();
        Component component = (Component)this.propertiesPages.get(window);
        if (component == null) {
            component = this.buildPropertiesPage(this.buildLocalWorkbenchContext(workbenchContext));
            this.propertiesPages.put(window, component);
            window.addWindowListener(this.windowListener);
        }
        return component;
    }

    protected AbstractPropertiesPage buildPropertiesPage(WorkbenchContext workbenchContext) {
        return new XmlSchemaPanel(this, workbenchContext);
    }

    protected void releasePropertiesPage(AbstractPropertiesPage abstractPropertiesPage) {
    }

    void disposePropertiesPages() {
        Iterator iterator = this.propertiesPages.keySet().iterator();
        while (iterator.hasNext()) {
            this.disposePropertiesPage((Window)iterator.next());
        }
        this.propertiesPages.clear();
    }

    void disposePropertiesPage(Window window) {
        XmlSchemaPanel xmlSchemaPanel = (XmlSchemaPanel)this.propertiesPages.remove(window);
        xmlSchemaPanel.setNode(null, this.buildShellWorkbenchContext());
        window.removeWindowListener(this.windowListener);
    }

    protected String buildDisplayString() {
        return this.getSchema().getName();
    }

    protected String buildIconKey() {
        return "file.xml";
    }

    protected String[] displayStringPropertyNames() {
        return SCHEMA_DISPLAY_STRING_PROPERTY_NAMES;
    }

    public String helpTopicID() {
        return "xmlSchema";
    }

    MWXmlSchema getSchema() {
        return (MWXmlSchema)this.getValue();
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getReimportSchemaAction(workbenchContext2));
        menuGroupDescription.add(this.getSchemaPropertiesAction(workbenchContext2));
        menuGroupDescription.add(this.getMappingsPlugin().getRemoveAction(workbenchContext2));
        rootMenuDescription.add(menuGroupDescription);
        rootMenuDescription.add(this.buildOracleHelpMenuGroup(workbenchContext2));
        return rootMenuDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription.add(this.getReimportSchemaAction(this.buildLocalWorkbenchContext(workbenchContext)));
        toolBarDescription.add(toolBarButtonGroupDescription);
        return toolBarDescription;
    }

    public String getName() {
        return this.getSchema().getName();
    }

    public void remove() {
        this.getSchema().schemaRepository().removeSchema(this.getSchema());
    }

    private final class SchemaPropertiesAction
    extends AbstractFrameworkAction {
        private SchemaPropertiesAction(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected void initialize() {
            this.setIcon(EMPTY_ICON);
            this.initializeTextAndMnemonic("SCHEMA_PROPERTIES_ACTION");
            this.initializeToolTipText("SCHEMA_PROPERTIES_ACTION.TOOL_TIP");
            this.setEnabled(true);
        }

        protected void execute(ApplicationNode applicationNode) {
            new EditSchemaDialog(this.getWorkbenchContext(), ((XmlSchemaNode)applicationNode).getSchema()).promptToEditSchema();
            this.navigatorSelectionModel().setSelectedNode(applicationNode);
        }
    }

    private final class ReimportSchemaAction
    extends AbstractFrameworkAction {
        private ReimportSchemaAction(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected void initialize() {
            this.initializeTextAndMnemonic("REIMPORT_SCHEMA_ACTION");
            this.initializeToolTipText("REIMPORT_SCHEMA_ACTION.TOOL_TIP");
            this.initializeIcon("file.xml.refresh");
            this.setEnabled(true);
        }

        protected void execute() {
            Iterator iterator = CollectionTools.iterator((Object[])this.selectedNodes());
            TransformationIterator transformationIterator = new TransformationIterator(iterator){

                protected Object transform(Object object) {
                    return ((XmlSchemaNode)object).getSchema();
                }
            };
            SchemaDialogUtilities.reloadSchemas(this.getWorkbenchContext(), (Iterator)transformationIterator);
        }
    }
}

