/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.XmlProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ImportSchemaDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaDialogUtilities;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.UiSchemaResourceBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaRepositoryPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class XmlSchemaRepositoryNode
extends MappingsApplicationNode
implements ProjectNode.Child {
    private ListValueModel childrenModel;

    public XmlSchemaRepositoryNode(MWXmlSchemaRepository mWXmlSchemaRepository, XmlProjectNode xmlProjectNode) {
        this(mWXmlSchemaRepository, xmlProjectNode.getApplicationContext(), xmlProjectNode.getPlugin(), xmlProjectNode);
    }

    private XmlSchemaRepositoryNode(MWXmlSchemaRepository mWXmlSchemaRepository, ApplicationContext applicationContext, Plugin plugin, XmlProjectNode xmlProjectNode) {
        super((MWModel)mWXmlSchemaRepository, (TreeNodeValueModel)xmlProjectNode, plugin, applicationContext);
    }

    protected ApplicationContext expandContext(ApplicationContext applicationContext) {
        return super.expandContext(applicationContext).buildExpandedResourceRepositoryContext(UiSchemaResourceBundle.class);
    }

    public int getProjectNodeChildPriority() {
        return 1;
    }

    private FrameworkAction getImportSchemaAction(WorkbenchContext workbenchContext) {
        return new ImportSchemaAction(workbenchContext);
    }

    private FrameworkAction getReimportAllSchemasAction(WorkbenchContext workbenchContext) {
        return new ReimportAllSchemasAction(workbenchContext);
    }

    public ListValueModel getChildrenModel() {
        if (this.childrenModel == null) {
            this.childrenModel = this.buildChildrenModel();
        }
        return this.childrenModel;
    }

    protected ListValueModel buildChildrenModel() {
        SortedListValueModelAdapter sortedListValueModelAdapter = new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
        sortedListValueModelAdapter.addListChangeListener("value", this.buildChildrenModelListener());
        return sortedListValueModelAdapter;
    }

    private ListChangeListener buildChildrenModelListener() {
        return new ListChangeAdapter(){

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                ListIterator listIterator = listChangeEvent.items();
                while (listIterator.hasNext()) {
                    ((XmlSchemaNode)listIterator.next()).disposePropertiesPages();
                }
            }
        };
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildNodeWrapperAdapter(), "displayString");
    }

    protected ListValueModel buildNodeWrapperAdapter() {
        return new TransformationListValueModelAdapter(this.buildNodeChildrenAdapter()){

            protected Object transformItem(Object object) {
                return new XmlSchemaNode((MWXmlSchema)object, XmlSchemaRepositoryNode.this);
            }
        };
    }

    protected CollectionValueModel buildNodeChildrenAdapter() {
        return new CollectionAspectAdapter(this, "schemas"){

            protected Iterator getValueFromSubject() {
                return ((MWXmlSchemaRepository)this.subject).schemas();
            }

            protected int sizeFromSubject() {
                return ((MWXmlSchemaRepository)this.subject).schemasSize();
            }
        };
    }

    public String helpTopicID() {
        return "xmlSchemaRepository";
    }

    protected String buildDisplayString() {
        return this.resourceRepository().getString("SCHEMA_REPOSITORY_NODE_DISPLAY_STRING");
    }

    protected String buildIconKey() {
        return "file.xml.multi";
    }

    protected Class propertiesPageClass() {
        return XmlSchemaRepositoryPanel.class;
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getImportSchemaAction(workbenchContext2));
        menuGroupDescription.add(this.getReimportAllSchemasAction(workbenchContext2));
        rootMenuDescription.add(menuGroupDescription);
        rootMenuDescription.add(this.buildOracleHelpMenuGroup(workbenchContext2));
        return rootMenuDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription.add(this.getImportSchemaAction(workbenchContext2));
        toolBarButtonGroupDescription.add(this.getReimportAllSchemasAction(workbenchContext2));
        toolBarDescription.add(toolBarButtonGroupDescription);
        return toolBarDescription;
    }

    MWXmlSchemaRepository getSchemaRepository() {
        return (MWXmlSchemaRepository)this.getValue();
    }

    private final class ReimportAllSchemasAction
    extends AbstractFrameworkAction {
        private ReimportAllSchemasAction(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected void initialize() {
            this.initializeTextAndMnemonic("REIMPORT_ALL_SCHEMAS_ACTION");
            this.initializeToolTipText("REIMPORT_ALL_SCHEMAS_ACTION");
            this.initializeIcon("file.xml.multi.refresh");
            this.setEnabled(true);
        }

        protected void execute(ApplicationNode applicationNode) {
            Iterator iterator = ((XmlSchemaRepositoryNode)applicationNode).getSchemaRepository().schemas();
            if (iterator.hasNext()) {
                SchemaDialogUtilities.reloadSchemas(this.getWorkbenchContext(), iterator);
            }
        }
    }

    private final class ImportSchemaAction
    extends AbstractFrameworkAction {
        private ImportSchemaAction(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected void initialize() {
            this.initializeTextAndMnemonic("IMPORT_SCHEMA_ACTION");
            this.initializeToolTipText("IMPORT_SCHEMA_ACTION.TOOL_TIP");
            this.initializeIcon("file.xml.new");
            this.setEnabled(true);
        }

        protected void execute(ApplicationNode applicationNode) {
            MWXmlSchema mWXmlSchema = new ImportSchemaDialog(this.getWorkbenchContext(), ((XmlSchemaRepositoryNode)applicationNode).getSchemaRepository()).promptToImportSchema();
            if (mWXmlSchema != null) {
                this.navigatorSelectionModel().setSelectedNode(applicationNode.descendantNodeForValue((Node)mWXmlSchema));
            }
        }
    }
}

