/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.UiSchemaResourceBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaDisplayableAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.UiXmlBundle;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;

class XmlSchemaRepositoryPanel
extends TitledPropertiesPage {
    private static final Class[] REQUIRED_RESOURCE_BUNDLES = new Class[]{UiCommonBundle.class, UiXmlBundle.class, UiSchemaResourceBundle.class};

    XmlSchemaRepositoryPanel(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JList jList = SwingComponentFactory.buildList();
        jList.setBackground(UIManager.getColor("Panel.background"));
        jList.setSelectionBackground(UIManager.getColor("Panel.background"));
        jList.setCellRenderer(new DisplayableListCellRenderer());
        jList.setModel(this.buildSchemasListModel());
        jPanel.add((Component)jList, "Center");
        return jPanel;
    }

    private ListModel buildSchemasListModel() {
        return new ListModelAdapter(this.buildUpdatingSortedDisplayableSchemasValueModel());
    }

    private ListValueModel buildUpdatingSortedDisplayableSchemasValueModel() {
        return new SortedListValueModelAdapter(this.buildUpdatingDisplayableSchemasValueModel());
    }

    private ListValueModel buildUpdatingDisplayableSchemasValueModel() {
        return new ItemPropertyListValueModelAdapter(this.buildDisplayableSchemasValueModel(), "displayString");
    }

    private ListValueModel buildDisplayableSchemasValueModel() {
        return new TransformationListValueModelAdapter(this.buildSchemasValueModel()){

            protected Object transformItem(Object object) {
                return new XmlSchemaDisplayableAdapter((MWXmlSchema)object, XmlSchemaRepositoryPanel.this.resourceRepository());
            }
        };
    }

    private CollectionValueModel buildSchemasValueModel() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "schemas"){

            protected Iterator getValueFromSubject() {
                return ((MWXmlSchemaRepository)this.subject).schemas();
            }

            protected int sizeFromSubject() {
                return ((MWXmlSchemaRepository)this.subject).schemasSize();
            }
        };
    }
}

