/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaComplexTypeChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class SchemaComplexTypeChooser
extends AbstractPanel {
    private SchemaValue schemaValue;
    private PropertyValueModel complexTypeHolder;
    private ComplexTypeDisplayStringValueModel complexTypeDisplayStringHolder;

    public SchemaComplexTypeChooser(WorkbenchContextHolder workbenchContextHolder, SchemaValue schemaValue, PropertyValueModel propertyValueModel, JLabel jLabel) {
        super(workbenchContextHolder);
        this.initialize(schemaValue, propertyValueModel, jLabel);
    }

    private void initialize(SchemaValue schemaValue, PropertyValueModel propertyValueModel, JLabel jLabel) {
        this.schemaValue = schemaValue;
        this.complexTypeHolder = propertyValueModel;
        this.complexTypeDisplayStringHolder = this.buildComplexTypeDisplayStringHolder();
        this.initializeLayout(jLabel);
    }

    private ComplexTypeDisplayStringValueModel buildComplexTypeDisplayStringHolder() {
        return new ComplexTypeDisplayStringValueModel(this.complexTypeHolder);
    }

    private void initializeLayout(JLabel jLabel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextField jTextField = this.buildTextField();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        jTextField.putClientProperty("labeledBy", jLabel);
        JButton jButton = this.buildButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.addAlignRight(jButton);
        jLabel.setLabelFor(jButton);
        SwingComponentFactory.updateButtonAccessibleName(jLabel, jButton);
        this.add((Component)jButton, gridBagConstraints);
    }

    private JTextField buildTextField() {
        JTextField jTextField = new JTextField(this.buildComplexTypeDisplayStringDocument(), null, 1);
        jTextField.setEditable(true);
        jTextField.setEnabled(true);
        return jTextField;
    }

    private DocumentAdapter buildComplexTypeDisplayStringDocument() {
        return new DocumentAdapter(this.complexTypeDisplayStringHolder);
    }

    private JButton buildButton() {
        JButton jButton = this.buildButton("SCHEMA_COMPLEX_TYPE_CHOOSER_BROWSE_BUTTON");
        jButton.addActionListener(this.buildBrowseAction());
        return jButton;
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaComplexTypeChooser.this.promptToComplexTypeElement();
            }
        };
    }

    private void promptToComplexTypeElement() {
        SchemaComplexTypeChooserDialog schemaComplexTypeChooserDialog = new SchemaComplexTypeChooserDialog(this.getWorkbenchContext(), this.schemaValue.schema(), this.complexTypeHolder);
        schemaComplexTypeChooserDialog.show();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Iterator iterator = CollectionTools.iterator((Object[])this.getComponents());
        while (iterator.hasNext()) {
            ((Component)iterator.next()).setEnabled(bl);
        }
    }

    private class ComplexTypeDisplayStringValueModel
    extends PropertyValueModelWrapper {
        private String displayString;
        private PropertyChangeListener propertyChangeListener;
        private MWNamespace namespace;

        private ComplexTypeDisplayStringValueModel(PropertyValueModel propertyValueModel) {
            super(propertyValueModel);
        }

        protected void initialize() {
            super.initialize();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ComplexTypeDisplayStringValueModel.this.displayStringChanged();
                }
            };
        }

        private MWComplexTypeDefinition type() {
            return (MWComplexTypeDefinition)this.valueHolder.getValue();
        }

        private void displayStringChanged() {
            Object object = this.getValue();
            this.synchronizeDisplayString();
            Object object2 = this.getValue();
            this.firePropertyChanged("value", object, object2);
        }

        private void synchronizeDisplayString() {
            this.displayString = this.type() == null ? SchemaComplexTypeChooser.this.resourceRepository().getString("SCHEMA_COMPLEX_TYPE_CHOOSER_NONE_SELECTED_TEXT") : this.buildDisplayString(this.type());
        }

        private String buildDisplayString(MWComplexTypeDefinition mWComplexTypeDefinition) {
            return mWComplexTypeDefinition.qName();
        }

        private void engageNewType() {
            if (this.type() != null) {
                this.namespace = this.type().getTargetNamespace();
                this.namespace.addPropertyChangeListener("namespacePrefix", this.propertyChangeListener);
            }
        }

        private void disengageOldType() {
            if (this.namespace != null) {
                this.namespace.removePropertyChangeListener("namespacePrefix", this.propertyChangeListener);
                this.namespace = null;
            }
        }

        public Object getValue() {
            return this.displayString;
        }

        public void setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.engageNewType();
            this.synchronizeDisplayString();
        }

        protected void disengageValueHolder() {
            this.disengageOldType();
            super.disengageValueHolder();
            this.synchronizeDisplayString();
        }

        protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
            this.disengageOldType();
            this.engageNewType();
            this.displayStringChanged();
        }
    }
}

