/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaContextComponentDisplayer;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaRepositoryValue;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class SchemaContextChooserDialog
extends AbstractDialog {
    private SchemaRepositoryValue schemaRepositoryValue;
    private PropertyValueModel schemaComponentHolder;
    private PropertyValueModel selectedSchemaComponentHolder;
    private TreeSelectionModel schemaContextTreeSelectionModel;

    SchemaContextChooserDialog(WorkbenchContext workbenchContext, SchemaRepositoryValue schemaRepositoryValue, PropertyValueModel propertyValueModel) {
        super(workbenchContext);
        this.initialize(schemaRepositoryValue, propertyValueModel);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.TITLE"));
    }

    private void initialize(SchemaRepositoryValue schemaRepositoryValue, PropertyValueModel propertyValueModel) {
        this.schemaRepositoryValue = schemaRepositoryValue;
        this.schemaComponentHolder = propertyValueModel;
        this.selectedSchemaComponentHolder = this.buildSelectedSchemaComponentHolder();
        this.schemaContextTreeSelectionModel = this.buildSchemaContextTreeSelectionModel();
    }

    private PropertyValueModel buildSelectedSchemaComponentHolder() {
        return new SimplePropertyValueModel(null);
    }

    private TreeSelectionModel buildSchemaContextTreeSelectionModel() {
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        defaultTreeSelectionModel.addTreeSelectionListener(this.buildTreeSelectionListener());
        return defaultTreeSelectionModel;
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SchemaContextChooserDialog.this.schemaContextTreeSelectionChanged();
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setPreferredSize(new Dimension(400, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.buildSchemaContextTreePane(), gridBagConstraints);
        JLabel jLabel = this.buildSchemaContextPreviewLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = this.buildSchemaContextPreviewTextField();
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        return jPanel;
    }

    private JScrollPane buildSchemaContextTreePane() {
        return new JScrollPane(this.buildSchemaContextTree());
    }

    private JTree buildSchemaContextTree() {
        JTree jTree = SwingComponentFactory.buildTree(this.buildSchemaContextTreeModel());
        jTree.setSelectionModel(this.schemaContextTreeSelectionModel);
        jTree.setCellRenderer(this.buildTreeCellRenderer());
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setRowHeight(20);
        jTree.setDoubleBuffered(true);
        jTree.expandRow(0);
        return jTree;
    }

    private TreeModelAdapter buildSchemaContextTreeModel() {
        return new TreeModelAdapter(this.buildSchemaContextTreeRoot());
    }

    private SchemaRepositoryNode buildSchemaContextTreeRoot() {
        return new SchemaRepositoryNode(this.schemaRepositoryValue);
    }

    private TreeCellRenderer buildTreeCellRenderer() {
        return new DisplayableTreeCellRenderer();
    }

    private JLabel buildSchemaContextPreviewLabel() {
        JLabel jLabel = new JLabel(this.resourceRepository().getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.PREVIEW_TEXT_FIELD"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SCHEMA_CONTEXT_CHOOSER_DIALOG.PREVIEW_TEXT_FIELD"));
        return jLabel;
    }

    private JTextField buildSchemaContextPreviewTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setEnabled(true);
        jTextField.setDocument(this.buildSchemaContextPreviewDocument());
        return jTextField;
    }

    private DocumentAdapter buildSchemaContextPreviewDocument() {
        return new DocumentAdapter(this.buildSelectedSchemaContextStringHolder());
    }

    private PropertyValueModel buildSelectedSchemaContextStringHolder() {
        return new TransformationPropertyValueModel(this.selectedSchemaComponentHolder){

            protected Object transform(Object object) {
                return SchemaContextComponentDisplayer.displayString(SchemaContextChooserDialog.this.resourceRepository(), (MWSchemaContextComponent)object);
            }
        };
    }

    private void schemaContextTreeSelectionChanged() {
        TreePath treePath = this.schemaContextTreeSelectionModel.getSelectionPath();
        Object object = null;
        if (treePath != null && treePath.getLastPathComponent() instanceof SchemaContextComponentNode) {
            object = ((SchemaContextComponentNode)this.schemaContextTreeSelectionModel.getSelectionPath().getLastPathComponent()).getValue();
        }
        this.selectedSchemaComponentHolder.setValue(object);
    }

    public MWNamedSchemaComponent selectedSchemaComponent() {
        return (MWNamedSchemaComponent)this.selectedSchemaComponentHolder.getValue();
    }

    protected void okConfirmed() {
        this.schemaComponentHolder.setValue(this.selectedSchemaComponentHolder.getValue());
        super.okConfirmed();
    }

    protected String helpTopicId() {
        return "dialog.schemaContextChooser";
    }

    public void show() {
        if (!this.schemaRepositoryValue.schemas().hasNext()) {
            this.showErrorDialog();
        } else {
            super.show();
        }
    }

    private void showErrorDialog() {
        Window window = this.currentWindow();
        ResourceRepository resourceRepository = this.resourceRepository();
        String string = resourceRepository.getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.NO_SCHEMAS_LOADED_TITLE");
        String string2 = resourceRepository.getString("SCHEMA_CONTEXT_CHOOSER_DIALOG.NO_SCHEMAS_LOADED_MESSAGE");
        JOptionPane.showMessageDialog(window, string2, string, 2);
    }

    private static final class SchemaContextComponentNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private AbstractTreeNodeValueModel parent;
        private MWNamedSchemaComponent component;
        private ListValueModel childrenModel;

        SchemaContextComponentNode(AbstractTreeNodeValueModel abstractTreeNodeValueModel, MWNamedSchemaComponent mWNamedSchemaComponent) {
            this.initialize(abstractTreeNodeValueModel, mWNamedSchemaComponent);
        }

        private void initialize(AbstractTreeNodeValueModel abstractTreeNodeValueModel, MWNamedSchemaComponent mWNamedSchemaComponent) {
            this.parent = abstractTreeNodeValueModel;
            this.component = mWNamedSchemaComponent;
            this.childrenModel = this.buildChildrenModel();
        }

        protected ListValueModel buildChildrenModel() {
            return new TransformationListValueModelAdapter(this.buildContextComponentsAdapter()){

                protected Object transformItem(Object object) {
                    return SchemaContextComponentNode.this.buildContextComponentNode((MWNamedSchemaComponent)object);
                }
            };
        }

        protected ListValueModel buildContextComponentsAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.component.descriptorContextComponents()));
        }

        protected SchemaContextComponentNode buildContextComponentNode(MWNamedSchemaComponent mWNamedSchemaComponent) {
            return new SchemaContextComponentNode(this, mWNamedSchemaComponent);
        }

        public Object getValue() {
            return this.component;
        }

        public TreeNodeValueModel getParent() {
            return this.parent;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object object) {
            return SchemaContextComponentNodeComparator.compare(this, object);
        }

        public String displayString() {
            return this.component.componentTypeName() + "::" + this.component.qName();
        }

        public Icon icon() {
            return null;
        }

        private static class SchemaContextComponentNodeComparator {
            private SchemaContextComponentNodeComparator() {
            }

            public static int compare(Object object, Object object2) {
                SchemaContextComponentNode schemaContextComponentNode = (SchemaContextComponentNode)object;
                SchemaContextComponentNode schemaContextComponentNode2 = (SchemaContextComponentNode)object2;
                MWNamedSchemaComponent mWNamedSchemaComponent = schemaContextComponentNode.component;
                MWNamedSchemaComponent mWNamedSchemaComponent2 = schemaContextComponentNode2.component;
                int n = SchemaContextComponentNodeComparator.compare(mWNamedSchemaComponent.getTargetNamespace(), mWNamedSchemaComponent2.getTargetNamespace());
                if (n == 0) {
                    n = SchemaContextComponentNodeComparator.compareComponentType(mWNamedSchemaComponent, mWNamedSchemaComponent2);
                }
                if (n == 0) {
                    n = mWNamedSchemaComponent.qName().compareTo(mWNamedSchemaComponent2.qName());
                }
                return n;
            }

            private static int compare(MWNamespace mWNamespace, MWNamespace mWNamespace2) {
                if (mWNamespace.isTargetNamespace() && !mWNamespace2.isTargetNamespace()) {
                    return -1;
                }
                if (!mWNamespace.isTargetNamespace() && mWNamespace2.isTargetNamespace()) {
                    return 1;
                }
                if (mWNamespace.getNamespacePrefix() != mWNamespace2.getNamespacePrefix()) {
                    return mWNamespace.getNamespacePrefix().compareToIgnoreCase(mWNamespace2.getNamespacePrefix());
                }
                return 0;
            }

            private static int compareComponentType(MWNamedSchemaComponent mWNamedSchemaComponent, MWNamedSchemaComponent mWNamedSchemaComponent2) {
                int n = 0;
                int n2 = mWNamedSchemaComponent instanceof MWElementDeclaration ? 1 : (mWNamedSchemaComponent instanceof MWModelGroupDefinition ? 2 : (mWNamedSchemaComponent instanceof MWComplexTypeDefinition ? 3 : 4));
                n = mWNamedSchemaComponent2 instanceof MWElementDeclaration ? 1 : (mWNamedSchemaComponent2 instanceof MWModelGroupDefinition ? 2 : (mWNamedSchemaComponent2 instanceof MWComplexTypeDefinition ? 3 : 4));
                return n2 - n;
            }
        }
    }

    private static final class SchemaNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private SchemaRepositoryNode parent;
        private MWXmlSchema schema;
        private ListValueModel childrenModel;

        SchemaNode(SchemaRepositoryNode schemaRepositoryNode, MWXmlSchema mWXmlSchema) {
            this.initialize(schemaRepositoryNode, mWXmlSchema);
        }

        private void initialize(SchemaRepositoryNode schemaRepositoryNode, MWXmlSchema mWXmlSchema) {
            this.parent = schemaRepositoryNode;
            this.schema = mWXmlSchema;
            this.childrenModel = this.buildChildrenModel();
        }

        private ListValueModel buildChildrenModel() {
            return new SortedListValueModelAdapter(this.buildContextComponentNodesAdapter());
        }

        private ListValueModel buildContextComponentNodesAdapter() {
            return new TransformationListValueModelAdapter(this.buildContextComponentsAdapter()){

                protected Object transformItem(Object object) {
                    return SchemaNode.this.buildContextComponentNode((MWNamedSchemaComponent)object);
                }
            };
        }

        private ListValueModel buildContextComponentsAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.schema.contextComponents()));
        }

        private SchemaContextComponentNode buildContextComponentNode(MWNamedSchemaComponent mWNamedSchemaComponent) {
            return new SchemaContextComponentNode(this, mWNamedSchemaComponent);
        }

        public Object getValue() {
            return this.schema;
        }

        public TreeNodeValueModel getParent() {
            return this.parent;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object object) {
            return DEFAULT_COMPARATOR.compare(this, object);
        }

        public String displayString() {
            return "schema::" + this.schema.getName();
        }

        public Icon icon() {
            return null;
        }
    }

    private static final class SchemaRepositoryNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private SchemaRepositoryValue schemaRepository;
        private ListValueModel childrenModel;

        public SchemaRepositoryNode(SchemaRepositoryValue schemaRepositoryValue) {
            this.initialize(schemaRepositoryValue);
        }

        private void initialize(SchemaRepositoryValue schemaRepositoryValue) {
            this.schemaRepository = schemaRepositoryValue;
            this.childrenModel = this.buildChildrenModel();
        }

        protected ListValueModel buildChildrenModel() {
            return new SortedListValueModelAdapter(this.buildSchemaNodesAdapter());
        }

        protected ListValueModel buildSchemaNodesAdapter() {
            return new TransformationListValueModelAdapter(this.buildSchemasAdapter()){

                protected Object transformItem(Object object) {
                    return SchemaRepositoryNode.this.buildSchemaNode((MWXmlSchema)object);
                }
            };
        }

        protected ListValueModel buildSchemasAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.schemaRepository.schemas()));
        }

        protected SchemaNode buildSchemaNode(MWXmlSchema mWXmlSchema) {
            return new SchemaNode(this, mWXmlSchema);
        }

        public Object getValue() {
            return this.schemaRepository;
        }

        public TreeNodeValueModel getParent() {
            return null;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object object) {
            return DEFAULT_COMPARATOR.compare(this, object);
        }

        public String displayString() {
            return null;
        }

        public Icon icon() {
            return null;
        }
    }
}

