/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class SchemaRootElementChooserDialog
extends AbstractDialog {
    private MWXmlSchema schema;
    private PropertyValueModel rootElementHolder;
    private PropertyValueModel selectedRootElementHolder;
    private TreeSelectionModel treeSelectionModel;

    SchemaRootElementChooserDialog(WorkbenchContext workbenchContext, MWXmlSchema mWXmlSchema, PropertyValueModel propertyValueModel) {
        super(workbenchContext);
        this.initialize(mWXmlSchema, propertyValueModel);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("SCHEMA_ROOT_ELEMENT_CHOOSER_DIALOG.TITLE"));
        this.getOKAction().setEnabled(false);
    }

    private void initialize(MWXmlSchema mWXmlSchema, PropertyValueModel propertyValueModel) {
        this.schema = mWXmlSchema;
        this.rootElementHolder = propertyValueModel;
        this.selectedRootElementHolder = this.buildSelectedRootElementHolder();
        this.treeSelectionModel = this.buildTreeSelectionModel();
    }

    private PropertyValueModel buildSelectedRootElementHolder() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(null);
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildSelectedRootElementListener());
        return simplePropertyValueModel;
    }

    private PropertyChangeListener buildSelectedRootElementListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SchemaRootElementChooserDialog.this.getOKAction().setEnabled(propertyChangeEvent.getNewValue() != null);
            }
        };
    }

    private TreeSelectionModel buildTreeSelectionModel() {
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        defaultTreeSelectionModel.addTreeSelectionListener(this.buildTreeSelectionListener());
        return defaultTreeSelectionModel;
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SchemaRootElementChooserDialog.this.treeSelectionChanged();
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setPreferredSize(new Dimension(350, 350));
        jPanel.add((Component)this.buildTreePane(), "Center");
        return jPanel;
    }

    private JScrollPane buildTreePane() {
        return new JScrollPane(this.buildTree());
    }

    private JTree buildTree() {
        JTree jTree = SwingComponentFactory.buildTree(this.buildTreeModel());
        jTree.setSelectionModel(this.treeSelectionModel);
        jTree.setCellRenderer(this.buildTreeCellRenderer());
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setRowHeight(20);
        jTree.setDoubleBuffered(true);
        jTree.expandRow(0);
        return jTree;
    }

    private TreeModelAdapter buildTreeModel() {
        return new TreeModelAdapter(this.buildTreeRoot());
    }

    private SchemaNode buildTreeRoot() {
        return new SchemaNode(this.schema);
    }

    private TreeCellRenderer buildTreeCellRenderer() {
        return new DisplayableTreeCellRenderer();
    }

    private void treeSelectionChanged() {
        TreePath treePath = this.treeSelectionModel.getSelectionPath();
        Object object = null;
        if (treePath != null) {
            object = ((RootElementNode)this.treeSelectionModel.getSelectionPath().getLastPathComponent()).getValue();
        }
        this.selectedRootElementHolder.setValue(object);
    }

    public MWElementDeclaration selectedRootElement() {
        return (MWElementDeclaration)this.selectedRootElementHolder.getValue();
    }

    protected void okConfirmed() {
        this.rootElementHolder.setValue(this.selectedRootElementHolder.getValue());
        super.okConfirmed();
    }

    protected String helpTopicId() {
        return "dialog.schemaRootElementChooser";
    }

    public void show() {
        if (this.schema == null) {
            this.showErrorDialog();
        } else {
            super.show();
        }
    }

    private void showErrorDialog() {
        Window window = this.currentWindow();
        ResourceRepository resourceRepository = this.resourceRepository();
        String string = resourceRepository.getString("SCHEMA_ROOT_ELEMENT_CHOOSER_DIALOG.NO_CONTEXT_SPECIFIED_TITLE");
        String string2 = resourceRepository.getString("SCHEMA_ROOT_ELEMENT_CHOOSER_DIALOG.NO_CONTEXT_SPECIFIED_MESSAGE");
        JOptionPane.showMessageDialog(window, string2, string, 2);
    }

    private static final class RootElementNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private AbstractTreeNodeValueModel parent;
        private MWElementDeclaration element;

        RootElementNode(AbstractTreeNodeValueModel abstractTreeNodeValueModel, MWElementDeclaration mWElementDeclaration) {
            this.initialize(abstractTreeNodeValueModel, mWElementDeclaration);
        }

        private void initialize(AbstractTreeNodeValueModel abstractTreeNodeValueModel, MWElementDeclaration mWElementDeclaration) {
            this.parent = abstractTreeNodeValueModel;
            this.element = mWElementDeclaration;
        }

        public Object getValue() {
            return this.element;
        }

        public TreeNodeValueModel getParent() {
            return this.parent;
        }

        public ListValueModel getChildrenModel() {
            return NullListValueModel.instance();
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object object) {
            return RootElementNodeComparator.compare(this, object);
        }

        public String displayString() {
            return this.element.qName();
        }

        public Icon icon() {
            return null;
        }

        private static class RootElementNodeComparator {
            private RootElementNodeComparator() {
            }

            public static int compare(Object object, Object object2) {
                RootElementNode rootElementNode = (RootElementNode)object;
                RootElementNode rootElementNode2 = (RootElementNode)object2;
                MWElementDeclaration mWElementDeclaration = rootElementNode.element;
                MWElementDeclaration mWElementDeclaration2 = rootElementNode2.element;
                int n = RootElementNodeComparator.compare(mWElementDeclaration.getTargetNamespace(), mWElementDeclaration2.getTargetNamespace());
                if (n == 0) {
                    n = mWElementDeclaration.qName().compareTo(mWElementDeclaration2.qName());
                }
                return n;
            }

            private static int compare(MWNamespace mWNamespace, MWNamespace mWNamespace2) {
                if (mWNamespace.isTargetNamespace() && !mWNamespace2.isTargetNamespace()) {
                    return -1;
                }
                if (!mWNamespace.isTargetNamespace() && mWNamespace2.isTargetNamespace()) {
                    return 1;
                }
                if (mWNamespace.getNamespacePrefix() != mWNamespace2.getNamespacePrefix()) {
                    return mWNamespace.getNamespacePrefix().compareToIgnoreCase(mWNamespace2.getNamespacePrefix());
                }
                return 0;
            }
        }
    }

    private static final class SchemaNode
    extends AbstractTreeNodeValueModel
    implements Displayable {
        private MWXmlSchema schema;
        private ListValueModel childrenModel;

        public SchemaNode(MWXmlSchema mWXmlSchema) {
            this.initialize(mWXmlSchema);
        }

        private void initialize(MWXmlSchema mWXmlSchema) {
            this.schema = mWXmlSchema;
            this.childrenModel = this.buildChildrenModel();
        }

        private ListValueModel buildChildrenModel() {
            return new SortedListValueModelAdapter(this.buildRootElementNodesAdapter());
        }

        private ListValueModel buildRootElementNodesAdapter() {
            return new TransformationListValueModelAdapter(this.buildRootElementsAdapter()){

                protected Object transformItem(Object object) {
                    return SchemaNode.this.buildRootElementNode((MWElementDeclaration)object);
                }
            };
        }

        private ListValueModel buildRootElementsAdapter() {
            return new SimpleListValueModel(CollectionTools.list((Iterator)this.schema.rootElements()));
        }

        private RootElementNode buildRootElementNode(MWElementDeclaration mWElementDeclaration) {
            return new RootElementNode(this, mWElementDeclaration);
        }

        public Object getValue() {
            return this.schema;
        }

        public TreeNodeValueModel getParent() {
            return null;
        }

        public ListValueModel getChildrenModel() {
            return this.childrenModel;
        }

        protected void engageValue() {
        }

        protected void disengageValue() {
        }

        public int compareTo(Object object) {
            return DEFAULT_COMPARATOR.compare(this, object);
        }

        public String displayString() {
            return null;
        }

        public Icon icon() {
            return null;
        }
    }
}

