/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXpathableSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.AbstractTreeModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.EditingNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.NodeTreeCellEditor;
import org.eclipse.persistence.tools.workbench.uitools.cell.NodeTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.NullTreeCellEditor;
import org.eclipse.persistence.tools.workbench.uitools.cell.RenderingNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SpinnerTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TreeCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class XpathChooserDialog
extends AbstractDialog {
    private ValueModel xmlFieldHolder;
    private PropertyValueModel xpathHolder;
    private BufferedPropertyValueModel selectedXpathHolder;
    private BufferedPropertyValueModel.Trigger xpathTrigger;
    private XpathTreeModel xpathTreeModel;
    private TreeSelectionModel xpathTreeSelectionModel;
    private Object[] selectedPath;
    private StateChangeListener positionListener;

    public static void promptToSelectXpath(MWXmlField mWXmlField, WorkbenchContext workbenchContext) {
        XpathChooserDialog.promptToSelectXpath(new SimplePropertyValueModel(mWXmlField), workbenchContext);
    }

    public static void promptToSelectXpath(ValueModel valueModel, WorkbenchContext workbenchContext) {
        XpathChooserDialog.promptToSelectXpath(valueModel, XpathChooserDialog.buildDefaultXpathHolder(valueModel), workbenchContext);
    }

    public static void promptToSelectXpath(ValueModel valueModel, PropertyValueModel propertyValueModel, WorkbenchContext workbenchContext) {
        Window window = workbenchContext.getCurrentWindow();
        XpathChooserDialog xpathChooserDialog = window instanceof Dialog ? new XpathChooserDialog(workbenchContext, (Dialog)window, valueModel, propertyValueModel) : new XpathChooserDialog(workbenchContext, valueModel, propertyValueModel);
        xpathChooserDialog.show();
    }

    private static PropertyValueModel buildDefaultXpathHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "xpath"){

            protected Object getValueFromSubject() {
                return ((MWXmlField)this.subject).getXpath();
            }

            protected void setValueOnSubject(Object object) {
                ((MWXmlField)this.subject).setXpath((String)object);
            }
        };
    }

    private XpathChooserDialog(WorkbenchContext workbenchContext, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        super(workbenchContext);
        this.initialize(valueModel, propertyValueModel);
    }

    private XpathChooserDialog(WorkbenchContext workbenchContext, Dialog dialog, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        super(workbenchContext, dialog);
        this.initialize(valueModel, propertyValueModel);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("XPATH_CHOOSER_DIALOG.TITLE"));
        this.getOKAction().setEnabled(false);
    }

    private void initialize(ValueModel valueModel, PropertyValueModel propertyValueModel) {
        this.xmlFieldHolder = valueModel;
        this.xpathHolder = propertyValueModel;
        this.xpathTrigger = new BufferedPropertyValueModel.Trigger();
        this.selectedXpathHolder = this.buildSelectedXpathHolder(this.xpathHolder, this.xpathTrigger);
        this.xpathTreeModel = this.buildXpathTreeModel();
        this.xpathTreeSelectionModel = this.buildXpathTreeSelectionModel();
        this.selectedPath = new Object[0];
        this.positionListener = this.buildPositionListener();
    }

    private BufferedPropertyValueModel buildSelectedXpathHolder(PropertyValueModel propertyValueModel, BufferedPropertyValueModel.Trigger trigger) {
        BufferedPropertyValueModel bufferedPropertyValueModel = new BufferedPropertyValueModel(propertyValueModel, trigger);
        bufferedPropertyValueModel.addPropertyChangeListener("value", this.buildSelectedXpathListener());
        return bufferedPropertyValueModel;
    }

    private PropertyChangeListener buildSelectedXpathListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                XpathChooserDialog.this.getOKAction().setEnabled(!"".equals(propertyChangeEvent.getNewValue()));
            }
        };
    }

    private XpathTreeModel buildXpathTreeModel() {
        return new XpathTreeModel(this.xmlField().schemaContext(), this.xmlField().xpathSpec());
    }

    private TreeSelectionModel buildXpathTreeSelectionModel() {
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        return defaultTreeSelectionModel;
    }

    private StateChangeListener buildPositionListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent stateChangeEvent) {
                XpathChooserDialog.this.rebuildXpath();
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setPreferredSize(new Dimension(350, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.buildXpathTreePane(), gridBagConstraints);
        JLabel jLabel = this.buildXpathPreviewLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = this.buildXpathPreviewTextField();
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildXpathTreePane() {
        return new JScrollPane(this.buildXpathTree());
    }

    private JTree buildXpathTree() {
        JTree jTree = SwingComponentFactory.buildTree(this.xpathTreeModel);
        jTree.setSelectionModel(this.xpathTreeSelectionModel);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setEditable(true);
        jTree.setInvokesStopCellEditing(true);
        jTree.setCellRenderer(this.buildTreeCellRenderer());
        jTree.setCellEditor(this.buildTreeCellEditor());
        jTree.setRowHeight(20);
        jTree.addTreeSelectionListener(this.buildTreeSelectionListener());
        return jTree;
    }

    private TreeCellRenderer buildTreeCellRenderer() {
        return new NodeTreeCellRenderer();
    }

    private TreeCellEditor buildTreeCellEditor() {
        return new NodeTreeCellEditor();
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                XpathChooserDialog.this.xpathTreeSelectionChanged();
            }
        };
    }

    private JLabel buildXpathPreviewLabel() {
        JLabel jLabel = new JLabel("XPath:");
        jLabel.setDisplayedMnemonic('X');
        return jLabel;
    }

    private JTextField buildXpathPreviewTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setEnabled(true);
        jTextField.setDocument(this.buildXpathPreviewDocument());
        return jTextField;
    }

    private DocumentAdapter buildXpathPreviewDocument() {
        return new DocumentAdapter(this.buildSelectedXpathDisplayStringHolder());
    }

    private PropertyValueModel buildSelectedXpathDisplayStringHolder() {
        return new TransformationPropertyValueModel(this.selectedXpathHolder){

            protected Object transform(Object object) {
                if ("".equals(object)) {
                    return XpathChooserDialog.this.resourceRepository().getString("NONE_SELECTED");
                }
                return (String)object;
            }
        };
    }

    protected void okConfirmed() {
        this.xpathTrigger.accept();
        super.okConfirmed();
    }

    protected String helpTopicId() {
        return "dialog.xpathChooser";
    }

    private MWXmlField xmlField() {
        return (MWXmlField)this.xmlFieldHolder.getValue();
    }

    private void xpathTreeSelectionChanged() {
        int n = this.selectedPath.length;
        while (n-- > 0) {
            ((XpathTreeNode)this.selectedPath[n]).removeStateChangeListener(this.positionListener);
        }
        TreePath treePath = this.xpathTreeSelectionModel.getSelectionPath();
        this.selectedPath = treePath == null ? new Object[0] : treePath.getPath();
        int n2 = this.selectedPath.length;
        while (n2-- > 0) {
            ((XpathTreeNode)this.selectedPath[n2]).addStateChangeListener(this.positionListener);
        }
        this.rebuildXpath();
    }

    private void rebuildXpath() {
        String string = "";
        TreePath treePath = this.xpathTreeSelectionModel.getSelectionPath();
        if (treePath != null) {
            string = ((XpathTreeNode)treePath.getLastPathComponent()).xpath();
        }
        this.selectedXpathHolder.setValue(string);
    }

    public void show() {
        if (this.xmlField().schemaContext() == null) {
            this.showErrorDialog();
        } else {
            super.show();
        }
    }

    private void showErrorDialog() {
        Window window = this.currentWindow();
        ResourceRepository resourceRepository = this.resourceRepository();
        String string = resourceRepository.getString("XPATH_CHOOSER_DIALOG.NO_CONTEXT_SPECIFIED_TITLE");
        String string2 = resourceRepository.getString("XPATH_CHOOSER_DIALOG.NO_CONTEXT_SPECIFIED_MESSAGE");
        JOptionPane.showMessageDialog(window, string2, string, 2);
    }

    private static final class ElementPositionSpinnerModel
    extends AbstractSpinnerModel {
        private int value;
        private int min;
        private int max;

        ElementPositionSpinnerModel(int n, int n2, int n3) {
            this.value = n;
            this.min = n2;
            this.max = n3;
        }

        public Object getValue() {
            return this.value == 0 ? "all" : String.valueOf(this.value);
        }

        public void setValue(Object object) {
            if (object == null || !(object instanceof String)) {
                throw new IllegalArgumentException("illegal value: " + object);
            }
            int n = this.value;
            if (object.equals("all")) {
                this.value = 0;
            } else {
                try {
                    this.value = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n != this.value) {
                this.fireStateChanged();
            }
        }

        public Object getPreviousValue() {
            if (this.value == 0) {
                return null;
            }
            if (this.value == this.min) {
                return "all";
            }
            return String.valueOf(this.value - 1);
        }

        public Object getNextValue() {
            if (this.value == this.max) {
                return null;
            }
            return String.valueOf(this.value + 1);
        }
    }

    private static final class ElementNode
    extends XpathableComponentNode {
        private MWXpathSpec xpathSpec;
        private int position;
        private boolean textBuiltIn;

        protected ElementNode(XpathTreeNode xpathTreeNode, MWElementDeclaration mWElementDeclaration, MWXpathSpec mWXpathSpec) {
            super(xpathTreeNode, (MWXpathableSchemaComponent)mWElementDeclaration);
            this.initialize(mWXpathSpec);
        }

        private void initialize(MWXpathSpec mWXpathSpec) {
            this.xpathSpec = mWXpathSpec;
            this.position = this.initialPosition();
            this.textBuiltIn = this.calculateTextBuiltIn();
        }

        private boolean calculateTextBuiltIn() {
            return !this.xpathSpec.mayUseComplexData() && this.xpathSpec.mayUseSimpleData() && this.xpathComponent.containsText() && CollectionTools.size((Iterator)this.xpathComponent.xpathComponents()) == 0;
        }

        protected Iterator newChildren() {
            return new CompositeIterator(this.newTextChildren(), this.newComponentChildren());
        }

        protected Iterator newTextChildren() {
            if (!this.textBuiltIn && this.xpathSpec.mayUseSimpleData() && this.xpathComponent.containsText()) {
                return new SingleElementIterator(this.buildChildTextNode());
            }
            return NullIterator.instance();
        }

        private Object buildChildTextNode() {
            return new TextNode(this);
        }

        protected Iterator newComponentChildren() {
            return new TransformationIterator(this.specXpathComponents()){

                protected Object transform(Object object) {
                    return ElementNode.this.buildChildNode((MWXpathableSchemaComponent)object);
                }
            };
        }

        private Iterator specXpathComponents() {
            return new FilteringIterator(this.xpathComponents()){

                protected boolean accept(Object object) {
                    if (object instanceof MWAttributeDeclaration) {
                        return ElementNode.this.xpathSpec.mayUseSimpleData();
                    }
                    return true;
                }
            };
        }

        private Iterator xpathComponents() {
            return this.xpathComponent.xpathComponents();
        }

        private Object buildChildNode(MWXpathableSchemaComponent mWXpathableSchemaComponent) {
            return XpathableComponentNode.buildNode(this, mWXpathableSchemaComponent, this.xpathSpec);
        }

        public Object getCellValue() {
            return this.position == 0 ? "all" : String.valueOf(this.position);
        }

        protected TreeCellRenderer buildRenderer() {
            if (this.canSetPosition()) {
                return this.buildSpinnerRenderer();
            }
            return this.buildSimpleRenderer();
        }

        private SpinnerTreeCellRenderer buildSpinnerRenderer() {
            return new SpinnerTreeCellRenderer(this.displayString(), this.buildSpinnerModel()){

                protected JComponent buildComponent() {
                    JSpinner jSpinner = (JSpinner)super.buildComponent();
                    jSpinner.setPreferredSize(new Dimension(40, jSpinner.getPreferredSize().height));
                    JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
                    jFormattedTextField.setEditable(false);
                    jFormattedTextField.setColumns(4);
                    return jSpinner;
                }
            };
        }

        private SpinnerModel buildSpinnerModel() {
            return new ElementPositionSpinnerModel(this.position, this.minPosition(), this.maxPosition());
        }

        protected TreeCellEditor buildEditor() {
            if (this.canSetPosition()) {
                return this.buildSpinnerEditor();
            }
            return NullTreeCellEditor.instance();
        }

        private TreeCellEditor buildSpinnerEditor() {
            return new TreeCellEditorAdapter(this.buildSpinnerRenderer());
        }

        protected String displayString() {
            String string = this.xpathComponent.qName();
            if (this.textBuiltIn) {
                string = string + "/text()";
            }
            return string;
        }

        private MWElementDeclaration element() {
            return (MWElementDeclaration)this.xpathComponent;
        }

        private boolean canSetPosition() {
            return this.maxPosition() > 1;
        }

        private int initialPosition() {
            return this.canSetPosition() ? this.minPosition() : 0;
        }

        private int minPosition() {
            return this.xpathSpec.mayUseCollectionData() ? 0 : 1;
        }

        private int maxPosition() {
            return this.element().getMaxOccurs();
        }

        void setPosition(String string) {
            int n = this.position;
            this.position = string.equals("all") ? 0 : Integer.parseInt(string);
            if (n != this.position) {
                this.fireStateChanged();
            }
        }

        String xpathStepString() {
            String string = this.xpathComponent.qName();
            if (this.position != 0) {
                string = string + "[" + this.position + "]";
            }
            if (this.textBuiltIn) {
                string = string + "/text()";
            }
            return string;
        }
    }

    private static final class AttributeNode
    extends XpathableComponentNode {
        AttributeNode(XpathTreeNode xpathTreeNode, MWAttributeDeclaration mWAttributeDeclaration) {
            super(xpathTreeNode, (MWXpathableSchemaComponent)mWAttributeDeclaration);
        }

        protected Iterator newChildren() {
            return NullIterator.instance();
        }

        private String internalXpathStepString() {
            return "@" + this.xpathComponent.qName();
        }

        public TreeCellRenderer buildRenderer() {
            return this.buildSimpleRenderer();
        }

        public TreeCellEditor buildEditor() {
            return NullTreeCellEditor.instance();
        }

        protected String displayString() {
            return this.internalXpathStepString();
        }

        String xpathStepString() {
            return this.internalXpathStepString();
        }
    }

    private static abstract class XpathableComponentNode
    extends XpathTreeNode {
        protected MWXpathableSchemaComponent xpathComponent;

        static XpathableComponentNode buildNode(XpathTreeNode xpathTreeNode, MWXpathableSchemaComponent mWXpathableSchemaComponent, MWXpathSpec mWXpathSpec) {
            if (mWXpathableSchemaComponent instanceof MWAttributeDeclaration) {
                return new AttributeNode(xpathTreeNode, (MWAttributeDeclaration)mWXpathableSchemaComponent);
            }
            if (mWXpathableSchemaComponent instanceof MWElementDeclaration) {
                return new ElementNode(xpathTreeNode, (MWElementDeclaration)mWXpathableSchemaComponent, mWXpathSpec);
            }
            throw new IllegalArgumentException("Illegal xpath component");
        }

        protected XpathableComponentNode(XpathTreeNode xpathTreeNode, MWXpathableSchemaComponent mWXpathableSchemaComponent) {
            super(xpathTreeNode);
            this.xpathComponent = mWXpathableSchemaComponent;
        }

        public Object getCellValue() {
            return null;
        }

        protected SimpleTreeCellRenderer buildSimpleRenderer() {
            return new SimpleTreeCellRenderer(){

                protected Icon buildIcon(Object object) {
                    return null;
                }

                protected String buildText(Object object) {
                    return XpathableComponentNode.this.displayString();
                }
            };
        }

        protected abstract String displayString();
    }

    private static class TextNode
    extends XpathTreeNode {
        TextNode(XpathTreeNode xpathTreeNode) {
            super(xpathTreeNode);
        }

        protected Iterator newChildren() {
            return NullIterator.instance();
        }

        public Object getCellValue() {
            return null;
        }

        protected TreeCellRenderer buildRenderer() {
            return new SimpleTreeCellRenderer(){

                protected Icon buildIcon(Object object) {
                    return null;
                }

                protected String buildText(Object object) {
                    return "text()";
                }
            };
        }

        protected TreeCellEditor buildEditor() {
            return NullTreeCellEditor.instance();
        }

        String xpathStepString() {
            return "text()";
        }
    }

    private static final class SchemaContextNode
    extends XpathTreeNode
    implements RenderingNode {
        private MWSchemaContextComponent contextComponent;
        private MWXpathSpec xpathSpec;

        SchemaContextNode(MWSchemaContextComponent mWSchemaContextComponent, MWXpathSpec mWXpathSpec) {
            super(null);
            this.initialize(mWSchemaContextComponent, mWXpathSpec);
        }

        private void initialize(MWSchemaContextComponent mWSchemaContextComponent, MWXpathSpec mWXpathSpec) {
            this.contextComponent = mWSchemaContextComponent;
            this.xpathSpec = mWXpathSpec;
        }

        protected Iterator newChildren() {
            return new CompositeIterator(this.newTextChildren(), this.newComponentChildren());
        }

        protected Iterator newTextChildren() {
            if (this.xpathSpec.mayUseSimpleData() && this.contextComponent.containsText()) {
                return new SingleElementIterator(this.buildChildTextNode());
            }
            return NullIterator.instance();
        }

        private Object buildChildTextNode() {
            return new TextNode(this);
        }

        protected Iterator newComponentChildren() {
            return new TransformationIterator(this.specXpathComponents()){

                protected Object transform(Object object) {
                    return SchemaContextNode.this.buildChildComponentNode((MWXpathableSchemaComponent)object);
                }
            };
        }

        private Iterator specXpathComponents() {
            return new FilteringIterator(this.xpathComponents()){

                protected boolean accept(Object object) {
                    if (object instanceof MWAttributeDeclaration) {
                        return SchemaContextNode.this.xpathSpec.mayUseSimpleData();
                    }
                    return true;
                }
            };
        }

        private Iterator xpathComponents() {
            return this.contextComponent == null ? NullIterator.instance() : this.contextComponent.xpathComponents();
        }

        private Object buildChildComponentNode(MWXpathableSchemaComponent mWXpathableSchemaComponent) {
            return XpathableComponentNode.buildNode(this, mWXpathableSchemaComponent, this.xpathSpec);
        }

        public Object getCellValue() {
            return this.contextComponent;
        }

        public TreeCellRenderer buildRenderer() {
            return new SimpleTreeCellRenderer(){

                protected Icon buildIcon(Object object) {
                    return null;
                }

                protected String buildText(Object object) {
                    return "";
                }
            };
        }

        protected TreeCellEditor buildEditor() {
            return NullTreeCellEditor.instance();
        }

        String xpathStepString() {
            return "";
        }
    }

    private static abstract class XpathTreeNode
    extends AbstractModel
    implements RenderingNode,
    EditingNode {
        private XpathTreeNode parent;
        private List children;
        private TreeCellRenderer renderer;
        private TreeCellEditor editor;

        protected XpathTreeNode(XpathTreeNode xpathTreeNode) {
            this.parent = xpathTreeNode;
        }

        private List getChildren() {
            if (this.children == null) {
                this.children = this.buildChildren();
            }
            return this.children;
        }

        private List buildChildren() {
            return CollectionTools.list((Iterator)this.newChildren());
        }

        protected abstract Iterator newChildren();

        public TreeCellRenderer getRenderer() {
            if (this.renderer == null) {
                this.renderer = this.buildRenderer();
            }
            return this.renderer;
        }

        protected abstract TreeCellRenderer buildRenderer();

        public TreeCellEditor getEditor() {
            if (this.editor == null) {
                this.editor = this.buildEditor();
            }
            return this.editor;
        }

        protected abstract TreeCellEditor buildEditor();

        XpathTreeNode getParent() {
            return this.parent;
        }

        Iterator children() {
            return this.getChildren().iterator();
        }

        int childrenSize() {
            return this.getChildren().size();
        }

        XpathTreeNode child(int n) {
            return (XpathTreeNode)this.getChildren().get(n);
        }

        int childIndex(XpathTreeNode xpathTreeNode) {
            return this.getChildren().indexOf(xpathTreeNode);
        }

        boolean isLeaf() {
            return this.childrenSize() == 0;
        }

        String xpath() {
            if (this.parent == null) {
                return this.xpathStepString();
            }
            String string = this.parent.xpath();
            if ("".equals(string)) {
                return this.xpathStepString();
            }
            return string + "/" + this.xpathStepString();
        }

        abstract String xpathStepString();
    }

    private static final class XpathTreeModel
    extends AbstractTreeModel {
        private SchemaContextNode contextNode;

        private XpathTreeModel() {
        }

        XpathTreeModel(MWSchemaContextComponent mWSchemaContextComponent, MWXpathSpec mWXpathSpec) {
            this();
            this.initialize(mWSchemaContextComponent, mWXpathSpec);
        }

        private void initialize(MWSchemaContextComponent mWSchemaContextComponent, MWXpathSpec mWXpathSpec) {
            this.contextNode = new SchemaContextNode(mWSchemaContextComponent, mWXpathSpec);
        }

        public Object getRoot() {
            return this.contextNode;
        }

        public Object getChild(Object object, int n) {
            return ((XpathTreeNode)object).child(n);
        }

        public int getChildCount(Object object) {
            return ((XpathTreeNode)object).childrenSize();
        }

        public boolean isLeaf(Object object) {
            return ((XpathTreeNode)object).isLeaf();
        }

        public int getIndexOfChild(Object object, Object object2) {
            return ((XpathTreeNode)object).childIndex((XpathTreeNode)object2);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            ElementNode elementNode = (ElementNode)treePath.getLastPathComponent();
            elementNode.setPosition((String)object);
            this.fireTreeNodeChanged(treePath.getParentPath().getPath(), this.getIndexOfChild(elementNode.getParent(), elementNode), elementNode);
        }
    }
}

